/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DoubleKeyValueMap<K1, K2, V> {
    private ConcurrentHashMap<K1, ConcurrentHashMap<K2, V>> k1_k2V_map = new ConcurrentHashMap();

    public void put(K1 key1, K2 key2, V value) {
        if (this.k1_k2V_map.containsKey(key1)) {
            ConcurrentHashMap<K2, V> k2V_map = this.k1_k2V_map.get(key1);
            k2V_map.put(key2, value);
        } else {
            ConcurrentHashMap<K2, V> k2V_map = new ConcurrentHashMap<K2, V>();
            k2V_map.put(key2, value);
            this.k1_k2V_map.put(key1, k2V_map);
        }
    }

    public Set<K1> getFirstKeys() {
        return this.k1_k2V_map.keySet();
    }

    public V get(K1 key1, K2 key2) {
        ConcurrentHashMap<K2, V> k2_v = this.k1_k2V_map.get(key1);
        return k2_v == null ? null : (V)k2_v.get(key2);
    }

    public ConcurrentHashMap<K2, V> get(K1 key1) {
        return this.k1_k2V_map.get(key1);
    }

    public boolean containsKey(K1 key1, K2 key2) {
        if (this.k1_k2V_map.containsKey(key1)) {
            return this.k1_k2V_map.get(key1).containsKey(key2);
        }
        return false;
    }

    public boolean containsKey(K1 key1) {
        return this.k1_k2V_map.containsKey(key1);
    }

    public void clear() {
        if (this.k1_k2V_map.size() > 0) {
            for (ConcurrentHashMap<K2, V> k2V_map : this.k1_k2V_map.values()) {
                k2V_map.clear();
            }
            this.k1_k2V_map.clear();
        }
    }
}

