/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import android.text.TextUtils;
import com.android.pc.ioc.db.table.ColumnUtils;
import java.util.ArrayList;
import java.util.List;

public class WhereBuilder {
    private List<String> whereItems = new ArrayList<String>();

    private WhereBuilder() {
    }

    public static WhereBuilder b() {
        return new WhereBuilder();
    }

    public static WhereBuilder b(String columnName, String op, Object value) {
        WhereBuilder result = new WhereBuilder();
        result.appendCondition(null, columnName, op, value);
        return result;
    }

    public WhereBuilder append(String columnName, String op, Object value) {
        this.appendCondition(this.whereItems.size() == 0 ? null : "AND", columnName, op, value);
        return this;
    }

    public WhereBuilder appendOR(String columnName, String op, Object value) {
        this.appendCondition(this.whereItems.size() == 0 ? null : "OR", columnName, op, value);
        return this;
    }

    public WhereBuilder append(String columnName) {
        this.whereItems.add(columnName);
        return this;
    }

    public String toString() {
        if (this.whereItems == null || this.whereItems.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String item : this.whereItems) {
            sb.append(item);
        }
        return sb.toString();
    }

    private void appendCondition(String conj, String columnName, String op, Object value) {
        StringBuilder sqlSb = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)conj)) {
            sqlSb.append(" " + conj + " ");
        }
        if ("!=".equals(op)) {
            op = "<>";
        } else if ("==".equals(op)) {
            op = "=";
        }
        if (value == null) {
            if ("=".equals(op)) {
                sqlSb.append(columnName).append(" IS NULL");
            } else if ("<>".equals(op)) {
                sqlSb.append(columnName).append(" IS NOT NULL");
            } else {
                sqlSb.append(columnName).append(" " + op + " NULL");
            }
        } else {
            sqlSb.append(columnName).append(" " + op + " ");
            value = ColumnUtils.convert2DbColumnValueIfNeeded(value);
            if ("TEXT".equals(ColumnUtils.fieldType2DbType(value.getClass()))) {
                String valueStr = value.toString();
                if (valueStr.indexOf(39) != -1) {
                    valueStr = valueStr.replace("'", "''");
                }
                sqlSb.append("'" + valueStr + "'");
            } else {
                sqlSb.append(value);
            }
        }
        this.whereItems.add(sqlSb.toString());
    }
}

