/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.table;

import android.text.TextUtils;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.annotation.Check;
import com.android.pc.ioc.db.annotation.Column;
import com.android.pc.ioc.db.annotation.Id;
import com.android.pc.ioc.db.annotation.NotNull;
import com.android.pc.ioc.db.annotation.Transient;
import com.android.pc.ioc.db.annotation.Unique;
import com.android.pc.ioc.db.sqlite.FinderLazyLoader;
import com.android.pc.ioc.db.sqlite.ForeignLazyLoader;
import com.android.pc.ioc.db.table.Finder;
import com.android.pc.ioc.db.table.Foreign;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Date;
import java.util.List;

public class ColumnUtils {
    private ColumnUtils() {
    }

    public static Method getColumnGetMethod(Class<?> entityType, Field field) {
        String fieldName = field.getName();
        Method getMethod = null;
        if (field.getType() == Boolean.TYPE) {
            getMethod = ColumnUtils.getBooleanColumnGetMethod(entityType, fieldName);
        }
        if (getMethod == null) {
            String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                getMethod = entityType.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Ioc.getIoc().getLogger().d(String.valueOf(methodName) + " not exist");
            }
        }
        if (getMethod == null && !Object.class.equals(entityType.getSuperclass())) {
            return ColumnUtils.getColumnGetMethod(entityType.getSuperclass(), field);
        }
        return getMethod;
    }

    public static Method getColumnSetMethod(Class<?> entityType, Field field) {
        String fieldName = field.getName();
        Method setMethod = null;
        if (field.getType() == Boolean.TYPE) {
            setMethod = ColumnUtils.getBooleanColumnSetMethod(entityType, field);
        }
        if (setMethod == null) {
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                setMethod = entityType.getDeclaredMethod(methodName, field.getType());
            }
            catch (NoSuchMethodException e) {
                Ioc.getIoc().getLogger().d(String.valueOf(methodName) + " not exist");
            }
        }
        if (setMethod == null && !Object.class.equals(entityType.getSuperclass())) {
            return ColumnUtils.getColumnSetMethod(entityType.getSuperclass(), field);
        }
        return setMethod;
    }

    public static String getColumnNameByField(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && !TextUtils.isEmpty((CharSequence)column.column())) {
            return column.column();
        }
        Id id = field.getAnnotation(Id.class);
        if (id != null && !TextUtils.isEmpty((CharSequence)id.column())) {
            return id.column();
        }
        com.android.pc.ioc.db.annotation.Foreign foreign = field.getAnnotation(com.android.pc.ioc.db.annotation.Foreign.class);
        if (foreign != null && !TextUtils.isEmpty((CharSequence)foreign.column())) {
            return foreign.column();
        }
        com.android.pc.ioc.db.annotation.Finder finder = field.getAnnotation(com.android.pc.ioc.db.annotation.Finder.class);
        if (finder != null) {
            return field.getName();
        }
        return field.getName();
    }

    public static String getForeignColumnNameByField(Field field) {
        com.android.pc.ioc.db.annotation.Foreign foreign = field.getAnnotation(com.android.pc.ioc.db.annotation.Foreign.class);
        if (foreign != null) {
            return foreign.foreign();
        }
        return field.getName();
    }

    public static Object getColumnDefaultValue(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && !TextUtils.isEmpty((CharSequence)column.defaultValue())) {
            return ColumnUtils.valueStr2SimpleTypeFieldValue(field.getType(), column.defaultValue());
        }
        return null;
    }

    public static boolean isTransient(Field field) {
        return field.getAnnotation(Transient.class) != null;
    }

    public static boolean isForeign(Field field) {
        return field.getAnnotation(com.android.pc.ioc.db.annotation.Foreign.class) != null;
    }

    public static boolean isFinder(Field field) {
        return field.getAnnotation(com.android.pc.ioc.db.annotation.Finder.class) != null;
    }

    public static boolean isSimpleColumnType(Field field) {
        Class<?> clazz = field.getType();
        return ColumnUtils.isSimpleColumnType(clazz);
    }

    public static boolean isSimpleColumnType(Class columnType) {
        return columnType.isPrimitive() || columnType.equals(String.class) || columnType.equals(Integer.class) || columnType.equals(Long.class) || columnType.equals(java.util.Date.class) || columnType.equals(Date.class) || columnType.equals(Boolean.class) || columnType.equals(Float.class) || columnType.equals(Double.class) || columnType.equals(Byte.class) || columnType.equals(Short.class) || columnType.equals(CharSequence.class) || columnType.equals(Character.class);
    }

    public static boolean isUnique(Field field) {
        return field.getAnnotation(Unique.class) != null;
    }

    public static boolean isNotNull(Field field) {
        return field.getAnnotation(NotNull.class) != null;
    }

    public static String getCheck(Field field) {
        Check check = field.getAnnotation(Check.class);
        if (check != null) {
            return check.value();
        }
        return null;
    }

    public static Object valueStr2SimpleTypeFieldValue(Class columnFieldType, String valueStr) {
        Object value = null;
        if (ColumnUtils.isSimpleColumnType(columnFieldType) && valueStr != null) {
            if (columnFieldType.equals(String.class) || columnFieldType.equals(CharSequence.class)) {
                value = valueStr;
            } else if (columnFieldType.equals(Integer.TYPE) || columnFieldType.equals(Integer.class)) {
                value = Integer.valueOf(valueStr);
            } else if (columnFieldType.equals(Long.TYPE) || columnFieldType.equals(Long.class)) {
                value = Long.valueOf(valueStr);
            } else if (columnFieldType.equals(Date.class)) {
                value = new Date(Long.valueOf(valueStr));
            } else if (columnFieldType.equals(java.util.Date.class)) {
                value = new java.util.Date(Long.valueOf(valueStr));
            } else if (columnFieldType.equals(Boolean.TYPE) || columnFieldType.equals(Boolean.class)) {
                value = ColumnUtils.convert2Boolean(valueStr);
            } else if (columnFieldType.equals(Float.TYPE) || columnFieldType.equals(Float.class)) {
                value = Float.valueOf(valueStr);
            } else if (columnFieldType.equals(Double.TYPE) || columnFieldType.equals(Double.class)) {
                value = Double.valueOf(valueStr);
            } else if (columnFieldType.equals(Byte.TYPE) || columnFieldType.equals(Byte.class)) {
                value = Byte.valueOf(valueStr);
            } else if (columnFieldType.equals(Short.TYPE) || columnFieldType.equals(Short.class)) {
                value = Short.valueOf(valueStr);
            } else if (columnFieldType.equals(Character.TYPE) || columnFieldType.equals(Character.class)) {
                value = Character.valueOf(valueStr.charAt(0));
            }
        }
        return value;
    }

    public static Class<?> getForeignEntityType(Foreign foreignColumn) {
        Class result = foreignColumn.getColumnField().getType();
        if (result.equals(ForeignLazyLoader.class) || result.equals(List.class)) {
            result = (Class)((ParameterizedType)foreignColumn.getColumnField().getGenericType()).getActualTypeArguments()[0];
        }
        return result;
    }

    public static Class<?> getFinderTargetEntityType(Finder finderColumn) {
        Class result = finderColumn.getColumnField().getType();
        if (result.equals(FinderLazyLoader.class) || result.equals(List.class)) {
            result = (Class)((ParameterizedType)finderColumn.getColumnField().getGenericType()).getActualTypeArguments()[0];
        }
        return result;
    }

    public static Boolean convert2Boolean(Object value) {
        if (value != null) {
            String valueStr = value.toString();
            return valueStr.length() == 1 ? "1".equals(valueStr) : Boolean.valueOf(valueStr).booleanValue();
        }
        return false;
    }

    public static Object convert2DbColumnValueIfNeeded(Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            if (value instanceof java.util.Date) {
                return ((java.util.Date)value).getTime();
            }
        }
        return value;
    }

    public static String fieldType2DbType(Class<?> fieldType) {
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class) || fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class) || fieldType.equals(java.util.Date.class) || fieldType.equals(Date.class) || fieldType.equals(Long.TYPE) || fieldType.equals(Long.class) || fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class) || fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
            return "INTEGER";
        }
        if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class) || fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
            return "REAL";
        }
        return "TEXT";
    }

    private static boolean isStartWithIs(String fieldName) {
        return fieldName != null && fieldName.startsWith("is");
    }

    private static Method getBooleanColumnGetMethod(Class<?> entityType, String fieldName) {
        String methodName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (ColumnUtils.isStartWithIs(fieldName)) {
            methodName = fieldName;
        }
        try {
            return entityType.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Ioc.getIoc().getLogger().d(String.valueOf(methodName) + " not exist");
            return null;
        }
    }

    private static Method getBooleanColumnSetMethod(Class<?> entityType, Field field) {
        String fieldName = field.getName();
        String methodName = null;
        methodName = ColumnUtils.isStartWithIs(field.getName()) ? "set" + fieldName.substring(2, 3).toUpperCase() + fieldName.substring(3) : "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return entityType.getDeclaredMethod(methodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            Ioc.getIoc().getLogger().d(String.valueOf(methodName) + " not exist");
            return null;
        }
    }
}

