/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.table;

import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.sqlite.DbUtils;
import com.android.pc.ioc.db.sqlite.ForeignLazyLoader;
import com.android.pc.ioc.db.table.Column;
import com.android.pc.ioc.db.table.ColumnUtils;
import com.android.pc.ioc.db.table.TableUtils;
import java.lang.reflect.Field;
import java.util.List;

public class Foreign
extends Column {
    public DbUtils db;
    private String foreignColumnName;

    protected Foreign(Class entityType, Field field) {
        super(entityType, field);
        this.foreignColumnName = ColumnUtils.getForeignColumnNameByField(field);
    }

    public String getForeignColumnName() {
        return this.foreignColumnName;
    }

    public Class<?> getForeignEntityType() {
        return ColumnUtils.getForeignEntityType(this);
    }

    public Class<?> getForeignColumnType() {
        return TableUtils.getColumnOrId(this.getForeignEntityType(), (String)this.foreignColumnName).columnField.getType();
    }

    @Override
    public void setValue2Entity(Object entity, String valueStr) {
        Object value = null;
        if (valueStr != null) {
            Class<?> columnType = this.columnField.getType();
            Object columnValue = ColumnUtils.valueStr2SimpleTypeFieldValue(this.getForeignColumnType(), valueStr);
            if (columnType.equals(ForeignLazyLoader.class)) {
                value = new ForeignLazyLoader(this, columnValue);
            } else if (columnType.equals(List.class)) {
                try {
                    value = new ForeignLazyLoader(this, columnValue).getAllFromDb();
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            } else {
                try {
                    value = new ForeignLazyLoader(this, columnValue).getFirstFromDb();
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            }
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, value);
            }
            catch (Exception e) {
                Ioc.getIoc().getLogger().e(e);
            }
        } else {
            try {
                this.columnField.setAccessible(true);
                this.columnField.set(entity, value);
            }
            catch (Exception e) {
                Ioc.getIoc().getLogger().e(e);
            }
        }
    }

    @Override
    public Object getColumnValue(Object entity) {
        Object valueObj = this.getFieldValue(entity);
        if (valueObj != null) {
            Class<?> columnType = this.columnField.getType();
            if (columnType.equals(ForeignLazyLoader.class)) {
                valueObj = ((ForeignLazyLoader)valueObj).getColumnValue();
            } else if (columnType.equals(List.class)) {
                try {
                    List foreignEntities = (List)valueObj;
                    if (foreignEntities.size() > 0) {
                        if (this.db != null) {
                            this.db.saveOrUpdateAll(foreignEntities);
                        }
                        Class<?> foreignEntityType = ColumnUtils.getForeignEntityType(this);
                        Column column = TableUtils.getColumnOrId(foreignEntityType, this.foreignColumnName);
                        valueObj = column.getColumnValue(foreignEntities.get(0));
                    }
                }
                catch (Exception e) {
                    valueObj = null;
                    Ioc.getIoc().getLogger().e(e);
                }
            } else {
                try {
                    if (this.db != null) {
                        try {
                            this.db.saveOrUpdate(valueObj);
                        }
                        catch (Exception e) {
                            Ioc.getIoc().getLogger().e(e);
                        }
                    }
                    Column column = TableUtils.getColumnOrId(columnType, this.foreignColumnName);
                    valueObj = column.getColumnValue(valueObj);
                }
                catch (Exception e) {
                    valueObj = null;
                    Ioc.getIoc().getLogger().e(e);
                }
            }
        }
        return ColumnUtils.convert2DbColumnValueIfNeeded(valueObj);
    }

    public Object getFieldValue(Object entity) {
        Object valueObj = null;
        if (entity != null) {
            if (this.getMethod != null) {
                try {
                    valueObj = this.getMethod.invoke(entity, new Object[0]);
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            } else {
                try {
                    this.columnField.setAccessible(true);
                    valueObj = this.columnField.get(entity);
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            }
        }
        return valueObj;
    }

    @Override
    public String getColumnDbType() {
        return ColumnUtils.fieldType2DbType(this.getForeignColumnType());
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }
}

