/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.table;

import android.text.TextUtils;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.table.Column;
import com.android.pc.ioc.db.table.ColumnUtils;
import com.android.pc.ioc.db.table.Finder;
import com.android.pc.ioc.db.table.Foreign;
import com.android.pc.ioc.db.table.Id;
import com.android.pc.ioc.db.table.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class TableUtils {
    private static ConcurrentHashMap<String, HashMap<String, Column>> entityColumnsMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Id> entityIdMap = new ConcurrentHashMap();

    private TableUtils() {
    }

    public static String getTableName(Class<?> entityType) {
        com.android.pc.ioc.db.annotation.Table table = entityType.getAnnotation(com.android.pc.ioc.db.annotation.Table.class);
        if (table == null || TextUtils.isEmpty((CharSequence)table.name())) {
            return entityType.getName().replace('.', '_');
        }
        return table.name();
    }

    public static synchronized HashMap<String, Column> getColumnMap(Class<?> entityType) {
        if (entityColumnsMap.containsKey(entityType.getCanonicalName())) {
            return entityColumnsMap.get(entityType.getCanonicalName());
        }
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        String primaryKeyFieldName = TableUtils.getPrimaryKeyFieldName(entityType);
        TableUtils.addColumns2Map(entityType, primaryKeyFieldName, columnMap);
        entityColumnsMap.put(entityType.getCanonicalName(), columnMap);
        return columnMap;
    }

    private static void addColumns2Map(Class<?> entityType, String primaryKeyFieldName, HashMap<String, Column> columnMap) {
        if (Object.class.equals(entityType)) {
            return;
        }
        try {
            Field[] fields;
            Field[] fieldArray = fields = entityType.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!ColumnUtils.isTransient(field) && !Modifier.isStatic(field.getModifiers())) {
                    Column column;
                    if (ColumnUtils.isSimpleColumnType(field)) {
                        if (!field.getName().equals(primaryKeyFieldName) && !columnMap.containsKey((column = new Column(entityType, field)).getColumnName())) {
                            columnMap.put(column.getColumnName(), column);
                        }
                    } else if (ColumnUtils.isForeign(field)) {
                        column = new Foreign(entityType, field);
                        if (!columnMap.containsKey(column.getColumnName())) {
                            columnMap.put(column.getColumnName(), column);
                        }
                    } else if (ColumnUtils.isFinder(field) && !columnMap.containsKey((column = new Finder(entityType, field)).getColumnName())) {
                        columnMap.put(column.getColumnName(), column);
                    }
                }
                ++n2;
            }
            if (!Object.class.equals(entityType.getSuperclass())) {
                TableUtils.addColumns2Map(entityType.getSuperclass(), primaryKeyFieldName, columnMap);
            }
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
    }

    public static Column getColumnOrId(Class<?> entityType, String columnName) {
        if (TableUtils.getPrimaryKeyColumnName(entityType).equals(columnName)) {
            return Table.get(entityType).getId();
        }
        return TableUtils.getColumnMap(entityType).get(columnName);
    }

    public static Column getColumnOrId(Class<?> entityType, Field columnField) {
        String columnName = ColumnUtils.getColumnNameByField(columnField);
        if (TableUtils.getPrimaryKeyColumnName(entityType).equals(columnName)) {
            return Table.get(entityType).getId();
        }
        return TableUtils.getColumnMap(entityType).get(columnName);
    }

    public static synchronized Id getId(Class<?> entityType) {
        if (Object.class.equals(entityType)) {
            throw new RuntimeException("field 'id' not found");
        }
        if (entityIdMap.containsKey(entityType.getCanonicalName())) {
            return entityIdMap.get(entityType.getCanonicalName());
        }
        Field primaryKeyField = null;
        Field[] fields = entityType.getDeclaredFields();
        if (fields != null) {
            Field field;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (field.getAnnotation(com.android.pc.ioc.db.annotation.Id.class) != null) {
                    primaryKeyField = field;
                    break;
                }
                ++n2;
            }
            if (primaryKeyField == null) {
                fieldArray = fields;
                n = fields.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    if ("id".equals(field.getName()) || "_id".equals(field.getName())) {
                        primaryKeyField = field;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (primaryKeyField == null) {
            return TableUtils.getId(entityType.getSuperclass());
        }
        Id id = new Id(entityType, primaryKeyField);
        entityIdMap.put(entityType.getCanonicalName(), id);
        return id;
    }

    private static String getPrimaryKeyFieldName(Class<?> entityType) {
        Id id = TableUtils.getId(entityType);
        return id == null ? null : id.getColumnField().getName();
    }

    private static String getPrimaryKeyColumnName(Class<?> entityType) {
        Id id = TableUtils.getId(entityType);
        return id == null ? null : id.getColumnName();
    }

    public static Object getIdValue(Object entity) {
        Id id;
        block5: {
            if (entity == null) {
                return null;
            }
            try {
                id = TableUtils.getId(entity.getClass());
                if (id != null) break block5;
                return null;
            }
            catch (Exception e) {
                Ioc.getIoc().getLogger().e(e);
                return null;
            }
        }
        Object idValue = id.getColumnValue(entity);
        if (idValue != null && !idValue.equals(0) && idValue.toString().length() > 0) {
            return idValue;
        }
        return null;
    }
}

