/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.download;

import android.annotation.SuppressLint;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Base64;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.sqlite.WhereBuilder;
import com.android.pc.ioc.download.FileEntity;
import com.android.pc.ioc.download.FileResultEntity;
import com.android.pc.ioc.download.NotfiEntity;
import com.android.pc.ioc.download.ThreadEntity;
import com.android.pc.ioc.event.EventBus;
import com.android.pc.ioc.update.NotificationHelper;
import com.android.pc.util.Handler_File;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileLoaderManager {
    private static final int stuts_finish = 0;
    private static final int stuts_start = 1;
    private static HashMap<String, Boolean> loadingMap = new HashMap();
    private static String UA = "Mozilla/4.0 (compatible; MSIE 5.0; Windows XP; DigExt)";
    private static String proxyServer;
    private static int proxyPort;
    private static boolean useProxy;
    private static String proxyUser;
    private static String proxyPassword;
    private static int blockSize;
    static EventBus eventBus;
    private static HashMap<String, FileEntity> fileEntities;
    private static Handler handler;

    static {
        blockSize = 4096;
        eventBus = EventBus.getDefault();
        fileEntities = new HashMap();
        handler = new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                FileEntity entity = (FileEntity)msg.obj;
                switch (msg.what) {
                    case 0: {
                        loadingMap.remove(entity.getUrl());
                        if (entity.getNotfi() != null) {
                            NotfiEntity notfiEntity = entity.getNotfi();
                            NotificationHelper helper = new NotificationHelper((Context)Ioc.getIoc().getApplication(), notfiEntity.getLayout_id(), notfiEntity.getIcon_id(), notfiEntity.getProgress_id(), notfiEntity.getProgress_txt_id(), notfiEntity.getClazz());
                            helper.initNotif();
                            entity.setHelper(helper);
                        }
                        FileLoaderManager.sendMsg(entity, 3, 100);
                        break;
                    }
                    case 1: {
                        HashMap notfiEntity = loadingMap;
                        synchronized (notfiEntity) {
                            if (!((Boolean)loadingMap.get(entity.getUrl())).booleanValue()) {
                                loadingMap.remove(entity.getUrl());
                                FileLoaderManager.sendMsg(entity, 2, 0);
                                return;
                            }
                        }
                        entity.setSucess(false);
                        if ((entity.getId() == 0 || entity.isAgain()) && entity.getLength() > 0L && entity.isRange()) {
                            int threads = entity.getThreads();
                            long length = entity.getLength();
                            long threadsLength = length / (long)threads;
                            long orther = length % (long)threads;
                            ThreadEntity.delete(entity.getId());
                            DownloadThreadGroup downloadGroup = new DownloadThreadGroup("multi threads reload", entity);
                            int i = 0;
                            while (i < threads) {
                                long begin = (long)i * threadsLength;
                                long end = (long)(i + 1) * threadsLength;
                                if (threads > 1 && i == threads - 1 && orther > 0L) {
                                    end += orther;
                                }
                                ThreadEntity threadEntity = new ThreadEntity();
                                threadEntity.setStart(begin);
                                threadEntity.setEnd(end);
                                threadEntity.setLoad(0L);
                                threadEntity.setFileEntity(entity);
                                downloadGroup.setEntity(threadEntity);
                                DownloadThread downloadThread = new DownloadThread(downloadGroup, threadEntity, entity, i, begin, end);
                                downloadThread.start();
                                ++i;
                            }
                            if (threads > 0) {
                                downloadGroup.start();
                            }
                            return;
                        }
                        if (entity.getLength() <= 0L || !entity.isRange()) {
                            DownloadSingleThread singleThread = new DownloadSingleThread(entity);
                            singleThread.start();
                            return;
                        }
                        if (entity.getId() == 0 || entity.getLength() <= 0L || !entity.isRange()) break;
                        List<ThreadEntity> entities = entity.getThreadsEntities();
                        if (entities == null) {
                            return;
                        }
                        int size = entities.size();
                        DownloadThreadGroup downloadGroup = new DownloadThreadGroup("multi threads continue", entity);
                        int i = 0;
                        while (i < size) {
                            ThreadEntity threadEntity = entities.get(i);
                            downloadGroup.setEntity(threadEntity);
                            if (threadEntity.getLoad() + threadEntity.getStart() != threadEntity.getEnd()) {
                                DownloadThread downloadThread = new DownloadThread(downloadGroup, threadEntity, entity, i, threadEntity.getStart(), threadEntity.getEnd());
                                downloadThread.start();
                            }
                            ++i;
                        }
                        downloadGroup.start();
                    }
                }
            }
        };
    }

    public static String getProxyUser() {
        return proxyUser;
    }

    public static void setProxyUser(String proxyUser) {
        FileLoaderManager.proxyUser = proxyUser;
    }

    public static String getProxyPassword() {
        return proxyPassword;
    }

    public static void setProxyPassword(String proxyPassword) {
        FileLoaderManager.proxyPassword = proxyPassword;
    }

    public static String getProxyServer() {
        return proxyServer;
    }

    public static void setProxyServer(String proxyServer) {
        FileLoaderManager.proxyServer = proxyServer;
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static void setProxyPort(int proxyPort) {
        FileLoaderManager.proxyPort = proxyPort;
    }

    public static boolean isUseProxy() {
        return useProxy;
    }

    public static void setUseProxy(boolean useProxy) {
        FileLoaderManager.useProxy = useProxy;
    }

    public static void download(String url, String path) {
        FileLoaderManager.download(url, path, 1, false, null);
    }

    public static void download(String url) {
        FileLoaderManager.download(url, null, 1, false, null);
    }

    public static void download(String url, String path, NotfiEntity notfi) {
        FileLoaderManager.download(url, path, 1, false, notfi);
    }

    public static void download(String url, NotfiEntity notfi) {
        FileLoaderManager.download(url, null, 1, false, notfi);
    }

    public static void download(String url, String path, int threads) {
        FileLoaderManager.download(url, path, threads, false, null);
    }

    public static void download(String url, int threads) {
        FileLoaderManager.download(url, null, threads, false, null);
    }

    public static void download(String url, String path, int threads, NotfiEntity notfi) {
        FileLoaderManager.download(url, path, threads, false, notfi);
    }

    public static void download(String url, int threads, NotfiEntity notfi) {
        FileLoaderManager.download(url, null, threads, false, notfi);
    }

    public static void downloadUpdate(String url, String path) {
        FileLoaderManager.download(url, path, 1, true, null);
    }

    public static void downloadUpdate(String url) {
        FileLoaderManager.download(url, null, 1, true, null);
    }

    public static void downloadUpdate(String url, String path, NotfiEntity notfi) {
        FileLoaderManager.download(url, path, 1, true, notfi);
    }

    public static void downloadUpdate(String url, NotfiEntity notfi) {
        FileLoaderManager.download(url, null, 1, true, notfi);
    }

    public static void downloadUpdate(String url, String path, int threads) {
        FileLoaderManager.download(url, path, threads, true, null);
    }

    public static void downloadUpdate(String url, int threads) {
        FileLoaderManager.download(url, null, threads, true, null);
    }

    public static void downloadUpdate(String url, String path, int threads, NotfiEntity notfi) {
        FileLoaderManager.download(url, path, threads, true, notfi);
    }

    public static void downloadUpdate(String url, int threads, NotfiEntity notfi) {
        FileLoaderManager.download(url, null, threads, true, notfi);
    }

    public static Set<String> getLoadingUrl() {
        return fileEntities.keySet();
    }

    public static boolean showNotif(String url, NotfiEntity notfi) {
        if (!fileEntities.containsKey(url)) {
            return false;
        }
        FileEntity entity = fileEntities.get(url);
        entity.setNotfi(notfi);
        NotificationHelper helper = new NotificationHelper((Context)Ioc.getIoc().getApplication(), notfi.getLayout_id(), notfi.getIcon_id(), notfi.getProgress_id(), notfi.getProgress_txt_id(), notfi.getClazz());
        entity.setHelper(helper);
        if (entity.isRange()) {
            helper.initNotif();
        } else {
            helper.downNotification("\u4e0b\u8f7d\u4e2d......");
        }
        return true;
    }

    public static void hideNotif(String url) {
        if (!fileEntities.containsKey(url)) {
            return;
        }
        FileEntity entity = fileEntities.get(url);
        entity.setNotfi(null);
        NotificationHelper helper = entity.getHelper();
        entity.setHelper(null);
        helper.cancel();
    }

    public static void hideNotif() {
        NotificationManager mContextNotificationManager = (NotificationManager)Ioc.getIoc().getApplication().getSystemService("notification");
        mContextNotificationManager.cancelAll();
    }

    public static void stop(String url) {
        if (loadingMap.containsKey(url)) {
            loadingMap.put(url, false);
        }
    }

    public static List<FileEntity> getAllDownload() {
        return FileEntity.getAllEntity();
    }

    public static List<FileEntity> getAllFinishDownload() {
        return FileEntity.getAllFinishEntity();
    }

    public static List<FileEntity> getAllFailureDownload() {
        return FileEntity.getAllFailureEntity();
    }

    public static void clearByUrl(String url) {
        Ioc.getIoc().getDb().delete(FileEntity.class, WhereBuilder.b(" url ", " = ", url));
    }

    public static void clearHistory() {
        Ioc.getIoc().getDb().deleteAll(FileEntity.class);
        Ioc.getIoc().getDb().deleteAll(ThreadEntity.class);
    }

    private static void download(String url, String path, int threads, boolean update, NotfiEntity notfi) {
        FileEntity fileEntity;
        File path_file;
        if (loadingMap.containsKey(url)) {
            return;
        }
        loadingMap.put(url, true);
        if (path == null) {
            path = String.valueOf(Handler_File.getExternalCacheDir((Context)Ioc.getIoc().getApplication(), "files").getPath()) + "/file_" + String.valueOf(System.currentTimeMillis()).substring(4);
        }
        if (!(path_file = new File(path)).getParentFile().exists()) {
            path_file.getParentFile().mkdirs();
        }
        if ((fileEntity = FileEntity.getEntityByUrl(url)) == null) {
            fileEntity = new FileEntity();
            fileEntity.setUrl(url);
            fileEntity.setPath(path);
            fileEntity.setThreads(threads);
        }
        fileEntities.put(url, fileEntity);
        fileEntity.setNotfi(notfi);
        fileEntity.setUpdate(update);
        File old = new File(fileEntity.getPath());
        if (!old.exists() || old.length() == 0L) {
            fileEntity.setAgain(true);
        }
        Handler_File.makeDirs(path);
        if (fileEntity.getPath().equals(path) && fileEntity.isSucess && !fileEntity.isAgain()) {
            fileEntity.setNotfi(null);
            Message message = handler.obtainMessage();
            message.what = 0;
            message.obj = fileEntity;
            handler.sendMessage(message);
            return;
        }
        if (!fileEntity.getPath().equals(path) && !fileEntity.isAgain()) {
            final File newfile = new File(path);
            final File oldfile = new File(fileEntity.getPath());
            File file = newfile.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            final FileEntity newFileEntity = fileEntity;
            final String newPath = path;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Handler_File.copyFile(oldfile, newfile);
                    newFileEntity.setPath(newPath);
                    newFileEntity.update();
                    if (newFileEntity.isSucess()) {
                        newFileEntity.setNotfi(null);
                        Message message = handler.obtainMessage();
                        message.what = 0;
                        message.obj = newFileEntity;
                        handler.sendMessage(message);
                        return;
                    }
                    GetLengthThread thread = new GetLengthThread(newFileEntity);
                    new Thread(thread).start();
                }
            }).start();
            return;
        }
        GetLengthThread thread = new GetLengthThread(fileEntity);
        new Thread(thread).start();
    }

    private static HttpURLConnection getHttpConnection(long pos, String urls) throws IOException {
        int responseCode;
        URL url = new URL(urls);
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection httpConnection = null;
        if (useProxy) {
            InetSocketAddress addr = new InetSocketAddress(proxyServer, proxyPort);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            httpConnection = (HttpURLConnection)url.openConnection(proxy);
            if (proxyUser != null && proxyPassword != null) {
                String encoded = new String(Base64.encode((byte[])new String(String.valueOf(proxyUser) + ":" + proxyPassword).getBytes(), (int)0));
                httpConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
            }
        } else {
            httpConnection = (HttpURLConnection)url.openConnection();
        }
        httpConnection.setRequestProperty("Accept-Encoding", "identity");
        httpConnection.setConnectTimeout(10000);
        httpConnection.setReadTimeout(10000);
        httpConnection.setRequestProperty("User-Agent", UA);
        if (pos >= 0L) {
            httpConnection.setRequestProperty("RANGE", "bytes=" + pos + "-");
        }
        if ((responseCode = httpConnection.getResponseCode()) < 200 || responseCode >= 400) {
            loadingMap.remove(urls);
            throw new IOException("\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6548\u4fe1\u606f:" + responseCode);
        }
        return httpConnection;
    }

    private static void sendMsg(FileEntity entity, int status, int progress) {
        FileResultEntity resultEntity = new FileResultEntity();
        resultEntity.setRange(entity.isRange());
        resultEntity.setUrl(entity.getUrl());
        resultEntity.setLoadedLength(entity.getLoadedLength());
        resultEntity.setFile(new File(entity.getPath()));
        resultEntity.setStatus(status);
        resultEntity.setLength(entity.getLength());
        resultEntity.setProgress(progress);
        eventBus.post(resultEntity);
        if (status == 3 || status == 2) {
            fileEntities.remove(entity.getUrl());
        }
        if (entity.getNotfi() == null && entity.isUpdate() && status == 3) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setDataAndType(Uri.fromFile((File)resultEntity.getFile()), "application/vnd.android.package-archive");
            Context context = Ioc.getIoc().getApplication().getApplicationContext();
            context.startActivity(intent);
        }
        if (entity.getNotfi() != null) {
            NotificationHelper helper = entity.getHelper();
            switch (status) {
                case 1: {
                    break;
                }
                case 0: {
                    helper.refreshProgress(progress);
                    break;
                }
                case 2: {
                    helper.downShowNotification("\u4e0b\u8f7d\u5931\u8d25");
                    break;
                }
                case 3: {
                    if (entity.isUpdate()) {
                        helper.notifyUpdateFinish(new File(entity.getPath()));
                        break;
                    }
                    helper.downShowNotification("\u4e0b\u8f7d\u6210\u529f");
                }
            }
        }
    }

    private static class DownloadSingleThread
    extends Thread {
        private RandomAccessFile destFile;
        private long readCount;
        private FileEntity entity;

        public DownloadSingleThread(FileEntity entity) {
            block2: {
                this.entity = entity;
                try {
                    this.destFile = new RandomAccessFile(entity.getPath(), "rw");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (entity.getNotfi() == null) break block2;
                    NotificationHelper helper = entity.getHelper();
                    helper.downShowNotification("\u4e0b\u8f7d\u5931\u8d25");
                    entity.setHelper(helper);
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class DownloadThread
    extends Thread {
        private RandomAccessFile destFile;
        private long blockBegin = 0L;
        private long blockEnd = 0L;
        private long loading;
        private FileEntity entity;
        private ThreadEntity threadEntity;
        private long offset;

        public DownloadThread(DownloadThreadGroup group, ThreadEntity threadEntity, FileEntity entity, int id, long blockBegin, long blockEnd) {
            super((ThreadGroup)group, "downloadThread-" + id);
            this.blockBegin = blockBegin;
            this.blockEnd = blockEnd;
            this.entity = entity;
            this.threadEntity = threadEntity;
            this.loading = threadEntity.getLoad();
            this.offset = blockBegin + this.loading;
            try {
                this.destFile = new RandomAccessFile(entity.getPath(), "rw");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            BufferedInputStream inputStream = null;
            try {
                this.destFile.seek(1L * this.offset);
                HttpURLConnection httpConnection = FileLoaderManager.getHttpConnection(this.offset, this.entity.getReal_url() != null ? this.entity.getReal_url() : this.entity.getUrl());
                inputStream = new BufferedInputStream(httpConnection.getInputStream());
                byte[] b = new byte[blockSize];
                while (this.offset < this.blockEnd) {
                    if (!loadingMap.containsKey(this.entity.getUrl()) || !((Boolean)loadingMap.get(this.entity.getUrl())).booleanValue()) break;
                    int read = inputStream.read(b);
                    this.loading += (long)read;
                    this.offset = this.blockBegin + this.loading;
                    if (this.offset > this.blockEnd) {
                        this.loading = this.blockEnd - this.blockBegin;
                    }
                    this.destFile.write(b, 0, read);
                    this.threadEntity.setLoad(this.loading);
                }
                Ioc.getIoc().getLogger().d("---------------------------------------------------------------------");
                Ioc.getIoc().getLogger().d(String.valueOf(this.getName()) + "\u5f00\u59cb\uff1a" + this.blockBegin + "\u4e0b\u8f7d\u4e86\uff1a" + this.loading + "\u7ed3\u675f\uff1a" + this.blockEnd);
                Ioc.getIoc().getLogger().d("---------------------------------------------------------------------");
                httpConnection.disconnect();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.destFile != null) {
                        this.destFile.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class DownloadThreadGroup
    extends ThreadGroup {
        public List<ThreadEntity> entitysList = new ArrayList<ThreadEntity>();
        private FileEntity entity;

        public DownloadThreadGroup(String name, FileEntity entity) {
            super(name);
            this.entity = entity;
        }

        private long getSize() {
            int length = this.entitysList.size();
            long size = 0L;
            int i = 0;
            while (i < length) {
                size += this.entitysList.get(i).getLoad();
                ++i;
            }
            return size;
        }

        public void setEntity(ThreadEntity entity) {
            this.entitysList.add(entity);
        }

        public void start() {
            if (this.entity.getNotfi() != null) {
                NotfiEntity notfiEntity = this.entity.getNotfi();
                NotificationHelper helper = new NotificationHelper((Context)Ioc.getIoc().getApplication(), notfiEntity.getLayout_id(), notfiEntity.getIcon_id(), notfiEntity.getProgress_id(), notfiEntity.getProgress_txt_id(), notfiEntity.getClazz());
                helper.initNotif();
                this.entity.setHelper(helper);
            }
            new DownLoad().start();
        }

        private class DownLoad
        extends Thread {
            private DownLoad() {
            }

            @Override
            public void run() {
                super.run();
                while (DownloadThreadGroup.this.activeCount() > 0) {
                    DownloadThreadGroup.this.entity.setLoadedLength(DownloadThreadGroup.this.getSize());
                    FileLoaderManager.sendMsg(DownloadThreadGroup.this.entity, 0, (int)(DownloadThreadGroup.this.entity.getLoadedLength() * 100L / DownloadThreadGroup.this.entity.getLength()));
                    Ioc.getIoc().getDb().saveOrUpdateAll(DownloadThreadGroup.this.entitysList);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                long size = DownloadThreadGroup.this.getSize();
                DownloadThreadGroup.this.entity.setSucess(true);
                if (size != DownloadThreadGroup.this.entity.getLength()) {
                    FileLoaderManager.sendMsg(DownloadThreadGroup.this.entity, 2, 0);
                    DownloadThreadGroup.this.entity.setSucess(false);
                } else {
                    int price = (int)(size * 100L / DownloadThreadGroup.this.entity.getLength());
                    FileLoaderManager.sendMsg(DownloadThreadGroup.this.entity, 3, price);
                }
                loadingMap.remove(DownloadThreadGroup.this.entity.getUrl());
                Ioc.getIoc().getDb().saveOrUpdateAll(DownloadThreadGroup.this.entitysList);
                Ioc.getIoc().getDb().update(DownloadThreadGroup.this.entity);
            }
        }
    }

    private static class GetLengthThread
    implements Runnable {
        private FileEntity fileEntity;

        public GetLengthThread(FileEntity fileEntity) {
            this.fileEntity = fileEntity;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void run() {
            try {
                int length;
                if (!((Boolean)loadingMap.get(this.fileEntity.getUrl())).booleanValue()) {
                    FileLoaderManager.sendMsg(this.fileEntity, 2, 0);
                    loadingMap.remove(this.fileEntity.getUrl());
                    return;
                }
                FileLoaderManager.sendMsg(this.fileEntity, 1, 0);
                HttpURLConnection connection = FileLoaderManager.getHttpConnection(0L, this.fileEntity.getUrl());
                String redictURL = null;
                Map<String, List<String>> fieldMap = connection.getHeaderFields();
                for (String key : fieldMap.keySet()) {
                    if (!"location".equalsIgnoreCase(key)) continue;
                    redictURL = fieldMap.get(key).get(0);
                }
                if (redictURL == null) {
                    redictURL = connection.getURL().toString();
                }
                if (redictURL.startsWith("http") && !redictURL.equals(this.fileEntity.getUrl())) {
                    connection.disconnect();
                    this.fileEntity.setReal_url(redictURL);
                    connection = FileLoaderManager.getHttpConnection(0L, redictURL);
                    Ioc.getIoc().getLogger().i("\u4e0b\u8f7d\u7684\u6587\u4ef6\u662f\u91cd\u5b9a\u5411\u5730\u5740,\u6b63\u5728\u83b7\u53d6\u771f\u5b9e\u5730\u5740......");
                }
                if ((length = connection.getContentLength()) <= 0) {
                    Ioc.getIoc().getLogger().w("\u670d\u52a1\u5668\u4e0d\u80fd\u8fd4\u56de\u6587\u4ef6\u5927\u5c0f\uff0c\u91c7\u7528\u5355\u7ebf\u7a0b\u4e0b\u8f7d");
                    this.fileEntity.setThreads(1);
                }
                this.fileEntity.setRange(true);
                if (connection.getHeaderField("Content-Range") == null) {
                    Ioc.getIoc().getLogger().w("\u670d\u52a1\u5668\u4e0d\u652f\u6301\u65ad\u70b9\u7eed\u4f20");
                    this.fileEntity.setRange(false);
                }
                connection.disconnect();
                File file = new File(this.fileEntity.getPath());
                if (length > 0 && file.getParentFile().getFreeSpace() < (long)length) {
                    Ioc.getIoc().getLogger().e("\u78c1\u76d8\u7a7a\u95f4\u4e0d\u591f");
                    FileLoaderManager.sendMsg(this.fileEntity, 2, 0);
                    loadingMap.remove(this.fileEntity.getUrl());
                    return;
                }
                if (length > 0 && this.fileEntity.getLength() > 0L && this.fileEntity.getLength() != (long)length) {
                    this.fileEntity.setAgain(true);
                }
                this.fileEntity.setLength(length);
                if (length <= 10240) {
                    this.fileEntity.setThreads(1);
                }
                Message message = handler.obtainMessage();
                message.what = 1;
                message.obj = this.fileEntity;
                handler.sendMessage(message);
            }
            catch (Exception e) {
                if (this.fileEntity.getNotfi() != null) {
                    NotfiEntity notfiEntity = this.fileEntity.getNotfi();
                    NotificationHelper helper = new NotificationHelper((Context)Ioc.getIoc().getApplication(), notfiEntity.getLayout_id(), notfiEntity.getIcon_id(), notfiEntity.getProgress_id(), notfiEntity.getProgress_txt_id(), notfiEntity.getClazz());
                    helper.initNotif();
                    this.fileEntity.setHelper(helper);
                }
                FileLoaderManager.sendMsg(this.fileEntity, 2, 0);
                loadingMap.remove(this.fileEntity.getUrl());
            }
        }
    }
}

