/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.event.util;

import android.util.Log;
import com.android.pc.ioc.event.EventBus;
import com.android.pc.ioc.event.util.ThrowableFailureEvent;
import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AsyncExecutor {
    private final Executor threadPool;
    private final Constructor<?> failureEventConstructor;
    private final EventBus eventBus;

    public static Builder builder() {
        return new Builder();
    }

    public static AsyncExecutor create() {
        return new Builder().build();
    }

    private AsyncExecutor(Executor threadPool, EventBus eventBus, Class<?> failureEventType) {
        this.threadPool = threadPool;
        this.eventBus = eventBus;
        try {
            this.failureEventConstructor = failureEventType.getConstructor(Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failure event class must have a constructor with one parameter of type Throwable", e);
        }
    }

    public void execute(final RunnableEx runnable) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Object event;
                    try {
                        event = AsyncExecutor.this.failureEventConstructor.newInstance(e);
                    }
                    catch (Exception e1) {
                        Log.e((String)EventBus.TAG, (String)"Original exception:", (Throwable)e);
                        throw new RuntimeException("Could not create failure event", e1);
                    }
                    AsyncExecutor.this.eventBus.post(event);
                }
            }
        });
    }

    /* synthetic */ AsyncExecutor(Executor executor, EventBus eventBus, Class clazz, AsyncExecutor asyncExecutor) {
        this(executor, eventBus, clazz);
    }

    public static class Builder {
        private Executor threadPool;
        private Class<?> failureEventType;
        private EventBus eventBus;

        private Builder() {
        }

        public Builder threadPool(Executor threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public Builder failureEventType(Class<?> failureEventType) {
            this.failureEventType = failureEventType;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public AsyncExecutor build() {
            if (this.eventBus == null) {
                this.eventBus = EventBus.getDefault();
            }
            if (this.threadPool == null) {
                this.threadPool = Executors.newCachedThreadPool();
            }
            if (this.failureEventType == null) {
                this.failureEventType = ThrowableFailureEvent.class;
            }
            return new AsyncExecutor(this.threadPool, this.eventBus, this.failureEventType, null);
        }
    }

    public static interface RunnableEx {
        public void run() throws Exception;
    }
}

