/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.widget.ImageView;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.image.ImageCache;
import com.android.pc.ioc.image.ImageWorker;
import com.android.pc.util.Handler_Network;
import com.android.pc.util.Handler_System;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class ImageDownloader
extends ImageWorker {
    public ImageDownloader(Context context, int imageWidth, int imageHeight) {
        super(context, imageWidth, imageHeight);
        this.init(context);
    }

    public ImageDownloader(Context context, int imageSize) {
        super(context, imageSize);
        this.init(context);
    }

    public ImageDownloader(Context context) {
        super(context, Handler_System.getDisplayMetrics().get("width"));
        this.init(context);
    }

    private void init(Context context) {
        this.checkConnection(context);
    }

    private void checkConnection(Context context) {
        if (!Handler_Network.isNetworkAvailable(context)) {
            Ioc.getIoc().getLogger().e("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25");
        }
    }

    private Bitmap processBitmap(String data, ImageView imageView) {
        Ioc.getIoc().getLogger().d("\u56fe\u7247\u4e0b\u8f7d\u5f00\u59cb - " + data);
        File file = null;
        if (data.startsWith("http")) {
            String key = ImageCache.hashKeyForDisk(data);
            file = ImageCache.getFromFileCache(key);
            this.start(imageView, this.lister);
            this.downloadUrlToStream(data, file, imageView);
        } else {
            file = new File(data);
        }
        Bitmap bitmap = null;
        if (file != null && file.exists()) {
            bitmap = this.decodeSampledBitmapFromFile(data, file.getPath(), this.mImageWidth, this.mImageHeight, this.getImageCache());
        }
        return bitmap;
    }

    @Override
    protected Bitmap processBitmap(Object data, ImageView imageView) {
        if (data.getClass() == String.class) {
            return this.processBitmap(String.valueOf(data), imageView);
        }
        if (data.getClass() == Integer.class) {
            return super.processBitmap(Integer.valueOf(data.toString()), imageView);
        }
        return this.processBitmap(String.valueOf(data), imageView);
    }

    public boolean downloadUrlToStream(String urlString, File file, ImageView imageView) {
        ImageDownloader.disableConnectionReuseIfNecessary();
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            int count;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            out = new FileOutputStream(file);
            int length = urlConnection.getContentLength();
            in = urlConnection.getInputStream();
            int n = 0;
            int buffer_size = 1024;
            byte[] bytes = new byte[1024];
            while ((count = in.read(bytes, 0, 1024)) != -1) {
                out.write(bytes, 0, count);
                n += count;
                if (length <= 0) continue;
                int percent = n * 100 / length;
                this.process(percent, imageView, this.lister);
            }
            return true;
        }
        catch (IOException e) {
            Ioc.getIoc().getLogger().e("\u56fe\u7247\u4e0b\u8f7d\u51fa\u9519 - Error in downloadBitmap - " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static void disableConnectionReuseIfNecessary() {
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }
}

