/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.image;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.pc.ioc.image.RecyclingBitmapDrawable;

public class RecyclingImageView
extends ImageView {
    public RecyclingImageView(Context context) {
        super(context);
    }

    public RecyclingImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDetachedFromWindow() {
        this.setImageDrawable(null);
        super.onDetachedFromWindow();
    }

    public void setImageDrawable(Drawable drawable) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageDrawable(drawable);
        RecyclingImageView.notifyDrawable(drawable, true);
        RecyclingImageView.notifyDrawable(previousDrawable, false);
    }

    private static void notifyDrawable(Drawable drawable, boolean isDisplayed) {
        if (drawable instanceof RecyclingBitmapDrawable) {
            ((RecyclingBitmapDrawable)drawable).setIsDisplayed(isDisplayed);
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)drawable;
            int i = 0;
            int z = layerDrawable.getNumberOfLayers();
            while (i < z) {
                RecyclingImageView.notifyDrawable(layerDrawable.getDrawable(i), isDisplayed);
                ++i;
            }
        }
    }
}

