/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.internet;

import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.internet.InternetConfig;
import com.android.pc.util.Handler_File;
import com.android.pc.util.MD5;
import java.io.File;
import java.util.LinkedHashMap;

public class HttpCache {
    public static String getUrlCache(String url, LinkedHashMap<String, String> params) {
        if (url == null) {
            return null;
        }
        for (String key : params.keySet()) {
            url = String.valueOf(url) + key + params.get(key);
        }
        int time = InternetConfig.defaultConfig().getSaveDate();
        String result = null;
        File file = new File(Ioc.getIoc().getApplication().getCacheDir(), HttpCache.getCacheDecodeString(url));
        if (file.exists() && file.isFile()) {
            long expiredTime = System.currentTimeMillis() - file.lastModified();
            Ioc.getIoc().getLogger().d("\u7f13\u5b58\u4e86:" + expiredTime / 60000L + "\u5206\u949f");
            if (time != -1 && expiredTime > (long)time) {
                file.delete();
                return null;
            }
            result = Handler_File.getAsString(file);
        }
        return result;
    }

    public static void setUrlCache(String data, String url) {
        File file = new File(Ioc.getIoc().getApplication().getCacheDir(), HttpCache.getCacheDecodeString(url));
        Handler_File.write(file, data);
    }

    private static String getCacheDecodeString(String url) {
        return MD5.Md5(url.replaceAll("[.:/,%?&=]", "+").replaceAll("[+]+", "+"));
    }
}

