/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.update;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.widget.RemoteViews;
import com.android.pc.ioc.app.Ioc;
import java.io.File;

public class NotificationHelper {
    private Context mContext;
    private RemoteViews mRemoteViews;
    private Notification mDownProgrNotif;
    private PackageHelper mPackageHelper;
    private NotificationManager mContextNotificationManager;
    private int layout_id;
    private int icon_id;
    private int progress_id;
    private int progress_txt_id;
    private int id;
    private Class clazz;

    public NotificationHelper(Context ctx, int layout_id, int icon_id, int progress_id, int progress_txt_id, Class clazz) {
        this.mContext = ctx;
        this.mPackageHelper = new PackageHelper();
        this.mContextNotificationManager = (NotificationManager)ctx.getSystemService("notification");
        this.layout_id = layout_id;
        this.icon_id = icon_id;
        this.progress_id = progress_id;
        this.progress_txt_id = progress_txt_id;
        this.clazz = clazz;
        this.id = Integer.valueOf(String.valueOf(System.currentTimeMillis()).substring(4));
    }

    public void initNotif() {
        this.mDownProgrNotif = new Notification();
        this.mDownProgrNotif.icon = 0x1080081;
        this.mDownProgrNotif.flags |= 2;
        this.mRemoteViews = new RemoteViews(this.mPackageHelper.getPackageName(), this.layout_id);
        this.mRemoteViews.setImageViewResource(this.icon_id, this.mPackageHelper.getAppIcon());
        this.mDownProgrNotif.contentView = this.mRemoteViews;
        Intent intent = null;
        if (this.clazz != null) {
            intent = new Intent((Context)Ioc.getIoc().getApplication(), this.clazz);
        }
        this.mDownProgrNotif.contentIntent = PendingIntent.getService((Context)this.mContext, (int)0, (Intent)(intent == null ? new Intent() : intent), (int)0);
    }

    private Notification getDownFinishedNotification(File file) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        Notification noti = new Notification();
        noti.setLatestEventInfo(this.mContext, (CharSequence)this.mPackageHelper.getAppName(), (CharSequence)"\u4e0b\u8f7d\u5b8c\u6210,\u70b9\u51fb\u5b89\u88c5", pendingIntent);
        noti.icon = 17301634;
        noti.flags = 21;
        return noti;
    }

    public void downShowNotification(String text) {
        Intent intent = new Intent();
        if (this.clazz != null) {
            intent = new Intent((Context)Ioc.getIoc().getApplication(), this.clazz);
            intent.addCategory("android.intent.category.LAUNCHER");
            intent.setFlags(0x10200000);
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        Notification noti = new Notification();
        noti.setLatestEventInfo(this.mContext, (CharSequence)this.mPackageHelper.getAppName(), (CharSequence)text, pendingIntent);
        noti.icon = 17301634;
        noti.flags = 21;
        this.mContextNotificationManager.notify(this.id, noti);
    }

    public void downNotification(String text) {
        Notification notfi = new Notification();
        notfi.icon = 0x1080081;
        notfi.flags |= 2;
        Intent intent = null;
        if (this.clazz != null) {
            intent = new Intent((Context)Ioc.getIoc().getApplication(), this.clazz);
        }
        PendingIntent pendingIntent = PendingIntent.getService((Context)this.mContext, (int)0, (Intent)(intent == null ? new Intent() : intent), (int)0);
        notfi.setLatestEventInfo(this.mContext, (CharSequence)this.mPackageHelper.getAppName(), (CharSequence)text, pendingIntent);
        this.mContextNotificationManager.notify(this.id, notfi);
    }

    public void cancel() {
        this.mContextNotificationManager.cancel(this.id);
    }

    public void refreshProgress(float percent) {
        this.mRemoteViews.setProgressBar(this.progress_id, 100, (int)percent, false);
        this.mRemoteViews.setTextViewText(this.progress_txt_id, (CharSequence)String.format("%.1f", Float.valueOf(percent)));
        this.mContextNotificationManager.notify(this.id, this.mDownProgrNotif);
    }

    public void notifyUpdateFinish(File file) {
        this.mContextNotificationManager.notify(this.id, this.getDownFinishedNotification(file));
    }

    class PackageHelper {
        private PackageInfo info = null;
        private PackageManager pm = Ioc.getIoc().getApplication().getPackageManager();

        public PackageHelper() {
            try {
                this.info = this.pm.getPackageInfo(Ioc.getIoc().getApplication().getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }

        public String getAppName() {
            return this.info != null ? (String)this.info.applicationInfo.loadLabel(this.pm) : "";
        }

        public String getPackageName() {
            return this.info != null ? this.info.packageName : "";
        }

        public int getAppIcon() {
            return this.info != null ? this.info.applicationInfo.icon : 17301659;
        }
    }
}

