/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AbsoluteLayout;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.android.pc.ioc.event.EventBus;
import com.android.pc.ioc.view.PullToRefreshManager;
import com.android.pc.ioc.view.RefershEntity;
import com.android.pc.util.Handler_Bitmap;
import com.android.pc.util.Handler_System;
import java.io.IOException;
import java.io.InputStream;

public class PullToRefreshView
extends LinearLayout {
    private static final int PULL_TO_REFRESH = 2;
    private static final int RELEASE_TO_REFRESH = 3;
    private static final int REFRESHING = 4;
    private static final int PULL_NONE_STATE = -1;
    private static final int PULL_UP_STATE = 0;
    private static final int PULL_DOWN_STATE = 1;
    private int mLastMotionY;
    private RelativeLayout mHeaderView;
    private RelativeLayout mFooterView;
    private AdapterView<?> mAdapterView;
    private ScrollView mScrollView;
    private int mHeaderViewHeight;
    private int mFooterViewHeight;
    private ImageView mHeaderImageView;
    private ImageView mFooterImageView;
    private TextView mHeaderTextView;
    private TextView mFooterTextView;
    private TextView mHeaderUpdateTextView;
    private ProgressBar mHeaderProgressBar;
    private ProgressBar mFooterProgressBar;
    private int mHeaderState;
    private int mFooterState;
    private int mPullState = -1;
    private RotateAnimation mFlipAnimation;
    private RotateAnimation mReverseFlipAnimation;
    private OnFooterRefreshListener mOnFooterRefreshListener;
    private OnHeaderRefreshListener mOnHeaderRefreshListener;
    private boolean isGet = false;
    private boolean isHeader = true;
    private boolean isFooter = true;
    private Bitmap downBitmap;
    private Bitmap upBitmap;
    private PullToRefreshManager manager;
    private EventBus eventBus = EventBus.getDefault();

    public PullToRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PullToRefreshView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.manager = PullToRefreshManager.getInstance();
        this.setOrientation(1);
        this.mFlipAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mFlipAnimation.setDuration(250L);
        this.mFlipAnimation.setFillAfter(true);
        this.mReverseFlipAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mReverseFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mReverseFlipAnimation.setDuration(250L);
        this.mReverseFlipAnimation.setFillAfter(true);
        this.addHeaderView();
    }

    public void addView(View child) {
        super.addView(child);
    }

    private void addHeaderView() {
        try {
            InputStream down = this.getResources().getAssets().open("down.png");
            InputStream up = this.getResources().getAssets().open("up.png");
            this.downBitmap = BitmapFactory.decodeStream((InputStream)down);
            this.upBitmap = BitmapFactory.decodeStream((InputStream)up);
        }
        catch (IOException down) {
            // empty catch block
        }
        float rote = Handler_System.getPadRoate();
        this.downBitmap = Handler_Bitmap.scaleImg(this.downBitmap, (int)((float)this.downBitmap.getWidth() * rote), (int)((float)this.downBitmap.getHeight() * rote));
        this.upBitmap = Handler_Bitmap.scaleImg(this.upBitmap, (int)((float)this.upBitmap.getWidth() * rote), (int)((float)this.upBitmap.getHeight() * rote));
        this.mHeaderView = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, (int)(100.0f * rote));
        layoutParams.bottomMargin = (int)(15.0f * rote);
        layoutParams.topMargin = (int)(15.0f * rote);
        layoutParams.gravity = 17;
        this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mHeaderProgressBar = new ProgressBar(this.getContext());
        this.mHeaderProgressBar.setIndeterminate(false);
        this.mHeaderProgressBar.setVisibility(8);
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams((int)(40.0f * rote), (int)(40.0f * rote));
        rl.leftMargin = (int)(30.0f * rote);
        rl.rightMargin = (int)(20.0f * rote);
        rl.addRule(15);
        this.mHeaderProgressBar.setLayoutParams((ViewGroup.LayoutParams)rl);
        this.mHeaderView.addView((View)this.mHeaderProgressBar);
        this.mHeaderImageView = new ImageView(this.getContext());
        rl = new RelativeLayout.LayoutParams(-2, -2);
        rl.leftMargin = (int)(30.0f * rote);
        rl.rightMargin = (int)(20.0f * rote);
        rl.addRule(15);
        this.mHeaderImageView.setLayoutParams((ViewGroup.LayoutParams)rl);
        this.mHeaderImageView.setImageBitmap(this.downBitmap);
        this.mHeaderView.addView((View)this.mHeaderImageView);
        LinearLayout layout = new LinearLayout(this.getContext());
        rl = new RelativeLayout.LayoutParams(-1, -2);
        rl.addRule(15);
        layout.setOrientation(1);
        layout.setGravity(17);
        layout.setLayoutParams((ViewGroup.LayoutParams)rl);
        this.mHeaderTextView = new TextView(this.getContext());
        this.mHeaderTextView.setGravity(17);
        this.mHeaderTextView.setText((CharSequence)this.manager.getPull_label());
        this.mHeaderTextView.setTextColor(-16777216);
        this.mHeaderTextView.setTypeface(Typeface.DEFAULT_BOLD, 2);
        rl = new RelativeLayout.LayoutParams(-1, -2);
        this.mHeaderTextView.setLayoutParams((ViewGroup.LayoutParams)rl);
        layout.addView((View)this.mHeaderTextView);
        this.mHeaderUpdateTextView = new TextView(this.getContext());
        this.mHeaderUpdateTextView.setGravity(17);
        this.mHeaderUpdateTextView.setText((CharSequence)this.manager.getUpdateTime());
        this.mHeaderUpdateTextView.setTextColor(-16777216);
        this.mHeaderUpdateTextView.setVisibility(8);
        this.mHeaderUpdateTextView.setTextSize(10.0f);
        rl = new RelativeLayout.LayoutParams(-1, 40);
        this.mHeaderUpdateTextView.setLayoutParams((ViewGroup.LayoutParams)rl);
        layout.addView((View)this.mHeaderUpdateTextView);
        this.mHeaderView.addView((View)layout);
        this.measureView((View)this.mHeaderView);
        this.mHeaderViewHeight = this.mHeaderView.getMeasuredHeight();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.mHeaderViewHeight);
        params.topMargin = -this.mHeaderViewHeight;
        this.addView((View)this.mHeaderView, (ViewGroup.LayoutParams)params);
    }

    private void addFooterView() {
        this.mFooterView = new RelativeLayout(this.getContext());
        float rote = Handler_System.getPadRoate();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.bottomMargin = (int)(15.0f * rote);
        layoutParams.topMargin = (int)(10.0f * rote);
        layoutParams.gravity = 17;
        this.mFooterView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mFooterProgressBar = new ProgressBar(this.getContext());
        this.mFooterProgressBar.setIndeterminate(false);
        this.mFooterProgressBar.setVisibility(8);
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-2, -2);
        rl.leftMargin = (int)(30.0f * rote);
        rl.topMargin = (int)(10.0f * rote);
        rl.rightMargin = (int)(20.0f * rote);
        this.mFooterProgressBar.setLayoutParams((ViewGroup.LayoutParams)rl);
        this.mFooterView.addView((View)this.mFooterProgressBar);
        this.mFooterImageView = new ImageView(this.getContext());
        rl = new RelativeLayout.LayoutParams(-2, -2);
        rl.leftMargin = (int)(30.0f * rote);
        rl.rightMargin = (int)(20.0f * rote);
        this.mFooterImageView.setLayoutParams((ViewGroup.LayoutParams)rl);
        this.mFooterImageView.setImageBitmap(this.upBitmap);
        this.mFooterView.addView((View)this.mFooterImageView);
        LinearLayout layout = new LinearLayout(this.getContext());
        rl = new RelativeLayout.LayoutParams(-1, -2);
        layout.setOrientation(1);
        rl.addRule(13);
        layout.setGravity(17);
        layout.setLayoutParams((ViewGroup.LayoutParams)rl);
        this.mFooterTextView = new TextView(this.getContext());
        this.mFooterTextView.setGravity(17);
        this.mFooterTextView.setText((CharSequence)this.manager.getFooter_pull_label());
        this.mFooterTextView.setTextColor(-16777216);
        this.mFooterTextView.setTypeface(Typeface.DEFAULT_BOLD, 2);
        rl = new RelativeLayout.LayoutParams(-1, -2);
        this.mFooterTextView.setLayoutParams((ViewGroup.LayoutParams)rl);
        layout.addView((View)this.mFooterTextView);
        this.mFooterView.addView((View)layout);
        this.measureView((View)this.mFooterView);
        this.mFooterViewHeight = this.mFooterView.getMeasuredHeight();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.mFooterViewHeight);
        this.addView((View)this.mFooterView, (ViewGroup.LayoutParams)params);
    }

    public void onFooter() {
        this.addFooterView();
        this.initContentAdapterView();
        View view = this.getChildAt(0);
        if (view == null) {
            return;
        }
        ViewTreeObserver vto = this.getViewTreeObserver();
        vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (PullToRefreshView.this.isGet) {
                    return true;
                }
                PullToRefreshView.this.isGet = true;
                if (PullToRefreshView.this.mAdapterView != null) {
                    LinearLayout.LayoutParams params;
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)PullToRefreshView.this.mAdapterView.getLayoutParams();
                    layoutParams.height = PullToRefreshView.this.mAdapterView.getHeight();
                    if (layoutParams.height <= 2) {
                        layoutParams.height = PullToRefreshView.this.getHeight();
                    }
                    PullToRefreshView.this.mAdapterView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    if (LinearLayout.LayoutParams.class.isAssignableFrom(PullToRefreshView.this.getLayoutParams().getClass())) {
                        params = (LinearLayout.LayoutParams)PullToRefreshView.this.getLayoutParams();
                        params.height = layoutParams.height;
                        PullToRefreshView.this.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                    if (AbsoluteLayout.LayoutParams.class.isAssignableFrom(PullToRefreshView.this.getLayoutParams().getClass())) {
                        params = (AbsoluteLayout.LayoutParams)PullToRefreshView.this.getLayoutParams();
                        params.height = layoutParams.height;
                        PullToRefreshView.this.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                    if (RelativeLayout.LayoutParams.class.isAssignableFrom(PullToRefreshView.this.getLayoutParams().getClass())) {
                        params = (RelativeLayout.LayoutParams)PullToRefreshView.this.getLayoutParams();
                        params.height = layoutParams.height;
                        PullToRefreshView.this.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                    if (FrameLayout.LayoutParams.class.isAssignableFrom(PullToRefreshView.this.getLayoutParams().getClass())) {
                        params = (FrameLayout.LayoutParams)PullToRefreshView.this.getLayoutParams();
                        params.height = layoutParams.height;
                        PullToRefreshView.this.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                }
                return true;
            }
        });
    }

    private void initContentAdapterView() {
        int count = this.getChildCount();
        if (count < 3) {
            throw new IllegalArgumentException("This layout must contain 3 child views,and AdapterView or ScrollView must in the second position!");
        }
        View view = null;
        int i = 0;
        while (i < count - 1) {
            view = this.getChildAt(i);
            if (view instanceof AdapterView) {
                this.mAdapterView = (AdapterView)view;
            }
            if (view instanceof ScrollView) {
                this.mScrollView = (ScrollView)view;
            }
            ++i;
        }
        if (this.mAdapterView == null && this.mScrollView == null) {
            throw new IllegalArgumentException("must contain a AdapterView or ScrollView in this layout!");
        }
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        super.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec);
    }

    private void measureView(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        int y = (int)e.getRawY();
        switch (e.getAction()) {
            case 0: {
                this.mLastMotionY = y;
                break;
            }
            case 2: {
                int deltaY = y - this.mLastMotionY;
                if (!this.isRefreshViewScroll(deltaY)) break;
                return true;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int y = (int)event.getRawY();
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                int deltaY = y - this.mLastMotionY;
                if (this.mPullState == 1) {
                    this.headerPrepareToRefresh(deltaY);
                } else if (this.mPullState == 0) {
                    this.footerPrepareToRefresh(deltaY);
                }
                this.mLastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                int topMargin = this.getHeaderTopMargin();
                if (this.mPullState == 1) {
                    if (topMargin >= 0) {
                        this.headerRefreshing();
                        break;
                    }
                    this.setHeaderTopMargin(-this.mHeaderViewHeight);
                    break;
                }
                if (this.mPullState != 0) break;
                if (Math.abs(topMargin) >= this.mHeaderViewHeight + this.mFooterViewHeight) {
                    this.footerRefreshing();
                    break;
                }
                this.setHeaderTopMargin(-this.mHeaderViewHeight);
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isRefreshViewScroll(int deltaY) {
        View child;
        if (this.mHeaderState == 4 || this.mFooterState == 4) {
            return false;
        }
        if (this.mAdapterView != null) {
            if (deltaY > 0) {
                if (!this.isHeader) {
                    this.mPullState = -1;
                    return false;
                }
                child = this.mAdapterView.getChildAt(0);
                if (child == null) {
                    return false;
                }
                if (this.mAdapterView.getFirstVisiblePosition() == 0 && child.getTop() == 0) {
                    this.mPullState = 1;
                    return true;
                }
                int top = child.getTop();
                int padding = this.mAdapterView.getPaddingTop();
                if (this.mAdapterView.getFirstVisiblePosition() == 0 && Math.abs(top - padding) <= 8) {
                    this.mPullState = 1;
                    return true;
                }
            } else if (deltaY < 0) {
                if (!this.isFooter) {
                    this.mPullState = -1;
                    return false;
                }
                View lastChild = this.mAdapterView.getChildAt(this.mAdapterView.getChildCount() - 1);
                if (lastChild == null) {
                    return false;
                }
                if (lastChild.getBottom() <= this.getHeight() && this.mAdapterView.getLastVisiblePosition() == this.mAdapterView.getCount() - 1) {
                    this.mPullState = 0;
                    return true;
                }
            }
        }
        if (this.mScrollView != null) {
            child = this.mScrollView.getChildAt(0);
            if (deltaY > 0 && this.mScrollView.getScrollY() == 0) {
                if (!this.isHeader) {
                    this.mPullState = -1;
                    return false;
                }
                this.mPullState = 1;
                return true;
            }
            if (deltaY < 0 && child.getMeasuredHeight() <= this.getHeight() + this.mScrollView.getScrollY()) {
                if (!this.isFooter) {
                    this.mPullState = -1;
                    return false;
                }
                this.mPullState = 0;
                return true;
            }
        }
        return false;
    }

    private void headerPrepareToRefresh(int deltaY) {
        int newTopMargin = this.changingHeaderViewTopMargin(deltaY);
        if (newTopMargin >= 0 && this.mHeaderState != 3) {
            this.mHeaderTextView.setText((CharSequence)this.manager.getRelease_label());
            this.mHeaderUpdateTextView.setVisibility(0);
            this.mHeaderImageView.clearAnimation();
            this.mHeaderImageView.startAnimation((Animation)this.mFlipAnimation);
            this.mHeaderState = 3;
        } else if (newTopMargin < 0 && newTopMargin > -this.mHeaderViewHeight) {
            this.mHeaderImageView.clearAnimation();
            this.mHeaderImageView.startAnimation((Animation)this.mFlipAnimation);
            this.mHeaderTextView.setText((CharSequence)this.manager.getRelease_label());
            this.mHeaderState = 2;
        }
    }

    private void footerPrepareToRefresh(int deltaY) {
        int newTopMargin = this.changingHeaderViewTopMargin(deltaY);
        if (Math.abs(newTopMargin) >= this.mHeaderViewHeight + this.mFooterViewHeight && this.mFooterState != 3) {
            this.mFooterTextView.setText((CharSequence)this.manager.getFooter_refreshing_label());
            this.mFooterImageView.clearAnimation();
            this.mFooterImageView.startAnimation((Animation)this.mFlipAnimation);
            this.mFooterState = 3;
        } else if (Math.abs(newTopMargin) < this.mHeaderViewHeight + this.mFooterViewHeight) {
            this.mFooterImageView.clearAnimation();
            this.mFooterImageView.startAnimation((Animation)this.mFlipAnimation);
            this.mFooterTextView.setText((CharSequence)this.manager.getFooter_pull_label());
            this.mFooterState = 2;
        }
    }

    private int changingHeaderViewTopMargin(int deltaY) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        float newTopMargin = (float)params.topMargin + (float)deltaY * 0.5f;
        if (deltaY > 0 && this.mPullState == 0 && Math.abs(params.topMargin) <= this.mHeaderViewHeight) {
            return params.topMargin;
        }
        if (deltaY < 0 && this.mPullState == 1 && Math.abs(params.topMargin) >= this.mHeaderViewHeight) {
            return params.topMargin;
        }
        params.topMargin = (int)newTopMargin;
        this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)params);
        return params.topMargin;
    }

    private void headerRefreshing() {
        this.mHeaderState = 4;
        this.setHeaderTopMargin(0);
        this.mHeaderImageView.setVisibility(8);
        this.mHeaderImageView.clearAnimation();
        this.mHeaderImageView.setImageDrawable(null);
        this.mHeaderProgressBar.setVisibility(0);
        this.mHeaderTextView.setText((CharSequence)this.manager.getRefreshing_label());
        if (this.mOnHeaderRefreshListener != null) {
            this.mOnHeaderRefreshListener.onHeaderRefresh(this);
        }
    }

    private void footerRefreshing() {
        this.mFooterState = 4;
        int top = this.mHeaderViewHeight + this.mFooterViewHeight;
        this.setHeaderTopMargin(-top);
        this.mFooterImageView.setVisibility(8);
        this.mFooterImageView.clearAnimation();
        this.mFooterImageView.setImageDrawable(null);
        this.mFooterProgressBar.setVisibility(0);
        this.mFooterTextView.setText((CharSequence)this.manager.getRefreshing_label());
        if (this.mOnFooterRefreshListener != null) {
            this.mOnFooterRefreshListener.onFooterRefresh(this);
        }
    }

    private void setHeaderTopMargin(int topMargin) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        params.topMargin = topMargin;
        this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void onHeaderRefreshComplete() {
        this.setHeaderTopMargin(-this.mHeaderViewHeight);
        this.mHeaderImageView.setVisibility(0);
        this.mHeaderImageView.setImageBitmap(this.downBitmap);
        this.mHeaderTextView.setText((CharSequence)this.manager.getRelease_label());
        this.mHeaderProgressBar.setVisibility(8);
        this.mHeaderState = 2;
    }

    public void onHeaderRefreshComplete(CharSequence lastUpdated) {
        this.setLastUpdated(lastUpdated);
        this.onHeaderRefreshComplete();
    }

    public void onFooterRefreshComplete() {
        this.setHeaderTopMargin(-this.mHeaderViewHeight);
        this.mFooterImageView.setVisibility(0);
        this.mFooterImageView.setImageBitmap(this.upBitmap);
        this.mFooterTextView.setText((CharSequence)this.manager.getFooter_pull_label());
        this.mFooterProgressBar.setVisibility(8);
        this.mFooterState = 2;
    }

    public void setLastUpdated(CharSequence lastUpdated) {
        if (lastUpdated != null) {
            this.mHeaderUpdateTextView.setVisibility(0);
            this.mHeaderUpdateTextView.setText(lastUpdated);
        } else {
            this.mHeaderUpdateTextView.setVisibility(8);
        }
    }

    private int getHeaderTopMargin() {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        return params.topMargin;
    }

    public void setOnHeaderRefreshListener(OnHeaderRefreshListener headerRefreshListener) {
        this.mOnHeaderRefreshListener = headerRefreshListener;
    }

    public void setOnFooterRefreshListener(OnFooterRefreshListener footerRefreshListener) {
        this.mOnFooterRefreshListener = footerRefreshListener;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.eventBus.unregister((Object)this);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        switch (visibility) {
            case 8: {
                this.eventBus.unregister((Object)this);
                break;
            }
            case 4: {
                this.eventBus.unregister((Object)this);
                break;
            }
            case 0: {
                this.eventBus.register((Object)this);
            }
        }
    }

    public AdapterView<?> getAdapterView() {
        return this.mAdapterView;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }

    public boolean isFooter() {
        return this.isFooter;
    }

    public void setFooter(boolean isFooter) {
        this.isFooter = isFooter;
    }

    public void onEventMainThread(RefershEntity entity) {
        switch (entity.getType()) {
            case 3: {
                this.setFooter(false);
                break;
            }
            case 4: {
                this.setHeader(false);
                break;
            }
            case 5: {
                this.setFooter(true);
                break;
            }
            case 6: {
                this.setHeader(true);
                break;
            }
            case 2: {
                this.onHeaderRefreshComplete();
                break;
            }
            case 1: {
                this.onFooterRefreshComplete();
                if (this.manager.getLimit() == 0) {
                    return;
                }
                if (this.mAdapterView == null) break;
                int count = this.mAdapterView.getAdapter().getCount();
                if (count % this.manager.getLimit() != 0) {
                    this.setFooter(false);
                    break;
                }
                this.setFooter(true);
            }
        }
    }

    public static interface OnFooterRefreshListener {
        public void onFooterRefresh(PullToRefreshView var1);
    }

    public static interface OnHeaderRefreshListener {
        public void onHeaderRefresh(PullToRefreshView var1);
    }
}

