/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class Handler_Bitmap {
    public static final String textChangLine = "@";

    public static Bitmap scaleImg(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        int newWidth1 = newWidth;
        int newHeight1 = newHeight;
        float scaleWidth = (float)newWidth1 / (float)width;
        float scaleHeight = (float)newHeight1 / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Drawable zoomDrawable(Drawable drawable, int w, int h) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap oldbmp = Handler_Bitmap.drawableToBitmap(drawable);
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbmp = Bitmap.createBitmap((Bitmap)oldbmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return new BitmapDrawable(newbmp);
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        BitmapDrawable drawable = new BitmapDrawable(bitmap);
        return drawable;
    }

    public static Bitmap createReflectedImage(Bitmap originalImage, int number) {
        boolean reflectionGap = false;
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, -1.0f);
        double reflectHeight = (double)number / 100.0;
        number = (int)((double)height * reflectHeight);
        Bitmap reflectionImage = Bitmap.createBitmap((Bitmap)originalImage, (int)0, (int)number, (int)width, (int)number, (Matrix)matrix, (boolean)false);
        Bitmap bitmapWithReflection = Bitmap.createBitmap((int)width, (int)(height + number), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmapWithReflection);
        canvas.drawBitmap(originalImage, 0.0f, 0.0f, null);
        canvas.drawBitmap(reflectionImage, 0.0f, (float)(height + 0), null);
        Paint paint = new Paint();
        LinearGradient shader = new LinearGradient(0.0f, (float)originalImage.getHeight(), 0.0f, (float)(bitmapWithReflection.getHeight() + 0), 0x70FFFFFF, 0xFFFFFF, Shader.TileMode.MIRROR);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawRect(0.0f, (float)height, (float)width, (float)(bitmapWithReflection.getHeight() + 0), paint);
        return bitmapWithReflection;
    }

    public static Bitmap addFrame(Bitmap bitmap, int color) {
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Rect rect = canvas.getClipBounds();
        --rect.bottom;
        --rect.right;
        Paint recPaint = new Paint();
        recPaint.setColor(color);
        recPaint.setStyle(Paint.Style.STROKE);
        canvas.drawRect(rect, recPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        return bitmap2;
    }

    public static Bitmap getBitmap(byte[] data) {
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
    }

    public static byte[] getBytes(Bitmap bitmap) {
        ByteArrayOutputStream baops = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)baops);
        return baops.toByteArray();
    }
}

