/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.util.Handler_String;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Handler_File {
    public static final String FILE_EXTENSION_SEPARATOR = ".";

    public static StringBuilder readFile(String filePath) {
        File file = new File(filePath);
        StringBuilder fileContent = new StringBuilder("");
        if (file == null || !file.isFile()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!fileContent.toString().equals("")) {
                    fileContent.append("\r\n");
                }
                fileContent.append(line);
            }
            reader.close();
            StringBuilder stringBuilder = fileContent;
            return stringBuilder;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
    }

    public static boolean writeFile(String filePath, String content, boolean append) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(filePath, append);
            fileWriter.write(content);
            fileWriter.close();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
    }

    public static boolean writeFile(String filePath, InputStream stream) {
        FileOutputStream o = null;
        try {
            o = new FileOutputStream(filePath);
            byte[] data = new byte[1024];
            int length = -1;
            while ((length = stream.read(data)) != -1) {
                ((OutputStream)o).write(data, 0, length);
            }
            o.flush();
            return true;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("FileNotFoundException occurred. ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
        finally {
            if (o != null) {
                try {
                    ((OutputStream)o).close();
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
    }

    public static List<String> readFileToList(String filePath) {
        File file = new File(filePath);
        ArrayList<String> fileContent = new ArrayList<String>();
        if (file == null || !file.isFile()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                fileContent.add(line);
            }
            reader.close();
            ArrayList<String> arrayList = fileContent;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
    }

    public static String getFileNameWithoutExtension(String filePath) {
        if (Handler_String.isEmpty(filePath)) {
            return filePath;
        }
        int extenPosi = filePath.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int filePosi = filePath.lastIndexOf(File.separator);
        if (filePosi == -1) {
            return extenPosi == -1 ? filePath : filePath.substring(0, extenPosi);
        }
        if (extenPosi == -1) {
            return filePath.substring(filePosi + 1);
        }
        return filePosi < extenPosi ? filePath.substring(filePosi + 1, extenPosi) : filePath.substring(filePosi + 1);
    }

    public static String getFileName(String filePath) {
        if (Handler_String.isEmpty(filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        return filePosi == -1 ? filePath : filePath.substring(filePosi + 1);
    }

    public static String getFolderName(String filePath) {
        if (Handler_String.isEmpty(filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        return filePosi == -1 ? "" : filePath.substring(0, filePosi);
    }

    public static String getFileExtension(String filePath) {
        if (Handler_String.isBlank(filePath)) {
            return filePath;
        }
        int extenPosi = filePath.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int filePosi = filePath.lastIndexOf(File.separator);
        if (extenPosi == -1) {
            return "";
        }
        return filePosi >= extenPosi ? "" : filePath.substring(extenPosi + 1);
    }

    public static boolean makeDirs(String filePath) {
        String folderName = Handler_File.getFolderName(filePath);
        if (Handler_String.isEmpty(folderName)) {
            return false;
        }
        File folder = new File(folderName);
        return folder.exists() && folder.isDirectory() ? true : folder.mkdirs();
    }

    public static boolean makeFolders(String filePath) {
        return Handler_File.makeDirs(filePath);
    }

    public static boolean isFileExist(String filePath) {
        if (Handler_String.isBlank(filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static boolean isFolderExist(String directoryPath) {
        if (Handler_String.isBlank(directoryPath)) {
            return false;
        }
        File dire = new File(directoryPath);
        return dire.exists() && dire.isDirectory();
    }

    public static boolean deleteFile(String path) {
        if (Handler_String.isBlank(path)) {
            return true;
        }
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                f.delete();
            } else if (f.isDirectory()) {
                Handler_File.deleteFile(f.getAbsolutePath());
            }
            ++n2;
        }
        return file.delete();
    }

    public static long getFileSize(String path) {
        if (Handler_String.isBlank(path)) {
            return -1L;
        }
        File file = new File(path);
        return file.exists() && file.isFile() ? file.length() : -1L;
    }

    public static void copyFile(File sourceFile, File targetFile) {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            try {
                int len;
                inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
                outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] b = new byte[5120];
                while ((len = inBuff.read(b)) != -1) {
                    ((BufferedOutputStream)outBuff).write(b, 0, len);
                }
                ((BufferedOutputStream)outBuff).flush();
                sourceFile.delete();
                sourceFile.deleteOnExit();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (inBuff != null) {
                        inBuff.close();
                    }
                    if (outBuff != null) {
                        outBuff.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (inBuff != null) {
                    inBuff.close();
                }
                if (outBuff != null) {
                    outBuff.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static File getExternalCacheDir(Context context, String dirs_name) {
        File dataDir = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File appCacheDir = new File(new File(new File(dataDir, context.getPackageName()), "cache"), dirs_name);
        if (!appCacheDir.exists()) {
            try {
                new File(dataDir, ".nomedia").createNewFile();
            }
            catch (IOException e) {
                Log.w((String)"\u521b\u5efa\u76ee\u5f55", (String)"Can't create \".nomedia\" file in application external cache directory", (Throwable)e);
            }
            if (!appCacheDir.mkdirs()) {
                Log.w((String)"\u521b\u5efa\u76ee\u5f55", (String)"Unable to create external cache directory");
                return null;
            }
        }
        return appCacheDir;
    }

    public static void write(File file, String data) {
        block12: {
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new FileWriter(file), 1024);
                    out.write(data);
                }
                catch (IOException e) {
                    Ioc.getIoc().getLogger().d("write " + file.getAbsolutePath() + " data failed!");
                    e.printStackTrace();
                    if (out == null) break block12;
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String getAsString(File file) {
        if (!file.exists()) {
            return null;
        }
        BufferedReader in = null;
        try {
            String currentLine;
            in = new BufferedReader(new FileReader(file));
            String readString = "";
            while ((currentLine = in.readLine()) != null) {
                readString = String.valueOf(readString) + currentLine;
            }
            String string = readString;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void saveObject(String fileName, Serializable object) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = Ioc.getIoc().getApplication().openFileOutput(fileName, 0);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(object);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static <T> T getObject(String fileName) {
        block13: {
            Object object;
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = Ioc.getIoc().getApplication().openFileInput(fileName);
                ois = new ObjectInputStream(fis);
                object = ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                break block13;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return (T)object;
        }
        return null;
    }
}

