/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import com.android.pc.ioc.app.Ioc;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;

public class Handler_Properties {
    public static Properties loadProperties(String fileName, String dirName) {
        Properties props = new Properties();
        try {
            int id = Ioc.getIoc().getApplication().getResources().getIdentifier(fileName, dirName, Ioc.getIoc().getApplication().getPackageName());
            props.load(Ioc.getIoc().getApplication().getResources().openRawResource(id));
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e.toString());
        }
        return props;
    }

    public static Properties loadConfig(String file) {
        Properties properties = new Properties();
        try {
            FileInputStream s = new FileInputStream(file);
            properties.load(s);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e.toString());
        }
        return properties;
    }

    public static void saveConfig(String file, Properties properties) {
        try {
            FileOutputStream s = new FileOutputStream(file, false);
            properties.store(s, "");
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e.toString());
        }
    }

    public static Properties loadConfigNoDirs(String fileName) {
        Properties properties = new Properties();
        try {
            FileInputStream s = Ioc.getIoc().getApplication().openFileInput(fileName);
            properties.load(s);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e.toString());
        }
        return properties;
    }

    public static void saveConfigNoDirs(String fileName, Properties properties) {
        try {
            FileOutputStream s = Ioc.getIoc().getApplication().openFileOutput(fileName, 0);
            properties.store(s, "");
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e.toString());
        }
    }

    public static Properties loadConfigAssets(String fileName) {
        Properties properties = new Properties();
        try {
            InputStream is = Ioc.getIoc().getApplication().getAssets().open(fileName);
            properties.load(is);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e.toString());
        }
        return properties;
    }
}

