/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.ResultReceiver;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import com.android.pc.util.Handler_System;
import java.util.HashMap;

public class Handler_Ui {
    public static void setSelection(Spinner spinner, Object selection) {
        Handler_Ui.setSelection(spinner, selection.toString());
    }

    public static void setSelection(Spinner spinner, String selection) {
        int count = spinner.getCount();
        int i = 0;
        while (i < count) {
            String item = spinner.getItemAtPosition(i).toString();
            if (item.equalsIgnoreCase(selection)) {
                spinner.setSelection(i);
            }
            ++i;
        }
    }

    public static void hideSoftKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void showSoftkeyboard(View view) {
        Handler_Ui.showSoftkeyboard(view, null);
    }

    public static void showSoftkeyboard(View view, ResultReceiver resultReceiver) {
        Configuration config = view.getContext().getResources().getConfiguration();
        if (config.hardKeyboardHidden == 2) {
            InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (resultReceiver != null) {
                imm.showSoftInput(view, 1, resultReceiver);
            } else {
                imm.showSoftInput(view, 1);
            }
        }
    }

    public static void imageLLViewReset(ImageView imageView, int bitmapW, int bitmapH, boolean isFull) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)imageView.getLayoutParams();
        HashMap<String, Integer> data = Handler_System.getDisplayMetrics();
        int width = data.get("width");
        int height = data.get("height");
        if (isFull) {
            if (width > height) {
                layoutParams.width = (int)((float)bitmapW * 1.0f / (float)bitmapH * (float)height);
                layoutParams.height = height;
            } else {
                layoutParams.width = width;
                layoutParams.height = (int)((float)bitmapH * 1.0f / (float)bitmapW * (float)width);
            }
        } else if (bitmapW > width) {
            layoutParams.width = width;
            layoutParams.height = (int)((float)width * 1.0f / (float)bitmapW * (float)bitmapH);
        } else {
            layoutParams.width = bitmapW;
            layoutParams.height = bitmapH;
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static void imageRLViewReset(ImageView imageView, int bitmapW, int bitmapH, boolean isFull) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)imageView.getLayoutParams();
        HashMap<String, Integer> data = Handler_System.getDisplayMetrics();
        int width = data.get("width");
        int height = data.get("height");
        if (isFull) {
            if (width > height) {
                layoutParams.width = (int)((float)bitmapW * 1.0f / (float)bitmapH * (float)height);
                layoutParams.height = height;
            } else {
                layoutParams.width = width;
                layoutParams.height = (int)((float)bitmapH * 1.0f / (float)bitmapW * (float)width);
            }
        } else if (bitmapW > width) {
            layoutParams.width = width;
            layoutParams.height = (int)((float)width * 1.0f / (float)bitmapW * (float)bitmapH);
        } else {
            layoutParams.width = bitmapW;
            layoutParams.height = bitmapH;
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static void imageFLViewReset(ImageView imageView, int bitmapW, int bitmapH, boolean isFull) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)imageView.getLayoutParams();
        HashMap<String, Integer> data = Handler_System.getDisplayMetrics();
        int width = data.get("width");
        int height = data.get("height");
        if (isFull) {
            if (width > height) {
                layoutParams.width = (int)((float)bitmapW * 1.0f / (float)bitmapH * (float)height);
                layoutParams.height = height;
            } else {
                layoutParams.width = width;
                layoutParams.height = (int)((float)bitmapH * 1.0f / (float)bitmapW * (float)width);
            }
        } else if (bitmapW > width) {
            layoutParams.width = width;
            layoutParams.height = (int)((float)width * 1.0f / (float)bitmapW * (float)bitmapH);
        } else {
            layoutParams.width = bitmapW;
            layoutParams.height = bitmapH;
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static void resetRL(View ... view) {
        float rote = Handler_System.getWidthRoate();
        if (view == null || rote == 1.0f) {
            return;
        }
        View[] viewArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view2.getLayoutParams();
            layoutParams.leftMargin = (int)((float)layoutParams.leftMargin * rote);
            layoutParams.rightMargin = (int)((float)layoutParams.rightMargin * rote);
            layoutParams.topMargin = (int)((float)layoutParams.topMargin * rote);
            layoutParams.bottomMargin = (int)((float)layoutParams.bottomMargin * rote);
            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ++n2;
        }
    }

    public static void resetRLBack(View ... view) {
        float rote = Handler_System.getWidthRoate();
        if (view == null || rote == 1.0f) {
            return;
        }
        View[] viewArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view2.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height * rote);
            layoutParams.width = (int)((float)layoutParams.width * rote);
            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ++n2;
        }
    }

    public static void resetLL(View ... view) {
        float rote = Handler_System.getWidthRoate();
        if (view == null || rote == 1.0f) {
            return;
        }
        View[] viewArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view2.getLayoutParams();
            layoutParams.leftMargin = (int)((float)layoutParams.leftMargin * rote);
            layoutParams.rightMargin = (int)((float)layoutParams.rightMargin * rote);
            layoutParams.topMargin = (int)((float)layoutParams.topMargin * rote);
            layoutParams.bottomMargin = (int)((float)layoutParams.bottomMargin * rote);
            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ++n2;
        }
    }

    public static void resetLLBack(View ... view) {
        float rote = Handler_System.getWidthRoate();
        if (view == null || rote == 1.0f) {
            return;
        }
        View[] viewArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view2.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height * rote);
            layoutParams.width = (int)((float)layoutParams.width * rote);
            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ++n2;
        }
    }

    public static void resetFL(View ... view) {
        float rote = Handler_System.getWidthRoate();
        if (view == null || rote == 1.0f) {
            return;
        }
        View[] viewArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            layoutParams.leftMargin = (int)((float)layoutParams.leftMargin * rote);
            layoutParams.rightMargin = (int)((float)layoutParams.rightMargin * rote);
            layoutParams.topMargin = (int)((float)layoutParams.topMargin * rote);
            layoutParams.bottomMargin = (int)((float)layoutParams.bottomMargin * rote);
            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ++n2;
        }
    }

    public static void resetFLBack(View ... view) {
        float rote = Handler_System.getWidthRoate();
        if (view == null || rote == 1.0f) {
            return;
        }
        View[] viewArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            View view2 = viewArray[n2];
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view2.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height * rote);
            layoutParams.width = (int)((float)layoutParams.width * rote);
            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ++n2;
        }
    }

    public static Bitmap shot(Activity activity) {
        View view = activity.getWindow().getDecorView();
        Display display = activity.getWindowManager().getDefaultDisplay();
        view.layout(0, 0, display.getWidth(), display.getHeight());
        view.setDrawingCacheEnabled(true);
        Bitmap bmp = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bmp;
    }

    public static void startAnim(ImageView imageView, int drawable) {
        try {
            imageView.setScaleType(ImageView.ScaleType.CENTER);
            imageView.setImageResource(drawable);
            AnimationSet animationSet = new AnimationSet(false);
            RotateAnimation rotateAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
            rotateAnimation.setDuration(2000L);
            rotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
            rotateAnimation.setRepeatMode(1);
            rotateAnimation.setRepeatCount(-1);
            animationSet.addAnimation((Animation)rotateAnimation);
            imageView.setAnimation((Animation)animationSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopAnim(ImageView imageView) {
        try {
            imageView.clearAnimation();
            imageView.setImageBitmap(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

