/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class HanziToPinyin {
    private static LinkedHashMap<String, Integer> spellMap;
    private static HanziToPinyin sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HanziToPinyin getInstance() {
        Class<HanziToPinyin> clazz = HanziToPinyin.class;
        synchronized (HanziToPinyin.class) {
            if (sInstance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
            sInstance = new HanziToPinyin();
            spellMap = new LinkedHashMap(400);
            sInstance.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void spellPut(String spell, int ascii) {
        spellMap.put(spell, new Integer(ascii));
    }

    private void initialize() {
        this.spellPut("a", -20319);
        this.spellPut("ai", -20317);
        this.spellPut("an", -20304);
        this.spellPut("ang", -20295);
        this.spellPut("ao", -20292);
        this.spellPut("ba", -20283);
        this.spellPut("bai", -20265);
        this.spellPut("ban", -20257);
        this.spellPut("bang", -20242);
        this.spellPut("bao", -20230);
        this.spellPut("bei", -20051);
        this.spellPut("ben", -20036);
        this.spellPut("beng", -20032);
        this.spellPut("bi", -20026);
        this.spellPut("bian", -20002);
        this.spellPut("biao", -19990);
        this.spellPut("bie", -19986);
        this.spellPut("bin", -19982);
        this.spellPut("bing", -19976);
        this.spellPut("bo", -19805);
        this.spellPut("bu", -19784);
        this.spellPut("ca", -19775);
        this.spellPut("cai", -19774);
        this.spellPut("can", -19763);
        this.spellPut("cang", -19756);
        this.spellPut("cao", -19751);
        this.spellPut("ce", -19746);
        this.spellPut("ceng", -19741);
        this.spellPut("cha", -19739);
        this.spellPut("chai", -19728);
        this.spellPut("chan", -19725);
        this.spellPut("chang", -19715);
        this.spellPut("chao", -19540);
        this.spellPut("che", -19531);
        this.spellPut("chen", -19525);
        this.spellPut("cheng", -19515);
        this.spellPut("chi", -19500);
        this.spellPut("chong", -19484);
        this.spellPut("chou", -19479);
        this.spellPut("chu", -19467);
        this.spellPut("chuai", -19289);
        this.spellPut("chuan", -19288);
        this.spellPut("chuang", -19281);
        this.spellPut("chui", -19275);
        this.spellPut("chun", -19270);
        this.spellPut("chuo", -19263);
        this.spellPut("ci", -19261);
        this.spellPut("cong", -19249);
        this.spellPut("cou", -19243);
        this.spellPut("cu", -19242);
        this.spellPut("cuan", -19238);
        this.spellPut("cui", -19235);
        this.spellPut("cun", -19227);
        this.spellPut("cuo", -19224);
        this.spellPut("da", -19218);
        this.spellPut("dai", -19212);
        this.spellPut("dan", -19038);
        this.spellPut("dang", -19023);
        this.spellPut("dao", -19018);
        this.spellPut("de", -19006);
        this.spellPut("deng", -19003);
        this.spellPut("di", -18996);
        this.spellPut("dian", -18977);
        this.spellPut("diao", -18961);
        this.spellPut("die", -18952);
        this.spellPut("ding", -18783);
        this.spellPut("diu", -18774);
        this.spellPut("dong", -18773);
        this.spellPut("dou", -18763);
        this.spellPut("du", -18756);
        this.spellPut("duan", -18741);
        this.spellPut("dui", -18735);
        this.spellPut("dun", -18731);
        this.spellPut("duo", -18722);
        this.spellPut("e", -18710);
        this.spellPut("en", -18697);
        this.spellPut("er", -18696);
        this.spellPut("fa", -18526);
        this.spellPut("fan", -18518);
        this.spellPut("fang", -18501);
        this.spellPut("fei", -18490);
        this.spellPut("fen", -18478);
        this.spellPut("feng", -18463);
        this.spellPut("fo", -18448);
        this.spellPut("fou", -18447);
        this.spellPut("fu", -18446);
        this.spellPut("ga", -18239);
        this.spellPut("gai", -18237);
        this.spellPut("gan", -18231);
        this.spellPut("gang", -18220);
        this.spellPut("gao", -18211);
        this.spellPut("ge", -18201);
        this.spellPut("gei", -18184);
        this.spellPut("gen", -18183);
        this.spellPut("geng", -18181);
        this.spellPut("gong", -18012);
        this.spellPut("gou", -17997);
        this.spellPut("gu", -17988);
        this.spellPut("gua", -17970);
        this.spellPut("guai", -17964);
        this.spellPut("guan", -17961);
        this.spellPut("guang", -17950);
        this.spellPut("gui", -17947);
        this.spellPut("gun", -17931);
        this.spellPut("guo", -17928);
        this.spellPut("ha", -17922);
        this.spellPut("hai", -17759);
        this.spellPut("han", -17752);
        this.spellPut("hang", -17733);
        this.spellPut("hao", -17730);
        this.spellPut("he", -17721);
        this.spellPut("hei", -17703);
        this.spellPut("hen", -17701);
        this.spellPut("heng", -17697);
        this.spellPut("hong", -17692);
        this.spellPut("hou", -17683);
        this.spellPut("hu", -17676);
        this.spellPut("hua", -17496);
        this.spellPut("huai", -17487);
        this.spellPut("huan", -17482);
        this.spellPut("huang", -17468);
        this.spellPut("hui", -17454);
        this.spellPut("hun", -17433);
        this.spellPut("huo", -17427);
        this.spellPut("ji", -17417);
        this.spellPut("jia", -17202);
        this.spellPut("jian", -17185);
        this.spellPut("jiang", -16983);
        this.spellPut("jiao", -16970);
        this.spellPut("jie", -16942);
        this.spellPut("jin", -16915);
        this.spellPut("jing", -16733);
        this.spellPut("jiong", -16708);
        this.spellPut("jiu", -16706);
        this.spellPut("ju", -16689);
        this.spellPut("juan", -16664);
        this.spellPut("jue", -16657);
        this.spellPut("jun", -16647);
        this.spellPut("ka", -16474);
        this.spellPut("kai", -16470);
        this.spellPut("kan", -16465);
        this.spellPut("kang", -16459);
        this.spellPut("kao", -16452);
        this.spellPut("ke", -16448);
        this.spellPut("ken", -16433);
        this.spellPut("keng", -16429);
        this.spellPut("kong", -16427);
        this.spellPut("kou", -16423);
        this.spellPut("ku", -16419);
        this.spellPut("kua", -16412);
        this.spellPut("kuai", -16407);
        this.spellPut("kuan", -16403);
        this.spellPut("kuang", -16401);
        this.spellPut("kui", -16393);
        this.spellPut("kun", -16220);
        this.spellPut("kuo", -16216);
        this.spellPut("la", -16212);
        this.spellPut("lai", -16205);
        this.spellPut("lan", -16202);
        this.spellPut("lang", -16187);
        this.spellPut("lao", -16180);
        this.spellPut("le", -16171);
        this.spellPut("lei", -16169);
        this.spellPut("leng", -16158);
        this.spellPut("li", -16155);
        this.spellPut("lia", -15959);
        this.spellPut("lian", -15958);
        this.spellPut("liang", -15944);
        this.spellPut("liao", -15933);
        this.spellPut("lie", -15920);
        this.spellPut("lin", -15915);
        this.spellPut("ling", -15903);
        this.spellPut("liu", -15889);
        this.spellPut("long", -15878);
        this.spellPut("lou", -15707);
        this.spellPut("lu", -15701);
        this.spellPut("lv", -15681);
        this.spellPut("luan", -15667);
        this.spellPut("lue", -15661);
        this.spellPut("lun", -15659);
        this.spellPut("luo", -15652);
        this.spellPut("ma", -15640);
        this.spellPut("mai", -15631);
        this.spellPut("man", -15625);
        this.spellPut("mang", -15454);
        this.spellPut("mao", -15448);
        this.spellPut("me", -15436);
        this.spellPut("mei", -15435);
        this.spellPut("men", -15419);
        this.spellPut("meng", -15416);
        this.spellPut("mi", -15408);
        this.spellPut("mian", -15394);
        this.spellPut("miao", -15385);
        this.spellPut("mie", -15377);
        this.spellPut("min", -15375);
        this.spellPut("ming", -15369);
        this.spellPut("miu", -15363);
        this.spellPut("mo", -15362);
        this.spellPut("mou", -15183);
        this.spellPut("mu", -15180);
        this.spellPut("na", -15165);
        this.spellPut("nai", -15158);
        this.spellPut("nan", -15153);
        this.spellPut("nang", -15150);
        this.spellPut("nao", -15149);
        this.spellPut("ne", -15144);
        this.spellPut("nei", -15143);
        this.spellPut("nen", -15141);
        this.spellPut("neng", -15140);
        this.spellPut("ni", -15139);
        this.spellPut("nian", -15128);
        this.spellPut("niang", -15121);
        this.spellPut("niao", -15119);
        this.spellPut("nie", -15117);
        this.spellPut("nin", -15110);
        this.spellPut("ning", -15109);
        this.spellPut("niu", -14941);
        this.spellPut("nong", -14937);
        this.spellPut("nu", -14933);
        this.spellPut("nv", -14930);
        this.spellPut("nuan", -14929);
        this.spellPut("nue", -14928);
        this.spellPut("nuo", -14926);
        this.spellPut("o", -14922);
        this.spellPut("ou", -14921);
        this.spellPut("pa", -14914);
        this.spellPut("pai", -14908);
        this.spellPut("pan", -14902);
        this.spellPut("pang", -14894);
        this.spellPut("pao", -14889);
        this.spellPut("pei", -14882);
        this.spellPut("pen", -14873);
        this.spellPut("peng", -14871);
        this.spellPut("pi", -14857);
        this.spellPut("pian", -14678);
        this.spellPut("piao", -14674);
        this.spellPut("pie", -14670);
        this.spellPut("pin", -14668);
        this.spellPut("ping", -14663);
        this.spellPut("po", -14654);
        this.spellPut("pu", -14645);
        this.spellPut("qi", -14630);
        this.spellPut("qia", -14594);
        this.spellPut("qian", -14429);
        this.spellPut("qiang", -14407);
        this.spellPut("qiao", -14399);
        this.spellPut("qie", -14384);
        this.spellPut("qin", -14379);
        this.spellPut("qing", -14368);
        this.spellPut("qiong", -14355);
        this.spellPut("qiu", -14353);
        this.spellPut("qu", -14345);
        this.spellPut("quan", -14170);
        this.spellPut("que", -14159);
        this.spellPut("qun", -14151);
        this.spellPut("ran", -14149);
        this.spellPut("rang", -14145);
        this.spellPut("rao", -14140);
        this.spellPut("re", -14137);
        this.spellPut("ren", -14135);
        this.spellPut("reng", -14125);
        this.spellPut("ri", -14123);
        this.spellPut("rong", -14122);
        this.spellPut("rou", -14112);
        this.spellPut("ru", -14109);
        this.spellPut("ruan", -14099);
        this.spellPut("rui", -14097);
        this.spellPut("run", -14094);
        this.spellPut("ruo", -14092);
        this.spellPut("sa", -14090);
        this.spellPut("sai", -14087);
        this.spellPut("san", -14083);
        this.spellPut("sang", -13917);
        this.spellPut("sao", -13914);
        this.spellPut("se", -13910);
        this.spellPut("sen", -13907);
        this.spellPut("seng", -13906);
        this.spellPut("sha", -13905);
        this.spellPut("shai", -13896);
        this.spellPut("shan", -13894);
        this.spellPut("shang", -13878);
        this.spellPut("shao", -13870);
        this.spellPut("she", -13859);
        this.spellPut("shen", -13847);
        this.spellPut("sheng", -13831);
        this.spellPut("shi", -13658);
        this.spellPut("shou", -13611);
        this.spellPut("shu", -13601);
        this.spellPut("shua", -13406);
        this.spellPut("shuai", -13404);
        this.spellPut("shuan", -13400);
        this.spellPut("shuang", -13398);
        this.spellPut("shui", -13395);
        this.spellPut("shun", -13391);
        this.spellPut("shuo", -13387);
        this.spellPut("si", -13383);
        this.spellPut("song", -13367);
        this.spellPut("sou", -13359);
        this.spellPut("su", -13356);
        this.spellPut("suan", -13343);
        this.spellPut("sui", -13340);
        this.spellPut("sun", -13329);
        this.spellPut("suo", -13326);
        this.spellPut("ta", -13318);
        this.spellPut("tai", -13147);
        this.spellPut("tan", -13138);
        this.spellPut("tang", -13120);
        this.spellPut("tao", -13107);
        this.spellPut("te", -13096);
        this.spellPut("teng", -13095);
        this.spellPut("ti", -13091);
        this.spellPut("tian", -13076);
        this.spellPut("tiao", -13068);
        this.spellPut("tie", -13063);
        this.spellPut("ting", -13060);
        this.spellPut("tong", -12888);
        this.spellPut("tou", -12875);
        this.spellPut("tu", -12871);
        this.spellPut("tuan", -12860);
        this.spellPut("tui", -12858);
        this.spellPut("tun", -12852);
        this.spellPut("tuo", -12849);
        this.spellPut("wa", -12838);
        this.spellPut("wai", -12831);
        this.spellPut("wan", -12829);
        this.spellPut("wang", -12812);
        this.spellPut("wei", -12802);
        this.spellPut("wen", -12607);
        this.spellPut("weng", -12597);
        this.spellPut("wo", -12594);
        this.spellPut("wu", -12585);
        this.spellPut("xi", -12556);
        this.spellPut("xia", -12359);
        this.spellPut("xian", -12346);
        this.spellPut("xiang", -12320);
        this.spellPut("xiao", -12300);
        this.spellPut("xie", -12120);
        this.spellPut("xin", -12099);
        this.spellPut("xing", -12089);
        this.spellPut("xiong", -12074);
        this.spellPut("xiu", -12067);
        this.spellPut("xu", -12058);
        this.spellPut("xuan", -12039);
        this.spellPut("xue", -11867);
        this.spellPut("xun", -11861);
        this.spellPut("ya", -11847);
        this.spellPut("yan", -11831);
        this.spellPut("yang", -11798);
        this.spellPut("yao", -11781);
        this.spellPut("ye", -11604);
        this.spellPut("yi", -11589);
        this.spellPut("yin", -11536);
        this.spellPut("ying", -11358);
        this.spellPut("yo", -11340);
        this.spellPut("yong", -11339);
        this.spellPut("you", -11324);
        this.spellPut("yu", -11303);
        this.spellPut("yuan", -11097);
        this.spellPut("yue", -11077);
        this.spellPut("yun", -11067);
        this.spellPut("za", -11055);
        this.spellPut("zai", -11052);
        this.spellPut("zan", -11045);
        this.spellPut("zang", -11041);
        this.spellPut("zao", -11038);
        this.spellPut("ze", -11024);
        this.spellPut("zei", -11020);
        this.spellPut("zen", -11019);
        this.spellPut("zeng", -11018);
        this.spellPut("zha", -11014);
        this.spellPut("zhai", -10838);
        this.spellPut("zhan", -10832);
        this.spellPut("zhang", -10815);
        this.spellPut("zhao", -10800);
        this.spellPut("zhe", -10790);
        this.spellPut("zhen", -10780);
        this.spellPut("zheng", -10764);
        this.spellPut("zhi", -10587);
        this.spellPut("zhong", -10544);
        this.spellPut("zhou", -10533);
        this.spellPut("zhu", -10519);
        this.spellPut("zhua", -10331);
        this.spellPut("zhuai", -10329);
        this.spellPut("zhuan", -10328);
        this.spellPut("zhuang", -10322);
        this.spellPut("zhui", -10315);
        this.spellPut("zhun", -10309);
        this.spellPut("zhuo", -10307);
        this.spellPut("zi", -10296);
        this.spellPut("zong", -10281);
        this.spellPut("zou", -10274);
        this.spellPut("zu", -10270);
        this.spellPut("zuan", -10262);
        this.spellPut("zui", -10260);
        this.spellPut("zun", -10256);
        this.spellPut("zuo", -10254);
    }

    private int getCnAscii(char cn) {
        byte[] bytes = null;
        try {
            bytes = String.valueOf(cn).getBytes("GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (bytes == null || bytes.length > 2 || bytes.length <= 0) {
            return 0;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            int hightByte = 256 + bytes[0];
            int lowByte = 256 + bytes[1];
            int ascii = 256 * hightByte + lowByte - 65536;
            return ascii;
        }
        return 0;
    }

    private String getSpellByAscii(int ascii) {
        if (ascii > 0 && ascii < 160) {
            return String.valueOf((char)ascii);
        }
        if (ascii < -20319 || ascii > -10247) {
            return null;
        }
        Set<String> keySet = spellMap.keySet();
        Iterator<String> it = keySet.iterator();
        String spell0 = null;
        String spell = null;
        int asciiRang0 = -20319;
        while (it.hasNext()) {
            spell = it.next();
            Integer valObj = spellMap.get(spell);
            if (!(valObj instanceof Integer)) continue;
            int asciiRang = valObj;
            if (ascii >= asciiRang0 && ascii < asciiRang) {
                return spell0 == null ? spell : spell0;
            }
            spell0 = spell;
            asciiRang0 = asciiRang;
        }
        return null;
    }

    private boolean isAlphabet(int ascii) {
        return ascii > 0 && ascii < 160;
    }

    public String convert(String input, boolean lowerCase) {
        if (input == null || "".equals(input.trim())) {
            return input;
        }
        boolean isChinese = false;
        char[] chars = input.toCharArray();
        StringBuffer retuBuf = new StringBuffer();
        StringBuffer resultBuf = new StringBuffer();
        int i = 0;
        int Len = chars.length;
        while (i < Len) {
            int ascii = this.getCnAscii(chars[i]);
            if (ascii == 0) {
                retuBuf.append(chars[i]);
            } else {
                String spell = this.getSpellByAscii(ascii);
                if (spell == null) {
                    retuBuf.append(chars[i]);
                } else {
                    retuBuf.append(spell);
                }
                if (!this.isAlphabet(ascii)) {
                    isChinese = true;
                }
            }
            ++i;
        }
        if (isChinese) {
            resultBuf.append("");
            resultBuf.append(retuBuf.toString());
        } else {
            resultBuf.append(retuBuf.toString());
        }
        if (lowerCase) {
            return resultBuf.toString().toLowerCase();
        }
        return resultBuf.toString().toUpperCase();
    }
}

