/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.assist;

import java.io.IOException;
import java.io.InputStream;

public class ContentLengthInputStream
extends InputStream {
    private final InputStream stream;
    private final long length;
    private long pos;

    public ContentLengthInputStream(InputStream stream, long length) {
        this.stream = stream;
        this.length = length;
    }

    @Override
    public synchronized int available() {
        return (int)(this.length - this.pos);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.pos = readlimit;
        this.stream.mark(readlimit);
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        this.pos += (long)byteCount;
        return this.stream.read(buffer, byteOffset, byteCount);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.pos = 0L;
        this.stream.reset();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        this.pos += byteCount;
        return this.stream.skip(byteCount);
    }
}

