/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;

public class BarChart
extends BarLineChartBase {
    private float mSkew = 0.3f;
    private float mDepth = 0.3f;
    private boolean m3DEnabled = false;
    private boolean mDrawHighlightArrow = false;
    private boolean mDrawValueAboveBar = true;
    private boolean mDrawValuesForWholeStack = true;
    private boolean mDrawBarShadow = true;
    private RectF mBarShadow = new RectF();
    private RectF mBarRect = new RectF();

    public BarChart(Context context) {
        super(context);
    }

    public BarChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(0);
        this.mHighlightPaint.setAlpha(120);
    }

    public void setData(BarData data) {
        super.setData(data);
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        this.mDeltaX += 1.0f;
        this.mDeltaX *= (float)this.mOriginalData.getDataSetCount();
        int maxEntry = 0;
        int i = 0;
        while (i < this.mOriginalData.getDataSetCount()) {
            DataSet set = this.mOriginalData.getDataSetByIndex(i);
            if (maxEntry < set.getEntryCount()) {
                maxEntry = set.getEntryCount();
            }
            ++i;
        }
        float groupSpace = ((BarData)this.mOriginalData).getGroupSpace();
        this.mDeltaX += (float)maxEntry * groupSpace;
    }

    @Override
    protected void drawHighlights() {
        BarData bd = (BarData)this.mOriginalData;
        int setCount = this.mOriginalData.getDataSetCount();
        int i = 0;
        while (i < this.mIndicesToHightlight.length) {
            Highlight h = this.mIndicesToHightlight[i];
            int index = h.getXIndex();
            int dataSetIndex = h.getDataSetIndex();
            BarDataSet ds = (BarDataSet)this.mCurrentData.getDataSetByIndex(dataSetIndex);
            this.mHighlightPaint.setColor(ds.getHighLightColor());
            this.mHighlightPaint.setAlpha(ds.getHighLightAlpha());
            if (index < this.mCurrentData.getYValCount() && index >= 0 && (float)index < this.mDeltaX * this.mPhaseX / (float)this.mOriginalData.getDataSetCount()) {
                Entry e = this.getEntryByDataSetIndex(index, dataSetIndex);
                float x = (float)(index * setCount + dataSetIndex) + bd.getGroupSpace() / 2.0f + bd.getGroupSpace() * (float)index;
                float y = e.getVal();
                this.prepareBar(x, y, ds.getBarSpace());
                this.mDrawCanvas.drawRect(this.mBarRect, this.mHighlightPaint);
                if (this.mDrawHighlightArrow) {
                    this.mHighlightPaint.setAlpha(255);
                    float offsetY = this.mDeltaY * 0.07f;
                    Path arrow = new Path();
                    arrow.moveTo(x + 0.5f, y + offsetY * 0.3f);
                    arrow.lineTo(x + 0.2f, y + offsetY);
                    arrow.lineTo(x + 0.8f, y + offsetY);
                    this.transformPath(arrow);
                    this.mDrawCanvas.drawPath(arrow, this.mHighlightPaint);
                }
            }
            ++i;
        }
    }

    @Override
    protected void drawData() {
        BarData bd = (BarData)this.mCurrentData;
        ArrayList<? extends DataSet> dataSets = bd.getDataSets();
        int setCount = bd.getDataSetCount();
        int i = 0;
        while (i < setCount) {
            BarDataSet dataSet = (BarDataSet)dataSets.get(i);
            boolean noStacks = dataSet.getStackSize() == 1;
            ArrayList<? extends Entry> entries = dataSet.getYVals();
            float spaceSum = bd.getGroupSpace() / 2.0f;
            int j = 0;
            while ((float)j < (float)dataSet.getEntryCount() * this.mPhaseX) {
                BarEntry e = (BarEntry)entries.get(j);
                float x = (float)(e.getXIndex() + j * (setCount - 1) + i) + spaceSum;
                float y = e.getVal();
                spaceSum += bd.getGroupSpace();
                if (noStacks) {
                    this.prepareBar(x, y, dataSet.getBarSpace());
                    if (this.isOffContentRight(this.mBarRect.left)) break;
                    if (!this.isOffContentLeft(this.mBarRect.right)) {
                        if (this.mDrawBarShadow) {
                            this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                            this.mDrawCanvas.drawRect(this.mBarShadow, this.mRenderPaint);
                        }
                        this.mRenderPaint.setColor(dataSet.getColor(j));
                        this.mDrawCanvas.drawRect(this.mBarRect, this.mRenderPaint);
                    }
                } else {
                    float[] vals = e.getVals();
                    if (vals == null) {
                        this.prepareBar(x, y, dataSet.getBarSpace());
                        if (this.mDrawBarShadow) {
                            this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                            this.mDrawCanvas.drawRect(this.mBarShadow, this.mRenderPaint);
                        }
                        this.mRenderPaint.setColor(dataSet.getColor(0));
                        this.mDrawCanvas.drawRect(this.mBarRect, this.mRenderPaint);
                    } else {
                        float all = e.getVal();
                        if (this.mDrawBarShadow) {
                            this.prepareBar(x, y, dataSet.getBarSpace());
                            this.mRenderPaint.setColor(dataSet.getBarShadowColor());
                            this.mDrawCanvas.drawRect(this.mBarShadow, this.mRenderPaint);
                        }
                        int k = 0;
                        while (k < vals.length) {
                            this.prepareBar(x, vals[k] + (all -= vals[k]), dataSet.getBarSpace());
                            this.mRenderPaint.setColor(dataSet.getColor(k));
                            this.mDrawCanvas.drawRect(this.mBarRect, this.mRenderPaint);
                            ++k;
                        }
                    }
                    if (this.isOffContentRight(this.mBarRect.left)) break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void prepareBar(float x, float y, float barspace) {
        float spaceHalf = barspace / 2.0f;
        float left = x + spaceHalf;
        float right = x + 1.0f - spaceHalf;
        float top = y >= 0.0f ? y : 0.0f;
        float bottom = y <= 0.0f ? y : 0.0f;
        this.mBarRect.set(left, top, right, bottom);
        this.transformRectWithPhase(this.mBarRect);
        if (this.mDrawBarShadow) {
            this.mBarShadow.set(this.mBarRect.left, this.mOffsetTop, this.mBarRect.right, (float)this.getHeight() - this.mOffsetBottom);
        }
    }

    @Override
    protected void drawXLabels(float yPos) {
        float[] position = new float[]{0.0f, 0.0f};
        BarData bd = (BarData)this.mCurrentData;
        int step = this.mCurrentData.getDataSetCount();
        int i = 0;
        while (i < this.mCurrentData.getXValCount()) {
            position[0] = (float)(i * step) + (float)i * bd.getGroupSpace() + bd.getGroupSpace() / 2.0f;
            if (this.mXLabels.isCenterXLabelsEnabled()) {
                position[0] = position[0] + (float)step / 2.0f;
            }
            this.transformPointArray(position);
            if (position[0] >= this.mOffsetLeft && position[0] <= (float)this.getWidth() - this.mOffsetRight) {
                String label = this.mCurrentData.getXVals().get(i);
                if (this.mXLabels.isAvoidFirstLastClippingEnabled()) {
                    float width;
                    if (i == this.mCurrentData.getXValCount() - 1) {
                        width = Utils.calcTextWidth(this.mXLabelPaint, label);
                        if (width > this.getOffsetRight() * 2.0f && position[0] + width > (float)this.getWidth()) {
                            position[0] = position[0] - width / 2.0f;
                        }
                    } else if (i == 0) {
                        width = Utils.calcTextWidth(this.mXLabelPaint, label);
                        position[0] = position[0] + width / 2.0f;
                    }
                }
                this.mDrawCanvas.drawText(label, position[0], yPos, this.mXLabelPaint);
            }
            i += this.mXLabels.mXAxisLabelModulus;
        }
    }

    @Override
    protected void drawVerticalGrid() {
        if (!this.mDrawVerticalGrid || this.mCurrentData == null) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        BarData bd = (BarData)this.mCurrentData;
        int step = this.mCurrentData.getDataSetCount();
        int i = 0;
        while (i < this.mCurrentData.getXValCount()) {
            position[0] = (float)(i * step) + (float)i * bd.getGroupSpace();
            this.transformPointArray(position);
            if (position[0] >= this.mOffsetLeft && position[0] <= (float)this.getWidth()) {
                this.mDrawCanvas.drawLine(position[0], this.mOffsetTop, position[0], (float)this.getHeight() - this.mOffsetBottom, this.mGridPaint);
            }
            i += this.mXLabels.mXAxisLabelModulus;
        }
    }

    @Override
    protected void drawValues() {
        if (this.mDrawYValues && (float)this.mCurrentData.getYValCount() < (float)this.mMaxVisibleCount * this.mScaleX) {
            ArrayList<? extends DataSet> dataSets = this.mCurrentData.getDataSets();
            float offset = 0.0f;
            offset = this.mDrawValueAboveBar ? -Utils.convertDpToPixel(5.0f) : (float)Utils.calcTextHeight(this.mValuePaint, "8") * 1.5f;
            int i = 0;
            while (i < this.mCurrentData.getDataSetCount()) {
                int j;
                BarDataSet dataSet = (BarDataSet)dataSets.get(i);
                ArrayList<? extends Entry> entries = dataSet.getYVals();
                float[] valuePoints = this.generateTransformedValuesBarChart(entries, i);
                if (!this.mDrawValuesForWholeStack) {
                    j = 0;
                    while ((float)j < (float)valuePoints.length * this.mPhaseX) {
                        if (!this.isOffContentRight(valuePoints[j])) {
                            if (!(this.isOffContentLeft(valuePoints[j]) || this.isOffContentTop(valuePoints[j + 1]) || this.isOffContentBottom(valuePoints[j + 1]))) {
                                float val = ((BarEntry)entries.get(j / 2)).getVal();
                                this.drawValue(this.mFormatValue.format(val), valuePoints[j], valuePoints[j + 1] + offset);
                            }
                            j += 2;
                            continue;
                        }
                        break;
                    }
                } else {
                    j = 0;
                    while ((float)j < (float)(valuePoints.length - 1) * this.mPhaseX) {
                        if (!this.isOffContentRight(valuePoints[j])) {
                            if (!(this.isOffContentLeft(valuePoints[j]) || this.isOffContentTop(valuePoints[j + 1]) || this.isOffContentBottom(valuePoints[j + 1]))) {
                                BarEntry e = (BarEntry)entries.get(j / 2);
                                float[] vals = e.getVals();
                                if (vals == null) {
                                    this.drawValue(this.mFormatValue.format(e.getVal()), valuePoints[j], valuePoints[j + 1] + offset);
                                } else {
                                    float[] transformed = new float[vals.length * 2];
                                    int cnt = 0;
                                    float add = e.getVal();
                                    int k = 0;
                                    while (k < transformed.length) {
                                        transformed[k + 1] = (vals[cnt] + (add -= vals[cnt])) * this.mPhaseY;
                                        ++cnt;
                                        k += 2;
                                    }
                                    this.transformPointArray(transformed);
                                    k = 0;
                                    while (k < transformed.length) {
                                        this.drawValue(this.mFormatValue.format(vals[k / 2]), valuePoints[j], transformed[k + 1] + offset);
                                        k += 2;
                                    }
                                }
                            }
                            j += 2;
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void drawValue(String val, float xPos, float yPos) {
        if (this.mDrawUnitInChart) {
            this.mDrawCanvas.drawText(String.valueOf(val) + this.mUnit, xPos, yPos, this.mValuePaint);
        } else {
            this.mDrawCanvas.drawText(val, xPos, yPos, this.mValuePaint);
        }
    }

    @Override
    public Highlight getHighlightByTouchPoint(float x, float y) {
        double xTouchVal;
        if (this.mDataNotSet) {
            Log.e((String)"MPChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        float[] pts = new float[]{x, y};
        Matrix tmp = new Matrix();
        this.mMatrixOffset.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixTouch.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixValueToPx.invert(tmp);
        tmp.mapPoints(pts);
        double base = xTouchVal = (double)pts[0];
        if (xTouchVal < 0.0 || xTouchVal > (double)this.mDeltaX) {
            return null;
        }
        if (base < 0.0) {
            base = 0.0;
        }
        if (base >= (double)this.mDeltaX) {
            base = this.mDeltaX - 1.0f;
        }
        int setCount = this.mOriginalData.getDataSetCount();
        int valCount = setCount * this.mOriginalData.getXValCount();
        BarData bd = (BarData)this.mCurrentData;
        float space = (float)((double)((float)valCount / (float)setCount) / ((double)this.mDeltaX / base));
        float reduction = space * bd.getGroupSpace();
        int xIndex = (int)((base - (double)reduction) / (double)setCount);
        int dataSetIndex = (int)(base - (double)reduction) % setCount;
        if (dataSetIndex == -1) {
            return null;
        }
        return new Highlight(xIndex, dataSetIndex);
    }

    public void setSkew(float skew) {
        this.mSkew = skew;
    }

    public float getSkew() {
        return this.mSkew;
    }

    public void setDepth(float depth) {
        this.mDepth = depth;
    }

    public float getDepth() {
        return this.mDepth;
    }

    public void set3DEnabled(boolean enabled) {
        this.m3DEnabled = enabled;
    }

    public boolean is3DEnabled() {
        return this.m3DEnabled;
    }

    public void setDrawHighlightArrow(boolean enabled) {
        this.mDrawHighlightArrow = enabled;
    }

    public boolean isDrawHighlightArrowEnabled() {
        return this.mDrawHighlightArrow;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 16: {
                this.mHighlightPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 16: {
                return this.mHighlightPaint;
            }
        }
        return null;
    }

    public void setDrawValueAboveBar(boolean enabled) {
        this.mDrawValueAboveBar = enabled;
    }

    public boolean isDrawValueAboveBarEnabled() {
        return this.mDrawValueAboveBar;
    }

    public void setDrawValuesForWholeStack(boolean enabled) {
        this.mDrawValuesForWholeStack = enabled;
    }

    public boolean isDrawValuesForWholeStackEnabled() {
        return this.mDrawValuesForWholeStack;
    }

    public void setDrawBarShadow(boolean enabled) {
        this.mDrawBarShadow = enabled;
    }

    public boolean isDrawBarShadowEnabled() {
        return this.mDrawBarShadow;
    }

    @Override
    protected void drawAdditional() {
    }
}

