/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import com.github.mikephil.charting.charts.CandleStickChart;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.data.BarLineScatterCandleData;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.filter.Approximator;
import com.github.mikephil.charting.interfaces.OnDrawListener;
import com.github.mikephil.charting.listener.BarLineChartTouchListener;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Legend;
import com.github.mikephil.charting.utils.LimitLine;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.XLabels;
import com.github.mikephil.charting.utils.YLabels;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class BarLineChartBase
extends Chart {
    private boolean mInvertYAxis = false;
    protected int mMaxVisibleCount = 100;
    private float mMinScaleY = 1.0f;
    private float mMinScaleX = 1.0f;
    protected float mScaleX = 1.0f;
    protected float mScaleY = 1.0f;
    protected float mMaxScaleY = 10.0f;
    protected float mGridWidth = 1.0f;
    protected boolean mPinchZoomEnabled = false;
    protected boolean mDragScaleEnabled = true;
    protected boolean mFixedYValues = false;
    protected boolean mStartAtZero = true;
    protected boolean mFilterData = false;
    protected Paint mGridPaint;
    protected Paint mGridBackgroundPaint;
    protected Paint mBorderPaint;
    protected Paint mXLabelPaint;
    protected Paint mYLabelPaint;
    protected Paint mHighlightPaint;
    protected Paint mLimitLinePaint;
    protected boolean mHighLightIndicatorEnabled = true;
    protected boolean mAutoFinishDrawing;
    protected boolean mDrawVerticalGrid = true;
    protected boolean mDrawHorizontalGrid = true;
    protected boolean mDrawYLabels = true;
    protected boolean mDrawXLabels = true;
    protected boolean mDrawBorder = true;
    protected boolean mDrawGridBackground = true;
    protected OnDrawListener mDrawListener;
    protected YLabels mYLabels = new YLabels();
    protected XLabels mXLabels = new XLabels();
    private Approximator mApproximator;
    protected DecimalFormat mFormatValue = null;
    protected int mYLabelFormatDigits = -1;
    private BorderPosition[] mBorderPositions = new BorderPosition[]{BorderPosition.BOTTOM};
    protected View.OnTouchListener mListener;

    public BarLineChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BarLineChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarLineChartBase(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.mListener = new BarLineChartTouchListener(this, this.mMatrixTouch);
        this.mXLabelPaint = new Paint(1);
        this.mXLabelPaint.setColor(-16777216);
        this.mXLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mXLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mYLabelPaint = new Paint(1);
        this.mYLabelPaint.setColor(-16777216);
        this.mYLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
        this.mGridPaint = new Paint();
        this.mGridPaint.setColor(-7829368);
        this.mGridPaint.setStrokeWidth(this.mGridWidth);
        this.mGridPaint.setStyle(Paint.Style.STROKE);
        this.mGridPaint.setAlpha(90);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStrokeWidth(this.mGridWidth * 2.0f);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mGridBackgroundPaint = new Paint();
        this.mGridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mGridBackgroundPaint.setColor(0);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        this.mLimitLinePaint = new Paint(1);
        this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        if (this.mFilterData) {
            this.mCurrentData = this.getFilteredData();
            Log.i((String)"MPChart", (String)("FilterTime: " + (System.currentTimeMillis() - starttime) + " ms"));
            starttime = System.currentTimeMillis();
        } else {
            this.mCurrentData = this.getDataOriginal();
        }
        if (this.mXLabels.isAdjustXLabelsEnabled()) {
            this.calcModulus();
        }
        this.drawGridBackground();
        this.drawBorder();
        this.prepareYLabels();
        int clipRestoreCount = this.mDrawCanvas.save();
        this.mDrawCanvas.clipRect(this.mContentRect);
        this.drawHorizontalGrid();
        this.drawVerticalGrid();
        this.drawData();
        this.drawLimitLines();
        if (this.mHighlightEnabled && this.mHighLightIndicatorEnabled && this.valuesToHighlight()) {
            this.drawHighlights();
        }
        this.mDrawCanvas.restoreToCount(clipRestoreCount);
        this.drawAdditional();
        this.drawXLabels();
        this.drawYLabels();
        this.drawValues();
        this.drawLegend();
        this.drawMarkers();
        this.drawDescription();
        canvas.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mDrawPaint);
        Log.i((String)"MPChart", (String)("DrawTime: " + (System.currentTimeMillis() - starttime) + " ms"));
    }

    @Override
    public void prepare() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax(this.mFixedYValues);
        this.prepareXLabels();
        this.calcFormats();
        this.prepareLegend();
    }

    @Override
    public void notifyDataSetChanged() {
        if (!this.mFixedYValues) {
            this.prepare();
        } else {
            this.calcMinMax(this.mFixedYValues);
        }
    }

    @Override
    protected void calculateOffsets() {
        if (this.mLegend == null) {
            return;
        }
        if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
            float spacing = Utils.convertDpToPixel(7.0f);
            this.mLegend.setOffsetRight((float)this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint) + this.mLegend.getFormSize() + this.mLegend.getFormToTextSpace() + spacing);
            this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
            if (this.mXLabels.getPosition() == XLabels.XLabelPosition.TOP) {
                this.mLegend.setOffsetBottom(this.mLegendLabelPaint.getTextSize() * 3.5f);
            } else {
                this.mLegend.setOffsetBottom(this.mLegendLabelPaint.getTextSize() * 2.5f);
            }
        }
        float yleft = 0.0f;
        float yright = 0.0f;
        float xtop = 0.0f;
        float xbottom = 0.0f;
        if (this.mYLabels.getPosition() == YLabels.YLabelPosition.LEFT) {
            yleft = this.mYChartMin >= 0.0f ? (float)Utils.calcTextWidth(this.mYLabelPaint, String.valueOf((int)this.mDeltaY) + ".00" + this.mUnit) : (float)Utils.calcTextWidth(this.mYLabelPaint, String.valueOf((int)(this.mDeltaY * -1.0f)) + ".00" + this.mUnit);
            this.mYLabelPaint.setTextAlign(Paint.Align.RIGHT);
        } else if (this.mYLabels.getPosition() == YLabels.YLabelPosition.RIGHT) {
            yright = this.mYChartMin >= 0.0f ? (float)Utils.calcTextWidth(this.mYLabelPaint, String.valueOf((int)this.mDeltaY) + ".00" + this.mUnit) : (float)Utils.calcTextWidth(this.mYLabelPaint, String.valueOf((int)(this.mDeltaY * -1.0f)) + ".00" + this.mUnit);
            this.mYLabelPaint.setTextAlign(Paint.Align.LEFT);
        } else if (this.mYLabels.getPosition() == YLabels.YLabelPosition.BOTH_SIDED) {
            float width = 0.0f;
            width = this.mYChartMin >= 0.0f ? (float)Utils.calcTextWidth(this.mYLabelPaint, String.valueOf((int)this.mDeltaY) + ".00" + this.mUnit) : (float)Utils.calcTextWidth(this.mYLabelPaint, String.valueOf((int)(this.mDeltaY * -1.0f)) + ".00" + this.mUnit);
            yright = width;
            yleft = width;
        }
        if (this.mXLabels.getPosition() == XLabels.XLabelPosition.BOTTOM) {
            xbottom = (float)Utils.calcTextHeight(this.mXLabelPaint, "Q") * 2.0f;
        } else if (this.mXLabels.getPosition() == XLabels.XLabelPosition.TOP) {
            xtop = (float)Utils.calcTextHeight(this.mXLabelPaint, "Q") * 2.0f;
        } else if (this.mXLabels.getPosition() == XLabels.XLabelPosition.BOTH_SIDED) {
            float height;
            xbottom = height = (float)Utils.calcTextHeight(this.mXLabelPaint, "Q") * 2.0f;
            xtop = height;
        }
        if (this.mDrawLegend) {
            if (this.mDrawXLabels) {
                this.mOffsetBottom = Math.max(this.mOffsetBottom, xbottom + this.mLegend.getOffsetBottom());
                this.mOffsetTop = Math.max(this.mOffsetTop, xtop + this.mLegend.getOffsetTop());
            } else {
                this.mOffsetBottom = Math.max(this.mOffsetBottom, this.mLegend.getOffsetBottom());
                this.mOffsetTop = Math.max(this.mOffsetTop, this.mLegend.getOffsetTop());
            }
            if (this.mDrawYLabels) {
                this.mOffsetLeft = Math.max(this.mOffsetLeft, yleft + this.mLegend.getOffsetLeft());
                this.mOffsetRight = Math.max(this.mOffsetRight, yright + this.mLegend.getOffsetRight());
            } else {
                this.mOffsetLeft = Math.max(this.mOffsetLeft, this.mLegend.getOffsetLeft());
                this.mOffsetRight = Math.max(this.mOffsetRight, this.mLegend.getOffsetRight());
            }
        } else {
            if (this.mDrawXLabels) {
                this.mOffsetBottom = Math.max(this.mOffsetBottom, xbottom);
                this.mOffsetTop = Math.max(this.mOffsetTop, xtop);
            }
            if (this.mDrawYLabels) {
                this.mOffsetLeft = Math.max(this.mOffsetLeft, yleft);
                this.mOffsetRight = Math.max(this.mOffsetRight, yright);
            }
        }
        this.mLegend.setOffsetTop(this.mOffsetTop);
        this.mLegend.setOffsetLeft(this.mOffsetLeft);
        this.prepareContentRect();
        float scaleX = ((float)this.getWidth() - this.mOffsetLeft - this.mOffsetRight) / this.mDeltaX;
        float scaleY = ((float)this.getHeight() - this.mOffsetBottom - this.mOffsetTop) / this.mDeltaY;
        Matrix val = new Matrix();
        val.postTranslate(0.0f, -this.mYChartMin);
        val.postScale(scaleX, -scaleY);
        this.mMatrixValueToPx.set(val);
        Matrix offset = new Matrix();
        if (!this.mInvertYAxis) {
            offset.postTranslate(this.mOffsetLeft, (float)this.getHeight() - this.mOffsetBottom);
        } else {
            offset.setTranslate(this.mOffsetLeft, -this.getOffsetTop());
            offset.postScale(1.0f, -1.0f);
        }
        this.mMatrixOffset.set(offset);
    }

    public void calculateLegendOffsets() {
        if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
            this.mLegend.setOffsetRight(this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint));
            this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT) {
            if (this.mXLabels.getPosition() == XLabels.XLabelPosition.TOP) {
                this.mLegend.setOffsetBottom(this.mLegendLabelPaint.getTextSize() * 3.5f);
            } else {
                this.mLegend.setOffsetBottom(this.mLegendLabelPaint.getTextSize() * 2.5f);
            }
        }
    }

    protected void calcModulus() {
        float[] values = new float[9];
        this.mMatrixTouch.getValues(values);
        this.mXLabels.mXAxisLabelModulus = (int)Math.ceil((float)(this.mCurrentData.getXValCount() * this.mXLabels.mLabelWidth) / ((float)this.mContentRect.width() * values[0]));
    }

    protected void calcFormats() {
        this.mValueFormatDigits = this.mValueDigitsToUse == -1 ? Utils.getFormatDigits(this.mDeltaY) : this.mValueDigitsToUse;
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.mValueFormatDigits) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
            ++i;
        }
        this.mFormatValue = new DecimalFormat("###,###,###,##0" + b.toString());
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        float space = Math.abs(Math.max(Math.abs(this.mYChartMax), Math.abs(this.mYChartMin)) / 100.0f * 15.0f);
        if (this.mStartAtZero) {
            if (this.mYChartMax < 0.0f) {
                this.mYChartMax = 0.0f;
                this.mYChartMin -= space;
            } else {
                this.mYChartMin = 0.0f;
                this.mYChartMax += space;
            }
        } else {
            this.mYChartMin -= space / 2.0f;
            this.mYChartMax += space / 2.0f;
        }
        this.mDeltaY = Math.abs(this.mYChartMax - this.mYChartMin);
    }

    protected void prepareXLabels() {
        StringBuffer a = new StringBuffer();
        int max = Math.round(this.mCurrentData.getXValAverageLength() + (float)this.mXLabels.getSpaceBetweenLabels());
        int i = 0;
        while (i < max) {
            a.append("h");
            ++i;
        }
        this.mXLabels.mLabelWidth = Utils.calcTextWidth(this.mXLabelPaint, a.toString());
        this.mXLabels.mLabelHeight = Utils.calcTextWidth(this.mXLabelPaint, "Q");
    }

    private void prepareYLabels() {
        double intervalMagnitude;
        PointD p1 = this.getValuesByTouchPoint(this.mContentRect.left, this.mContentRect.top);
        PointD p2 = this.getValuesByTouchPoint(this.mContentRect.left, this.mContentRect.bottom);
        if (!this.mInvertYAxis) {
            this.mYChartMin = (float)p2.y;
            this.mYChartMax = (float)p1.y;
        } else {
            this.mYChartMin = !this.mStartAtZero ? (float)Math.min(p1.y, p2.y) : 0.0f;
            this.mYChartMax = (float)Math.max(p1.y, p2.y);
        }
        float yMin = this.mYChartMin;
        float yMax = this.mYChartMax;
        int labelCount = this.mYLabels.getLabelCount();
        double range = yMax - yMin;
        if (labelCount == 0 || range <= 0.0) {
            this.mYLabels.mEntries = new float[0];
            this.mYLabels.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        double first = Math.ceil((double)yMin / interval) * interval;
        double last = Utils.nextUp(Math.floor((double)yMax / interval) * interval);
        int n = 0;
        double f = first;
        while (f <= last) {
            ++n;
            f += interval;
        }
        this.mYLabels.mEntryCount = n;
        if (this.mYLabels.mEntries.length < n) {
            this.mYLabels.mEntries = new float[n];
        }
        f = first;
        int i = 0;
        while (i < n) {
            this.mYLabels.mEntries[i] = (float)f;
            f += interval;
            ++i;
        }
        this.mYLabels.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
    }

    private void drawXLabels() {
        if (!this.mDrawXLabels) {
            return;
        }
        float yoffset = Utils.convertDpToPixel(3.5f);
        this.mXLabelPaint.setTypeface(this.mXLabels.getTypeface());
        this.mXLabelPaint.setTextSize(this.mXLabels.getTextSize());
        if (this.mXLabels.getPosition() == XLabels.XLabelPosition.TOP) {
            this.drawXLabels(this.getOffsetTop() - yoffset);
        } else if (this.mXLabels.getPosition() == XLabels.XLabelPosition.BOTTOM) {
            this.drawXLabels((float)this.getHeight() - this.mOffsetBottom + (float)this.mXLabels.mLabelHeight + yoffset * 1.5f);
        } else {
            this.drawXLabels(this.getOffsetTop() - 7.0f);
            this.drawXLabels((float)this.getHeight() - this.mOffsetBottom + (float)this.mXLabels.mLabelHeight + yoffset * 1.6f);
        }
    }

    protected void drawXLabels(float yPos) {
        float[] position = new float[]{0.0f, 0.0f};
        int i = 0;
        while (i < this.mCurrentData.getXValCount()) {
            position[0] = i;
            if (this.mXLabels.isCenterXLabelsEnabled()) {
                position[0] = position[0] + 0.5f;
            }
            this.transformPointArray(position);
            if (position[0] >= this.mOffsetLeft && position[0] <= (float)this.getWidth() - this.mOffsetRight) {
                String label = this.mCurrentData.getXVals().get(i);
                if (this.mXLabels.isAvoidFirstLastClippingEnabled()) {
                    float width;
                    if (i == this.mCurrentData.getXValCount() - 1) {
                        width = Utils.calcTextWidth(this.mXLabelPaint, label);
                        if (width > this.getOffsetRight() * 2.0f && position[0] + width > (float)this.getWidth()) {
                            position[0] = position[0] - width / 2.0f;
                        }
                    } else if (i == 0) {
                        width = Utils.calcTextWidth(this.mXLabelPaint, label);
                        position[0] = position[0] + width / 2.0f;
                    }
                }
                this.mDrawCanvas.drawText(label, position[0], yPos, this.mXLabelPaint);
            }
            i += this.mXLabels.mXAxisLabelModulus;
        }
    }

    private void drawYLabels() {
        if (!this.mDrawYLabels) {
            return;
        }
        float[] positions = new float[this.mYLabels.mEntryCount * 2];
        int i = 0;
        while (i < positions.length) {
            positions[i + 1] = this.mYLabels.mEntries[i / 2];
            i += 2;
        }
        this.transformPointArray(positions);
        float xoffset = Utils.convertDpToPixel(5.0f);
        float yoffset = (float)Utils.calcTextHeight(this.mYLabelPaint, "A") / 2.5f;
        this.mYLabelPaint.setTypeface(this.mYLabels.getTypeface());
        this.mYLabelPaint.setTextSize(this.mYLabels.getTextSize());
        if (this.mYLabels.getPosition() == YLabels.YLabelPosition.LEFT) {
            this.mYLabelPaint.setTextAlign(Paint.Align.RIGHT);
            this.drawYLabels(this.mOffsetLeft - xoffset, positions, yoffset);
        } else if (this.mYLabels.getPosition() == YLabels.YLabelPosition.RIGHT) {
            this.mYLabelPaint.setTextAlign(Paint.Align.LEFT);
            this.drawYLabels((float)this.getWidth() - this.mOffsetRight + xoffset, positions, yoffset);
        } else {
            this.mYLabelPaint.setTextAlign(Paint.Align.RIGHT);
            this.drawYLabels(this.mOffsetLeft - xoffset, positions, yoffset);
            this.mYLabelPaint.setTextAlign(Paint.Align.LEFT);
            this.drawYLabels((float)this.getWidth() - this.mOffsetRight + xoffset, positions, yoffset);
        }
    }

    private void drawYLabels(float xPos, float[] positions, float yOffset) {
        int i = 0;
        while (i < this.mYLabels.mEntryCount) {
            String text = Utils.formatNumber(this.mYLabels.mEntries[i], this.mYLabels.mDecimals, this.mSeparateTousands);
            if (!this.mYLabels.isDrawTopYLabelEntryEnabled() && i >= this.mYLabels.mEntryCount - 1) {
                return;
            }
            if (this.mYLabels.isDrawUnitsInYLabelEnabled()) {
                this.mDrawCanvas.drawText(String.valueOf(text) + this.mUnit, xPos, positions[i * 2 + 1] + yOffset, this.mYLabelPaint);
            } else {
                this.mDrawCanvas.drawText(text, xPos, positions[i * 2 + 1] + yOffset, this.mYLabelPaint);
            }
            ++i;
        }
    }

    protected void drawBorder() {
        if (!this.mDrawBorder || this.mBorderPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.mBorderPositions.length) {
            switch (this.mBorderPositions[i]) {
                case LEFT: {
                    this.mDrawCanvas.drawLine(this.mOffsetLeft, this.mOffsetTop, this.mOffsetLeft, (float)this.getHeight() - this.mOffsetBottom, this.mBorderPaint);
                    break;
                }
                case RIGHT: {
                    this.mDrawCanvas.drawLine((float)this.getWidth() - this.mOffsetRight, this.mOffsetTop, (float)this.getWidth() - this.mOffsetRight, (float)this.getHeight() - this.mOffsetBottom, this.mBorderPaint);
                    break;
                }
                case TOP: {
                    this.mDrawCanvas.drawLine(this.mOffsetLeft, this.mOffsetTop, (float)this.getWidth() - this.mOffsetRight, this.mOffsetTop, this.mBorderPaint);
                    break;
                }
                case BOTTOM: {
                    this.mDrawCanvas.drawLine(this.mOffsetLeft, (float)this.getHeight() - this.mOffsetBottom, (float)this.getWidth() - this.mOffsetRight, (float)this.getHeight() - this.mOffsetBottom, this.mBorderPaint);
                }
            }
            ++i;
        }
    }

    protected void drawGridBackground() {
        if (!this.mDrawGridBackground) {
            return;
        }
        Rect gridBackground = new Rect((int)this.mOffsetLeft + 1, (int)this.mOffsetTop + 1, this.getWidth() - (int)this.mOffsetRight, this.getHeight() - (int)this.mOffsetBottom);
        this.mDrawCanvas.drawRect(gridBackground, this.mGridBackgroundPaint);
    }

    protected void drawHorizontalGrid() {
        if (!this.mDrawHorizontalGrid) {
            return;
        }
        Path p = new Path();
        int i = 0;
        while (i < this.mYLabels.mEntryCount) {
            p.reset();
            p.moveTo(0.0f, this.mYLabels.mEntries[i]);
            p.lineTo(this.mDeltaX, this.mYLabels.mEntries[i]);
            this.transformPath(p);
            this.mDrawCanvas.drawPath(p, this.mGridPaint);
            ++i;
        }
    }

    protected void drawVerticalGrid() {
        if (!this.mDrawVerticalGrid || this.mCurrentData == null) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        int i = 0;
        while (i < this.mCurrentData.getXValCount()) {
            position[0] = i;
            this.transformPointArray(position);
            if (position[0] >= this.mOffsetLeft && position[0] <= (float)this.getWidth()) {
                this.mDrawCanvas.drawLine(position[0], this.mOffsetTop, position[0], (float)this.getHeight() - this.mOffsetBottom, this.mGridPaint);
            }
            i += this.mXLabels.mXAxisLabelModulus;
        }
    }

    private void drawLimitLines() {
        ArrayList<LimitLine> limitLines = ((BarLineScatterCandleData)this.mOriginalData).getLimitLines();
        if (limitLines == null) {
            return;
        }
        float[] pts = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int i = 0;
        while (i < limitLines.size()) {
            LimitLine l = limitLines.get(i);
            pts[0] = 0.0f;
            pts[1] = l.getLimit();
            pts[2] = this.mDeltaX;
            pts[3] = l.getLimit();
            this.transformPointArray(pts);
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            this.mDrawCanvas.drawLine(pts[0], pts[1], pts[2], pts[3], this.mLimitLinePaint);
            ++i;
        }
    }

    protected boolean isOffContentRight(float p) {
        return p > (float)this.mContentRect.right;
    }

    protected boolean isOffContentLeft(float p) {
        return p < (float)this.mContentRect.left;
    }

    protected boolean isOffContentTop(float p) {
        return p < (float)this.mContentRect.top;
    }

    protected boolean isOffContentBottom(float p) {
        return p > (float)this.mContentRect.bottom;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mListener == null || this.mDataNotSet) {
            return false;
        }
        if (!this.mTouchEnabled) {
            return false;
        }
        return this.mListener.onTouch((View)this, event);
    }

    public void disableScroll() {
        ViewParent parent = this.getParent();
        parent.requestDisallowInterceptTouchEvent(true);
    }

    public void enableScroll() {
        ViewParent parent = this.getParent();
        parent.requestDisallowInterceptTouchEvent(false);
    }

    public void zoomIn(float x, float y) {
        Matrix save = new Matrix();
        save.set(this.mMatrixTouch);
        save.postScale(1.4f, 1.4f, x, y);
        this.refreshTouch(save);
    }

    public void zoomOut(float x, float y) {
        Matrix save = new Matrix();
        save.set(this.mMatrixTouch);
        save.postScale(0.7f, 0.7f, x, y);
        this.refreshTouch(save);
    }

    public void zoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = new Matrix();
        save.set(this.mMatrixTouch);
        save.postScale(scaleX, scaleY, x, -y);
        this.refreshTouch(save);
    }

    public void setInvertYAxisEnabled(boolean enabled) {
        this.mInvertYAxis = enabled;
    }

    public boolean isInvertYAxisEnabled() {
        return this.mInvertYAxis;
    }

    public synchronized void centerViewPort(final int xIndex, final float yVal) {
        this.post(new Runnable(){

            @Override
            public void run() {
                float indicesInView = BarLineChartBase.this.mDeltaX / BarLineChartBase.this.mScaleX;
                float valsInView = BarLineChartBase.this.mDeltaY / BarLineChartBase.this.mScaleY;
                float[] pts = new float[]{(float)xIndex - indicesInView / 2.0f, yVal + valsInView / 2.0f};
                Matrix save = new Matrix();
                save.set(BarLineChartBase.this.mMatrixTouch);
                BarLineChartBase.this.transformPointArray(pts);
                float x = -pts[0] + BarLineChartBase.this.getOffsetLeft();
                float y = -pts[1] - BarLineChartBase.this.getOffsetTop();
                save.postTranslate(x, y);
                BarLineChartBase.this.refreshTouch(save);
            }
        });
    }

    public Matrix refreshTouch(Matrix newTouchMatrix) {
        this.mMatrixTouch.set(newTouchMatrix);
        this.limitTransAndScale(this.mMatrixTouch);
        this.invalidate();
        newTouchMatrix.set(this.mMatrixTouch);
        return newTouchMatrix;
    }

    public Matrix refreshTouchNoInvalidate(Matrix newTouchMatrix) {
        this.mMatrixTouch.set(newTouchMatrix);
        this.limitTransAndScale(this.mMatrixTouch);
        newTouchMatrix.set(this.mMatrixTouch);
        return newTouchMatrix;
    }

    protected void limitTransAndScale(Matrix matrix) {
        float[] vals = new float[9];
        matrix.getValues(vals);
        float curTransX = vals[2];
        float curScaleX = vals[0];
        float curTransY = vals[5];
        float curScaleY = vals[4];
        this.mScaleX = Math.max(this.mMinScaleX, Math.min(this.getMaxScaleX(), curScaleX));
        this.mScaleY = Math.max(this.mMinScaleY, Math.min(this.getMaxScaleY(), curScaleY));
        if (this.mContentRect == null) {
            return;
        }
        float maxTransX = -((float)this.mContentRect.width()) * (this.mScaleX - 1.0f);
        float newTransX = Math.min(Math.max(curTransX, maxTransX), 0.0f);
        float maxTransY = (float)this.mContentRect.height() * (this.mScaleY - 1.0f);
        float newTransY = Math.max(Math.min(curTransY, maxTransY), 0.0f);
        vals[2] = newTransX;
        vals[0] = this.mScaleX;
        vals[5] = newTransY;
        vals[4] = this.mScaleY;
        matrix.setValues(vals);
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mListener = l;
    }

    public void setOnDrawListener(OnDrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    public void setDrawingEnabled(boolean drawingEnabled) {
        if (this.mListener instanceof BarLineChartTouchListener) {
            ((BarLineChartTouchListener)this.mListener).setDrawingEnabled(drawingEnabled);
        }
    }

    public void setAutoFinish(boolean enabled) {
        this.mAutoFinishDrawing = enabled;
    }

    public boolean isAutoFinishEnabled() {
        return this.mAutoFinishDrawing;
    }

    public OnDrawListener getDrawListener() {
        return this.mDrawListener;
    }

    public void setScaleMinima(float scaleXmin, float scaleYmin) {
        this.mMinScaleX = scaleXmin;
        this.mMinScaleY = scaleYmin;
        this.zoom(this.mMinScaleX, this.mMinScaleY, 0.0f, 0.0f);
    }

    public void setYRange(float minY, float maxY, boolean invalidate) {
        if (Float.isNaN(minY) || Float.isNaN(maxY)) {
            this.resetYRange(invalidate);
            return;
        }
        this.mFixedYValues = true;
        this.mYChartMin = minY;
        this.mYChartMax = maxY;
        if (minY < 0.0f) {
            this.mStartAtZero = false;
        }
        this.mDeltaY = this.mYChartMax - this.mYChartMin;
        this.calcFormats();
        this.prepareMatrix();
        if (invalidate) {
            this.invalidate();
        }
    }

    public void resetYRange(boolean invalidate) {
        this.mFixedYValues = false;
        this.calcMinMax(this.mFixedYValues);
        this.prepareMatrix();
        if (invalidate) {
            this.invalidate();
        }
    }

    public boolean hasFixedYValues() {
        return this.mFixedYValues;
    }

    public void setGridColor(int color) {
        this.mGridPaint.setColor(color);
    }

    public void setMaxVisibleValueCount(int count) {
        this.mMaxVisibleCount = count;
    }

    public void setHighlightIndicatorEnabled(boolean enabled) {
        this.mHighLightIndicatorEnabled = enabled;
    }

    public void setStartAtZero(boolean enabled) {
        this.mStartAtZero = enabled;
        this.prepare();
        this.prepareMatrix();
        this.calculateOffsets();
    }

    public boolean isStartAtZeroEnabled() {
        return this.mStartAtZero;
    }

    public void setGridWidth(float width) {
        if (width < 0.1f) {
            width = 0.1f;
        }
        if (width > 3.0f) {
            width = 3.0f;
        }
        this.mGridWidth = width;
    }

    public void setDragScaleEnabled(boolean enabled) {
        this.mDragScaleEnabled = enabled;
    }

    public boolean isDragScaleEnabled() {
        return this.mDragScaleEnabled;
    }

    public void setDrawVerticalGrid(boolean enabled) {
        this.mDrawVerticalGrid = enabled;
    }

    public void setDrawHorizontalGrid(boolean enabled) {
        this.mDrawHorizontalGrid = enabled;
    }

    public boolean isDrawVerticalGridEnabled() {
        return this.mDrawVerticalGrid;
    }

    public boolean isDrawHorizontalGridEnabled() {
        return this.mDrawHorizontalGrid;
    }

    public void setDrawBorder(boolean enabled) {
        this.mDrawBorder = enabled;
    }

    public void setDrawGridBackground(boolean enabled) {
        this.mDrawGridBackground = enabled;
    }

    public void setDrawXLabels(boolean enabled) {
        this.mDrawXLabels = enabled;
    }

    public void setDrawYLabels(boolean enabled) {
        this.mDrawYLabels = enabled;
    }

    public void setBorderPositions(BorderPosition[] styles) {
        this.mBorderPositions = styles;
    }

    public BorderPosition[] getBorderPositions() {
        return this.mBorderPositions;
    }

    public Highlight getHighlightByTouchPoint(float x, float y) {
        ArrayList<SelInfo> valsAtIndex;
        if (this.mDataNotSet) {
            Log.e((String)"MPChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        float[] pts = new float[]{x, y};
        Matrix tmp = new Matrix();
        this.mMatrixOffset.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixTouch.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixValueToPx.invert(tmp);
        tmp.mapPoints(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        double base = Math.floor(xTouchVal);
        double touchOffset = (double)this.mDeltaX * 0.025;
        if (xTouchVal < -touchOffset || xTouchVal > (double)this.mDeltaX + touchOffset) {
            return null;
        }
        if (this instanceof CandleStickChart) {
            base -= 0.5;
        }
        if (base < 0.0) {
            base = 0.0;
        }
        if (base >= (double)this.mDeltaX) {
            base = this.mDeltaX - 1.0f;
        }
        int xIndex = (int)base;
        int dataSetIndex = 0;
        if (xTouchVal - base > 0.5) {
            xIndex = (int)base + 1;
        }
        if ((dataSetIndex = this.getClosestDataSetIndex(valsAtIndex = this.getYValsAtIndex(xIndex), (float)yTouchVal)) == -1) {
            return null;
        }
        return new Highlight(xIndex, dataSetIndex);
    }

    private int getClosestDataSetIndex(ArrayList<SelInfo> valsAtIndex, float val) {
        int index = -1;
        float distance = Float.MAX_VALUE;
        int i = 0;
        while (i < valsAtIndex.size()) {
            float cdistance = Math.abs(valsAtIndex.get((int)i).val - val);
            if (cdistance < distance) {
                index = valsAtIndex.get((int)i).dataSetIndex;
                distance = cdistance;
            }
            ++i;
        }
        return index;
    }

    public PointD getValuesByTouchPoint(float x, float y) {
        float[] pts = new float[]{x, y};
        Matrix tmp = new Matrix();
        this.mMatrixOffset.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixTouch.invert(tmp);
        tmp.mapPoints(pts);
        this.mMatrixValueToPx.invert(tmp);
        tmp.mapPoints(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        return new PointD(xTouchVal, yTouchVal);
    }

    public PointD getPixelsForValues(float x, float y) {
        float[] pts = new float[]{x, y};
        this.transformPointArray(pts);
        return new PointD(pts[0], pts[1]);
    }

    public float getYValueByTouchPoint(float x, float y) {
        return (float)this.getValuesByTouchPoint((float)x, (float)y).y;
    }

    public Entry getEntryByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return this.mCurrentData.getEntryForHighlight(h);
        }
        return null;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public boolean isFullyZoomedOut() {
        return this.mScaleX <= this.mMinScaleX && this.mScaleY <= this.mMinScaleY;
    }

    public float getMaxScaleX() {
        return this.mDeltaX / 2.0f;
    }

    public float getMaxScaleY() {
        return this.mMaxScaleY;
    }

    public void setMaxScaleY(float factor) {
        if (factor < 1.0f) {
            factor = 1.0f;
        }
        if (factor > 20.0f) {
            factor = 20.0f;
        }
        this.mMaxScaleY = factor;
    }

    public YLabels getYLabels() {
        return this.mYLabels;
    }

    public XLabels getXLabels() {
        return this.mXLabels;
    }

    public void enableFiltering(Approximator a) {
        this.mFilterData = true;
        this.mApproximator = a;
    }

    public void disableFiltering() {
        this.mFilterData = false;
    }

    public boolean isFilteringEnabled() {
        return this.mFilterData;
    }

    public void setPinchZoom(boolean enabled) {
        this.mPinchZoomEnabled = enabled;
    }

    public boolean isPinchZoomEnabled() {
        return this.mPinchZoomEnabled;
    }

    private ChartData getFilteredData() {
        return null;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 3: {
                this.mGridPaint = p;
                break;
            }
            case 4: {
                this.mGridBackgroundPaint = p;
                break;
            }
            case 12: {
                this.mBorderPaint = p;
                break;
            }
            case 6: {
                this.mXLabelPaint = p;
                break;
            }
            case 5: {
                this.mYLabelPaint = p;
                break;
            }
            case 19: {
                this.mLimitLinePaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 3: {
                return this.mGridPaint;
            }
            case 4: {
                return this.mGridBackgroundPaint;
            }
            case 12: {
                return this.mBorderPaint;
            }
            case 6: {
                return this.mXLabelPaint;
            }
            case 5: {
                return this.mYLabelPaint;
            }
            case 19: {
                return this.mLimitLinePaint;
            }
        }
        return null;
    }

    public static enum BorderPosition {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

