/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.listener.PieChartTouchListener;
import com.github.mikephil.charting.utils.Legend;
import com.github.mikephil.charting.utils.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class PieChart
extends Chart {
    private RectF mCircleBox = new RectF();
    private float mChartAngle = 0.0f;
    private float[] mDrawAngles;
    private float[] mAbsoluteAngles;
    private boolean mRotateEnabled = true;
    private boolean mDrawHole = true;
    private String mCenterText = null;
    private float mHoleRadiusPercent = 50.0f;
    private float mTransparentCircleRadius = 55.0f;
    private boolean mDrawCenterText = true;
    private boolean mDrawXVals = true;
    private boolean mUsePercentValues = false;
    private Paint mHolePaint;
    private Paint mCenterTextPaint;
    private View.OnTouchListener mListener;
    protected DecimalFormat mFormatValue = null;
    private float mStartAngle = 0.0f;

    public PieChart(Context context) {
        super(context);
    }

    public PieChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mCenterTextPaint = new Paint(1);
        this.mCenterTextPaint.setColor(this.mColorDarkBlue);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mCenterTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mListener = new PieChartTouchListener(this);
        this.mDrawYValues = true;
    }

    public void setData(PieData data) {
        super.setData(data);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.drawHighlights();
        this.drawData();
        this.drawAdditional();
        this.drawValues();
        this.drawLegend();
        this.drawDescription();
        this.drawCenterText();
        canvas.drawBitmap(this.mDrawBitmap, 0.0f, 0.0f, this.mDrawPaint);
        Log.i((String)"MPChart", (String)("PieChart DrawTime: " + (System.currentTimeMillis() - starttime) + " ms"));
    }

    @Override
    public void prepare() {
        if (this.mDataNotSet) {
            return;
        }
        this.calcMinMax(false);
        if (this.mCenterText == null) {
            this.mCenterText = "Total Value\n" + (int)this.getYValueSum();
        }
        this.calcFormats();
        this.prepareLegend();
    }

    @Override
    public void notifyDataSetChanged() {
    }

    @Override
    protected void calculateOffsets() {
        if (this.mLegend == null) {
            return;
        }
        if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART) {
            this.mLegend.setOffsetRight(this.mLegend.getMaximumEntryLength(this.mLegendLabelPaint));
            this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
            this.mLegend.setOffsetBottom(this.mLegendLabelPaint.getTextSize() * 3.5f);
        }
        if (this.mDrawLegend) {
            this.mOffsetBottom = Math.max(this.mOffsetBottom, this.mLegend.getOffsetBottom());
            this.mOffsetRight = Math.max(this.mOffsetRight, this.mLegend.getOffsetRight() / 3.0f * 2.0f);
        }
        this.mLegend.setOffsetTop(this.mOffsetTop);
        this.mLegend.setOffsetLeft(this.mOffsetLeft);
        this.prepareContentRect();
        float scaleX = ((float)this.getWidth() - this.mOffsetLeft - this.mOffsetRight) / this.mDeltaX;
        float scaleY = ((float)this.getHeight() - this.mOffsetBottom - this.mOffsetTop) / this.mDeltaY;
        Matrix val = new Matrix();
        val.postTranslate(0.0f, -this.mYChartMin);
        val.postScale(scaleX, -scaleY);
        this.mMatrixValueToPx.set(val);
        Matrix offset = new Matrix();
        offset.postTranslate(this.mOffsetLeft, (float)this.getHeight() - this.mOffsetBottom);
        this.mMatrixOffset.set(offset);
    }

    protected void calcFormats() {
        this.mValueFormatDigits = this.mValueDigitsToUse == -1 ? (this.mOriginalData.getXValCount() <= 1 ? 0 : Utils.getPieFormatDigits(this.mDeltaY)) : this.mValueDigitsToUse;
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.mValueFormatDigits) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
            ++i;
        }
        this.mFormatValue = new DecimalFormat("###,###,###,##0" + b.toString());
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mTouchEnabled && this.mListener != null) {
            return this.mListener.onTouch((View)this, event);
        }
        return super.onTouchEvent(event);
    }

    public void setStartAngle(float x, float y) {
        this.mStartAngle = this.getAngleForPoint(x, y);
        this.mStartAngle -= this.mChartAngle;
    }

    public void updateRotation(float x, float y) {
        this.mChartAngle = this.getAngleForPoint(x, y);
        this.mChartAngle -= this.mStartAngle;
        this.mChartAngle = (this.mChartAngle + 360.0f) % 360.0f;
    }

    @Override
    protected void prepareContentRect() {
        super.prepareContentRect();
        if (this.mDataNotSet) {
            return;
        }
        float width = (float)this.mContentRect.width() + this.mOffsetLeft + this.mOffsetRight;
        float height = (float)this.mContentRect.height() + this.mOffsetTop + this.mOffsetBottom;
        float diameter = this.getDiameter();
        float shift = ((PieData)this.mCurrentData).getDataSet().getSelectionShift();
        this.mCircleBox.set(width / 2.0f - diameter / 2.0f + shift, height / 2.0f - diameter / 2.0f + shift, width / 2.0f + diameter / 2.0f - shift, height / 2.0f + diameter / 2.0f - shift);
    }

    @Override
    protected void calcMinMax(boolean fixedValues) {
        super.calcMinMax(fixedValues);
        this.calcAngles();
    }

    private void calcAngles() {
        this.mDrawAngles = new float[this.mCurrentData.getYValCount()];
        this.mAbsoluteAngles = new float[this.mCurrentData.getYValCount()];
        ArrayList<? extends DataSet> dataSets = this.mCurrentData.getDataSets();
        int cnt = 0;
        int i = 0;
        while (i < this.mCurrentData.getDataSetCount()) {
            DataSet set = dataSets.get(i);
            ArrayList<? extends Entry> entries = set.getYVals();
            int j = 0;
            while (j < entries.size()) {
                this.mDrawAngles[cnt] = this.calcAngle(entries.get(j).getVal());
                this.mAbsoluteAngles[cnt] = cnt == 0 ? this.mDrawAngles[cnt] : this.mAbsoluteAngles[cnt - 1] + this.mDrawAngles[cnt];
                ++cnt;
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void drawHighlights() {
        if (this.mHighlightEnabled && this.valuesToHighlight()) {
            float angle = 0.0f;
            int i = 0;
            while (i < this.mIndicesToHightlight.length) {
                int xIndex = this.mIndicesToHightlight[i].getXIndex();
                if (xIndex < this.mDrawAngles.length && !((float)xIndex > this.mDeltaX * this.mPhaseX)) {
                    angle = xIndex == 0 ? this.mChartAngle : this.mChartAngle + this.mAbsoluteAngles[xIndex - 1];
                    float sliceDegrees = this.mDrawAngles[xIndex];
                    float shiftangle = (float)Math.toRadians((angle *= this.mPhaseY) + sliceDegrees / 2.0f);
                    PieDataSet set = (PieDataSet)this.mCurrentData.getDataSetByIndex(this.mIndicesToHightlight[i].getDataSetIndex());
                    float shift = set.getSelectionShift();
                    float xShift = shift * (float)Math.cos(shiftangle);
                    float yShift = shift * (float)Math.sin(shiftangle);
                    RectF highlighted = new RectF(this.mCircleBox.left + xShift, this.mCircleBox.top + yShift, this.mCircleBox.right + xShift, this.mCircleBox.bottom + yShift);
                    this.mRenderPaint.setColor(set.getColor(xIndex));
                    this.mDrawCanvas.drawArc(highlighted, angle + set.getSliceSpace() / 2.0f, sliceDegrees - set.getSliceSpace() / 2.0f, true, this.mRenderPaint);
                }
                ++i;
            }
        }
    }

    @Override
    protected void drawData() {
        float angle = this.mChartAngle;
        ArrayList<? extends DataSet> dataSets = this.mCurrentData.getDataSets();
        int cnt = 0;
        int i = 0;
        while (i < this.mCurrentData.getDataSetCount()) {
            PieDataSet dataSet = (PieDataSet)dataSets.get(i);
            ArrayList<? extends Entry> entries = dataSet.getYVals();
            int j = 0;
            while (j < entries.size()) {
                float newangle = this.mDrawAngles[cnt];
                float sliceSpace = dataSet.getSliceSpace();
                if (!this.needsHighlight(entries.get(j).getXIndex(), i)) {
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    this.mDrawCanvas.drawArc(this.mCircleBox, angle + sliceSpace / 2.0f, newangle * this.mPhaseY - sliceSpace / 2.0f, true, this.mRenderPaint);
                }
                angle += newangle * this.mPhaseX;
                ++cnt;
                ++j;
            }
            ++i;
        }
    }

    private void drawHole() {
        if (this.mDrawHole) {
            float radius = this.getRadius();
            PointF c = this.getCenterCircleBox();
            int color = this.mHolePaint.getColor();
            this.mDrawCanvas.drawCircle(c.x, c.y, radius / 100.0f * this.mHoleRadiusPercent, this.mHolePaint);
            this.mHolePaint.setColor(color & 0x60FFFFFF);
            this.mDrawCanvas.drawCircle(c.x, c.y, radius / 100.0f * this.mTransparentCircleRadius, this.mHolePaint);
            this.mHolePaint.setColor(color);
        }
    }

    private void drawCenterText() {
        if (this.mDrawCenterText) {
            PointF c = this.getCenterCircleBox();
            String[] lines = this.mCenterText.split("\n");
            float lineHeight = Utils.calcTextHeight(this.mCenterTextPaint, lines[0]);
            float linespacing = lineHeight * 0.2f;
            float totalheight = lineHeight * (float)lines.length - linespacing * (float)(lines.length - 1);
            int cnt = lines.length;
            float y = c.y;
            int i = 0;
            while (i < lines.length) {
                String line = lines[lines.length - i - 1];
                this.mDrawCanvas.drawText(line, c.x, y + lineHeight * (float)cnt - totalheight / 2.0f, this.mCenterTextPaint);
                --cnt;
                y -= linespacing;
                ++i;
            }
        }
    }

    @Override
    protected void drawValues() {
        if (!this.mDrawXVals && !this.mDrawYValues) {
            return;
        }
        PointF center = this.getCenterCircleBox();
        float r = this.getRadius();
        float off = r / 2.0f;
        if (this.mDrawHole) {
            off = (r - r / 100.0f * this.mHoleRadiusPercent) / 2.0f;
        }
        r -= off;
        ArrayList<? extends DataSet> dataSets = this.mCurrentData.getDataSets();
        int cnt = 0;
        int i = 0;
        while (i < this.mCurrentData.getDataSetCount()) {
            DataSet dataSet = dataSets.get(i);
            ArrayList<? extends Entry> entries = dataSet.getYVals();
            int j = 0;
            while ((float)j < (float)entries.size() * this.mPhaseX) {
                float offset = this.mDrawAngles[cnt] / 2.0f;
                float x = (float)((double)r * Math.cos(Math.toRadians((this.mChartAngle + this.mAbsoluteAngles[cnt] - offset) * this.mPhaseY)) + (double)center.x);
                float y = (float)((double)r * Math.sin(Math.toRadians((this.mChartAngle + this.mAbsoluteAngles[cnt] - offset) * this.mPhaseY)) + (double)center.y);
                String val = "";
                float value = entries.get(j).getVal();
                val = this.mUsePercentValues ? String.valueOf(this.mFormatValue.format(this.getPercentOfTotal(value))) + " %" : this.mFormatValue.format(value);
                if (this.mDrawUnitInChart) {
                    val = String.valueOf(val) + this.mUnit;
                }
                if (this.mDrawXVals && this.mDrawYValues) {
                    float lineHeight = (this.mValuePaint.ascent() + this.mValuePaint.descent()) * 1.6f;
                    this.mDrawCanvas.drawText(val, x, y -= lineHeight / 2.0f, this.mValuePaint);
                    this.mDrawCanvas.drawText(this.mCurrentData.getXVals().get(j), x, y + lineHeight, this.mValuePaint);
                } else if (this.mDrawXVals && !this.mDrawYValues) {
                    this.mDrawCanvas.drawText(this.mCurrentData.getXVals().get(j), x, y, this.mValuePaint);
                } else if (!this.mDrawXVals && this.mDrawYValues) {
                    this.mDrawCanvas.drawText(val, x, y, this.mValuePaint);
                }
                ++cnt;
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void drawAdditional() {
        this.drawHole();
    }

    private float calcAngle(float value) {
        return value / this.mCurrentData.getYValueSum() * 360.0f;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mListener = l;
    }

    public int getIndexForAngle(float angle) {
        float a = (angle - this.mChartAngle + 360.0f) % 360.0f;
        int i = 0;
        while (i < this.mAbsoluteAngles.length) {
            if (this.mAbsoluteAngles[i] > a) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getDataSetIndexForIndex(int xIndex) {
        ArrayList<? extends DataSet> dataSets = this.mCurrentData.getDataSets();
        int i = 0;
        while (i < dataSets.size()) {
            if (dataSets.get(i).getEntryForXIndex(xIndex) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public float[] getDrawAngles() {
        return this.mDrawAngles;
    }

    public float[] getAbsoluteAngles() {
        return this.mAbsoluteAngles;
    }

    public void setStartAngle(float angle) {
        this.mChartAngle = angle;
    }

    public float getCurrentRotation() {
        return this.mChartAngle;
    }

    public void setDrawHoleEnabled(boolean enabled) {
        this.mDrawHole = enabled;
    }

    public void setRotationEnabled(boolean enabled) {
        this.mRotateEnabled = enabled;
    }

    public boolean isRotationEnabled() {
        return this.mRotateEnabled;
    }

    public boolean isDrawHoleEnabled() {
        return this.mDrawHole;
    }

    public void setCenterText(String text) {
        this.mCenterText = text;
    }

    public String getCenterText() {
        return this.mCenterText;
    }

    public void setDrawCenterText(boolean enabled) {
        this.mDrawCenterText = enabled;
    }

    public boolean isDrawCenterTextEnabled() {
        return this.mDrawCenterText;
    }

    public void setUsePercentValues(boolean enabled) {
        this.mUsePercentValues = enabled;
    }

    public boolean isUsePercentValuesEnabled() {
        return this.mUsePercentValues;
    }

    public void setDrawXValues(boolean enabled) {
        this.mDrawXVals = enabled;
    }

    public boolean isDrawXValuesEnabled() {
        return this.mDrawXVals;
    }

    public float getRadius() {
        if (this.mCircleBox == null) {
            return 0.0f;
        }
        return Math.min(this.mCircleBox.width() / 2.0f, this.mCircleBox.height() / 2.0f);
    }

    public float getDiameter() {
        if (this.mContentRect == null) {
            return 0.0f;
        }
        return Math.min(this.mContentRect.width(), this.mContentRect.height());
    }

    public RectF getCircleBox() {
        return this.mCircleBox;
    }

    public PointF getCenterCircleBox() {
        return new PointF(this.mCircleBox.centerX(), this.mCircleBox.centerY());
    }

    public float getAngleForPoint(float x, float y) {
        PointF c = this.getCenterCircleBox();
        double tx = x - c.x;
        double ty = y - c.y;
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > c.x) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public float distanceToCenter(float x, float y) {
        PointF c = this.getCenterCircleBox();
        float dist = 0.0f;
        float xDist = 0.0f;
        float yDist = 0.0f;
        xDist = x > c.x ? x - c.x : c.x - x;
        yDist = y > c.y ? y - c.y : c.y - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        return dist;
    }

    public void setCenterTextTypeface(Typeface t) {
        this.mCenterTextPaint.setTypeface(t);
    }

    public void setCenterTextSize(float size) {
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setHoleRadius(float percent) {
        this.mHoleRadiusPercent = percent;
    }

    public void setTransparentCircleRadius(float percent) {
        this.mTransparentCircleRadius = percent;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 13: {
                this.mHolePaint = p;
                break;
            }
            case 14: {
                this.mCenterTextPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 13: {
                return this.mHolePaint;
            }
            case 14: {
                return this.mCenterTextPaint;
            }
        }
        return null;
    }
}

