/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.ColorTemplate;
import java.util.ArrayList;

public abstract class DataSet {
    protected ArrayList<Integer> mColors = null;
    protected ArrayList<? extends Entry> mYVals = null;
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    private float mYValueSum = 0.0f;
    private String mLabel = "DataSet";

    public DataSet(ArrayList<? extends Entry> yVals, String label) {
        this.mLabel = label;
        this.mYVals = yVals;
        this.mColors = new ArrayList();
        this.mColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.calcMinMax();
        this.calcYValueSum();
    }

    public void notifyDataSetChanged() {
        this.calcMinMax();
        this.calcYValueSum();
    }

    protected void calcMinMax() {
        if (this.mYVals.size() == 0) {
            return;
        }
        this.mYMin = this.mYVals.get(0).getVal();
        this.mYMax = this.mYVals.get(0).getVal();
        int i = 0;
        while (i < this.mYVals.size()) {
            Entry e = this.mYVals.get(i);
            if (e.getVal() < this.mYMin) {
                this.mYMin = e.getVal();
            }
            if (e.getVal() > this.mYMax) {
                this.mYMax = e.getVal();
            }
            ++i;
        }
    }

    private void calcYValueSum() {
        this.mYValueSum = 0.0f;
        int i = 0;
        while (i < this.mYVals.size()) {
            this.mYValueSum += Math.abs(this.mYVals.get(i).getVal());
            ++i;
        }
    }

    public int getEntryCount() {
        return this.mYVals.size();
    }

    public float getYValForXIndex(int xIndex) {
        Entry e = this.getEntryForXIndex(xIndex);
        if (e != null) {
            return e.getVal();
        }
        return Float.NaN;
    }

    public Entry getEntryForXIndex(int x) {
        int low = 0;
        int high = this.mYVals.size() - 1;
        while (low <= high) {
            int m = (high + low) / 2;
            if (x == this.mYVals.get(m).getXIndex()) {
                return this.mYVals.get(m);
            }
            if (x > this.mYVals.get(m).getXIndex()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return null;
    }

    public ArrayList<Entry> getEntriesForXIndex(int x) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int low = 0;
        int high = this.mYVals.size();
        while (low <= high) {
            int m = (high + low) / 2;
            if (x == this.mYVals.get(m).getXIndex()) {
                entries.add(this.mYVals.get(m));
            }
            if (x > this.mYVals.get(m).getXIndex()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return entries;
    }

    public ArrayList<? extends Entry> getYVals() {
        return this.mYVals;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public int getIndexInEntries(int xIndex) {
        int i = 0;
        while (i < this.mYVals.size()) {
            if (xIndex == this.mYVals.get(i).getXIndex()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public abstract DataSet copy();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toSimpleString());
        int i = 0;
        while (i < this.mYVals.size()) {
            buffer.append(String.valueOf(this.mYVals.get(i).toString()) + " ");
            ++i;
        }
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSet, label: " + this.mLabel + ", entries: " + this.mYVals.size() + "\n");
        return buffer.toString();
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setColors(ArrayList<Integer> colors) {
        this.mColors = colors;
    }

    public void setColors(int[] colors) {
        this.mColors = ColorTemplate.createColors(colors);
    }

    public void setColors(int[] colors, Context c) {
        ArrayList<Integer> clrs = new ArrayList<Integer>();
        int[] nArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            int color2 = nArray[n2];
            clrs.add(c.getResources().getColor(color2));
            ++n2;
        }
        this.mColors = clrs;
    }

    public void addColor(int color2) {
        if (this.mColors == null) {
            this.mColors = new ArrayList();
        }
        this.mColors.add(color2);
    }

    public void setColor(int color2) {
        this.resetColors();
        this.mColors.add(color2);
    }

    public ArrayList<Integer> getColors() {
        return this.mColors;
    }

    public int getColor(int index) {
        return this.mColors.get(index % this.mColors.size());
    }

    public void resetColors() {
        this.mColors = new ArrayList();
    }
}

