/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private static final int MAX_PACKETS = 65536;
    private PacketFilter packetFilter;
    private LinkedBlockingQueue<Packet> resultQueue;
    private Connection conection;
    private boolean cancelled = false;

    protected PacketCollector(Connection connection, PacketFilter packetFilter) {
        this.conection = connection;
        this.packetFilter = packetFilter;
        this.resultQueue = new LinkedBlockingQueue(65536);
    }

    public void cancel() {
        if (!this.cancelled) {
            this.conection.removePacketCollector(this);
            this.cancelled = true;
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public Packet pollResult() {
        return this.resultQueue.poll();
    }

    public Packet nextResult() {
        while (true) {
            try {
                return this.resultQueue.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public Packet nextResult(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (true) {
            try {
                return this.resultQueue.poll(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                if (System.currentTimeMillis() < l2) continue;
                return null;
            }
            break;
        }
    }

    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
        }
    }
}

