/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.CloseListener;
import org.jivesoftware.smackx.bytestreams.ibb.DataListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InitiationListener;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.packet.SyncPacketSend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InBandBytestreamManager
implements BytestreamManager {
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final int MAXIMUM_BLOCK_SIZE = 65535;
    private static final String SESSION_ID_PREFIX = "jibb_";
    private static final Random randomGenerator;
    private static final Map<Connection, InBandBytestreamManager> managers;
    private final Connection connection;
    private final Map<String, BytestreamListener> userListeners = new ConcurrentHashMap<String, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private final DataListener dataListener;
    private final CloseListener closeListener;
    private final Map<String, InBandBytestreamSession> sessions = new ConcurrentHashMap<String, InBandBytestreamSession>();
    private int defaultBlockSize = 4096;
    private int maximumBlockSize = 65535;
    private StanzaType stanza = StanzaType.IQ;
    private List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized InBandBytestreamManager getByteStreamManager(Connection connection) {
        if (connection == null) {
            return null;
        }
        InBandBytestreamManager inBandBytestreamManager = managers.get(connection);
        if (inBandBytestreamManager == null) {
            inBandBytestreamManager = new InBandBytestreamManager(connection);
            managers.put(connection, inBandBytestreamManager);
        }
        return inBandBytestreamManager;
    }

    private InBandBytestreamManager(Connection connection) {
        this.connection = connection;
        this.initiationListener = new InitiationListener(this);
        this.connection.addPacketListener(this.initiationListener, this.initiationListener.getFilter());
        this.dataListener = new DataListener(this);
        this.connection.addPacketListener(this.dataListener, this.dataListener.getFilter());
        this.closeListener = new CloseListener(this);
        this.connection.addPacketListener(this.closeListener, this.closeListener.getFilter());
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.add(bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.remove(bytestreamListener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener, String string) {
        this.userListeners.put(string, bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(String string) {
        this.userListeners.remove(string);
    }

    public void ignoreBytestreamRequestOnce(String string) {
        this.ignoredBytestreamRequests.add(string);
    }

    public int getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public void setDefaultBlockSize(int n) {
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Default block size must be between 1 and 65535");
        }
        this.defaultBlockSize = n;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public void setMaximumBlockSize(int n) {
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Maximum block size must be between 1 and 65535");
        }
        this.maximumBlockSize = n;
    }

    public StanzaType getStanza() {
        return this.stanza;
    }

    public void setStanza(StanzaType stanzaType) {
        this.stanza = stanzaType;
    }

    @Override
    public InBandBytestreamSession establishSession(String string) throws XMPPException {
        String string2 = this.getNextSessionID();
        return this.establishSession(string, string2);
    }

    @Override
    public InBandBytestreamSession establishSession(String string, String string2) throws XMPPException {
        Open open = new Open(string2, this.defaultBlockSize, this.stanza);
        open.setTo(string);
        SyncPacketSend.getReply(this.connection, open);
        InBandBytestreamSession inBandBytestreamSession = new InBandBytestreamSession(this.connection, open, string);
        this.sessions.put(string2, inBandBytestreamSession);
        return inBandBytestreamSession;
    }

    protected void replyRejectPacket(IQ iQ) {
        XMPPError xMPPError = new XMPPError(XMPPError.Condition.no_acceptable);
        IQ iQ2 = IQ.createErrorResponse(iQ, xMPPError);
        this.connection.sendPacket(iQ2);
    }

    protected void replyResourceConstraintPacket(IQ iQ) {
        XMPPError xMPPError = new XMPPError(XMPPError.Condition.resource_constraint);
        IQ iQ2 = IQ.createErrorResponse(iQ, xMPPError);
        this.connection.sendPacket(iQ2);
    }

    protected void replyItemNotFoundPacket(IQ iQ) {
        XMPPError xMPPError = new XMPPError(XMPPError.Condition.item_not_found);
        IQ iQ2 = IQ.createErrorResponse(iQ, xMPPError);
        this.connection.sendPacket(iQ2);
    }

    private String getNextSessionID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SESSION_ID_PREFIX);
        stringBuilder.append(Math.abs(randomGenerator.nextLong()));
        return stringBuilder.toString();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected BytestreamListener getUserListener(String string) {
        return this.userListeners.get(string);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected Map<String, InBandBytestreamSession> getSessions() {
        return this.sessions;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    private void disableService() {
        managers.remove(this.connection);
        this.connection.removePacketListener(this.initiationListener);
        this.connection.removePacketListener(this.dataListener);
        this.connection.removePacketListener(this.closeListener);
        this.initiationListener.shutdown();
        this.userListeners.clear();
        this.allRequestListeners.clear();
        this.sessions.clear();
        this.ignoredBytestreamRequests.clear();
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                final InBandBytestreamManager inBandBytestreamManager = InBandBytestreamManager.getByteStreamManager(connection);
                connection.addConnectionListener(new AbstractConnectionListener(){

                    public void connectionClosed() {
                        inBandBytestreamManager.disableService();
                    }
                });
            }
        });
        randomGenerator = new Random();
        managers = new HashMap<Connection, InBandBytestreamManager>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StanzaType {
        IQ,
        MESSAGE;

    }
}

