/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bytestream
extends IQ {
    private String sessionID;
    private Mode mode = Mode.tcp;
    private final List<StreamHost> streamHosts = new ArrayList<StreamHost>();
    private StreamHostUsed usedHost;
    private Activate toActivate;

    public Bytestream() {
    }

    public Bytestream(String string) {
        this.setSessionID(string);
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public StreamHost addStreamHost(String string, String string2) {
        return this.addStreamHost(string, string2, 0);
    }

    public StreamHost addStreamHost(String string, String string2, int n) {
        StreamHost streamHost = new StreamHost(string, string2);
        streamHost.setPort(n);
        this.addStreamHost(streamHost);
        return streamHost;
    }

    public void addStreamHost(StreamHost streamHost) {
        this.streamHosts.add(streamHost);
    }

    public Collection<StreamHost> getStreamHosts() {
        return Collections.unmodifiableCollection(this.streamHosts);
    }

    public StreamHost getStreamHost(String string) {
        if (string == null) {
            return null;
        }
        for (StreamHost streamHost : this.streamHosts) {
            if (!streamHost.getJID().equals(string)) continue;
            return streamHost;
        }
        return null;
    }

    public int countStreamHosts() {
        return this.streamHosts.size();
    }

    public void setUsedHost(String string) {
        this.usedHost = new StreamHostUsed(string);
    }

    public StreamHostUsed getUsedHost() {
        return this.usedHost;
    }

    public Activate getToActivate() {
        return this.toActivate;
    }

    public void setToActivate(String string) {
        this.toActivate = new Activate(string);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"http://jabber.org/protocol/bytestreams\"");
        if (this.getType().equals(IQ.Type.SET)) {
            if (this.getSessionID() != null) {
                stringBuilder.append(" sid=\"").append(this.getSessionID()).append("\"");
            }
            if (this.getMode() != null) {
                stringBuilder.append(" mode = \"").append((Object)this.getMode()).append("\"");
            }
            stringBuilder.append(">");
            if (this.getToActivate() == null) {
                for (StreamHost streamHost : this.getStreamHosts()) {
                    stringBuilder.append(streamHost.toXML());
                }
            } else {
                stringBuilder.append(this.getToActivate().toXML());
            }
        } else if (this.getType().equals(IQ.Type.RESULT)) {
            stringBuilder.append(">");
            if (this.getUsedHost() != null) {
                stringBuilder.append(this.getUsedHost().toXML());
            } else if (this.countStreamHosts() > 0) {
                for (StreamHost streamHost : this.streamHosts) {
                    stringBuilder.append(streamHost.toXML());
                }
            }
        } else {
            if (this.getType().equals(IQ.Type.GET)) {
                return stringBuilder.append("/>").toString();
            }
            return null;
        }
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        tcp,
        udp;


        public static Mode fromName(String string) {
            Mode mode;
            try {
                mode = Mode.valueOf(string);
            }
            catch (Exception exception) {
                mode = tcp;
            }
            return mode;
        }
    }

    public static class Activate
    implements PacketExtension {
        public String NAMESPACE = "";
        public static String ELEMENTNAME = "activate";
        private final String target;

        public Activate(String string) {
            this.target = string;
        }

        public String getTarget() {
            return this.target;
        }

        public String getNamespace() {
            return this.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<").append(this.getElementName()).append(">");
            stringBuilder.append(this.getTarget());
            stringBuilder.append("</").append(this.getElementName()).append(">");
            return stringBuilder.toString();
        }
    }

    public static class StreamHostUsed
    implements PacketExtension {
        public String NAMESPACE = "";
        public static String ELEMENTNAME = "streamhost-used";
        private final String JID;

        public StreamHostUsed(String string) {
            this.JID = string;
        }

        public String getJID() {
            return this.JID;
        }

        public String getNamespace() {
            return this.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<").append(this.getElementName()).append(" ");
            stringBuilder.append("jid=\"").append(this.getJID()).append("\" ");
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }

    public static class StreamHost
    implements PacketExtension {
        public static String NAMESPACE = "";
        public static String ELEMENTNAME = "streamhost";
        private final String JID;
        private final String addy;
        private int port = 0;

        public StreamHost(String string, String string2) {
            this.JID = string;
            this.addy = string2;
        }

        public String getJID() {
            return this.JID;
        }

        public String getAddress() {
            return this.addy;
        }

        public void setPort(int n) {
            this.port = n;
        }

        public int getPort() {
            return this.port;
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<").append(this.getElementName()).append(" ");
            stringBuilder.append("jid=\"").append(this.getJID()).append("\" ");
            stringBuilder.append("host=\"").append(this.getAddress()).append("\" ");
            if (this.getPort() != 0) {
                stringBuilder.append("port=\"").append(this.getPort()).append("\"");
            } else {
                stringBuilder.append("zeroconf=\"_jabber.bytestreams\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }
}

