/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class IBBTransferNegotiator
extends StreamNegotiator {
    private Connection connection;
    private InBandBytestreamManager manager;

    protected IBBTransferNegotiator(Connection connection) {
        this.connection = connection;
        this.manager = InBandBytestreamManager.getByteStreamManager(connection);
    }

    public OutputStream createOutgoingStream(String string, String string2, String string3) throws XMPPException {
        InBandBytestreamSession inBandBytestreamSession = this.manager.establishSession(string3, string);
        inBandBytestreamSession.setCloseBothStreamsEnabled(true);
        return inBandBytestreamSession.getOutputStream();
    }

    public InputStream createIncomingStream(StreamInitiation streamInitiation) throws XMPPException {
        this.manager.ignoreBytestreamRequestOnce(streamInitiation.getSessionID());
        Packet packet = this.initiateIncomingStream(this.connection, streamInitiation);
        return this.negotiateIncomingStream(packet);
    }

    public PacketFilter getInitiationPacketFilter(String string, String string2) {
        this.manager.ignoreBytestreamRequestOnce(string2);
        return new AndFilter(new FromContainsFilter(string), new IBBOpenSidFilter(string2));
    }

    public String[] getNamespaces() {
        return new String[]{"http://jabber.org/protocol/ibb"};
    }

    InputStream negotiateIncomingStream(Packet packet) throws XMPPException {
        ByteStreamRequest byteStreamRequest = new ByteStreamRequest(this.manager, (Open)packet);
        InBandBytestreamSession inBandBytestreamSession = byteStreamRequest.accept();
        inBandBytestreamSession.setCloseBothStreamsEnabled(true);
        return inBandBytestreamSession.getInputStream();
    }

    public void cleanup() {
    }

    private static class ByteStreamRequest
    extends InBandBytestreamRequest {
        private ByteStreamRequest(InBandBytestreamManager inBandBytestreamManager, Open open) {
            super(inBandBytestreamManager, open);
        }
    }

    private static class IBBOpenSidFilter
    extends PacketTypeFilter {
        private String sessionID;

        public IBBOpenSidFilter(String string) {
            super(Open.class);
            if (string == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = string;
        }

        public boolean accept(Packet packet) {
            if (super.accept(packet)) {
                Open open = (Open)packet;
                return this.sessionID.equals(open.getSessionID()) && IQ.Type.SET.equals(open.getType());
            }
            return false;
        }
    }
}

