/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.DateFormat;
import java.util.Date;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.packet.DelayInformation;

public class DelayInfo
extends DelayInformation {
    DelayInformation wrappedInfo;

    public DelayInfo(DelayInformation delayInformation) {
        super(delayInformation.getStamp());
        this.wrappedInfo = delayInformation;
    }

    public String getFrom() {
        return this.wrappedInfo.getFrom();
    }

    public String getReason() {
        return this.wrappedInfo.getReason();
    }

    public Date getStamp() {
        return this.wrappedInfo.getStamp();
    }

    public void setFrom(String string) {
        this.wrappedInfo.setFrom(string);
    }

    public void setReason(String string) {
        this.wrappedInfo.setReason(string);
    }

    public String getElementName() {
        return "delay";
    }

    public String getNamespace() {
        return "urn:xmpp:delay";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\"");
        stringBuilder.append(" stamp=\"");
        DateFormat dateFormat = Packet.XEP_0082_UTC_FORMAT;
        synchronized (dateFormat) {
            stringBuilder.append(Packet.XEP_0082_UTC_FORMAT.format(this.getStamp()));
        }
        stringBuilder.append("\"");
        if (this.getFrom() != null && this.getFrom().length() > 0) {
            stringBuilder.append(" from=\"").append(this.getFrom()).append("\"");
        }
        stringBuilder.append(">");
        if (this.getReason() != null && this.getReason().length() > 0) {
            stringBuilder.append(this.getReason());
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }
}

