/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;

public class DelayInformation
implements PacketExtension {
    public static final DateFormat XEP_0091_UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private Date stamp;
    private String from;
    private String reason;

    public DelayInformation(Date date) {
        this.stamp = date;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public Date getStamp() {
        return this.stamp;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "jabber:x:delay";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\"");
        stringBuilder.append(" stamp=\"");
        DateFormat dateFormat = XEP_0091_UTC_FORMAT;
        synchronized (dateFormat) {
            stringBuilder.append(XEP_0091_UTC_FORMAT.format(this.stamp));
        }
        stringBuilder.append("\"");
        if (this.from != null && this.from.length() > 0) {
            stringBuilder.append(" from=\"").append(this.from).append("\"");
        }
        stringBuilder.append(">");
        if (this.reason != null && this.reason.length() > 0) {
            stringBuilder.append(this.reason);
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    static {
        XEP_0091_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

