/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.serialization;

import java.util.Hashtable;
import java.util.Vector;
import org.ksoap2.serialization.AttributeContainer;
import org.ksoap2.serialization.AttributeInfo;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.NullSoapObject;
import org.ksoap2.serialization.PropertyInfo;

public class SoapObject
extends AttributeContainer
implements KvmSerializable {
    private static final String EMPTY_STRING = "";
    protected String namespace;
    protected String name;
    protected Vector properties = new Vector();
    static /* synthetic */ Class class$org$ksoap2$serialization$SoapObject;
    static /* synthetic */ Class class$java$lang$String;

    public SoapObject() {
        this(EMPTY_STRING, EMPTY_STRING);
    }

    public SoapObject(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SoapObject)) {
            return false;
        }
        SoapObject otherSoapObject = (SoapObject)obj;
        if (!this.name.equals(otherSoapObject.name) || !this.namespace.equals(otherSoapObject.namespace)) {
            return false;
        }
        int numProperties = this.properties.size();
        if (numProperties != otherSoapObject.properties.size()) {
            return false;
        }
        for (int propIndex = 0; propIndex < numProperties; ++propIndex) {
            Object thisProp = this.properties.elementAt(propIndex);
            if (otherSoapObject.isPropertyEqual(thisProp, propIndex)) continue;
            return false;
        }
        return this.attributesAreEqual(otherSoapObject);
    }

    public boolean isPropertyEqual(Object otherProp, int index) {
        if (index >= this.getPropertyCount()) {
            return false;
        }
        Object thisProp = this.properties.elementAt(index);
        if (otherProp instanceof PropertyInfo && thisProp instanceof PropertyInfo) {
            PropertyInfo otherPropInfo = (PropertyInfo)otherProp;
            PropertyInfo thisPropInfo = (PropertyInfo)thisProp;
            return otherPropInfo.getName().equals(thisPropInfo.getName()) && otherPropInfo.getValue().equals(thisPropInfo.getValue());
        }
        if (otherProp instanceof SoapObject && thisProp instanceof SoapObject) {
            SoapObject otherPropSoap = (SoapObject)otherProp;
            SoapObject thisPropSoap = (SoapObject)thisProp;
            return otherPropSoap.equals(thisPropSoap);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getProperty(int index) {
        Object prop = this.properties.elementAt(index);
        if (prop instanceof PropertyInfo) {
            return ((PropertyInfo)prop).getValue();
        }
        return (SoapObject)prop;
    }

    public String getPropertyAsString(int index) {
        PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
        return propertyInfo.getValue().toString();
    }

    public Object getProperty(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            return this.getProperty(index);
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public String getPropertyAsString(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            return this.getProperty(index).toString();
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public boolean hasProperty(String name) {
        return this.propertyIndex(name) != null;
    }

    public Object getPropertySafely(String name) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            return this.getProperty(i);
        }
        return new NullSoapObject();
    }

    public String getPropertySafelyAsString(String name) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            Object foo = this.getProperty(i);
            if (foo == null) {
                return EMPTY_STRING;
            }
            return foo.toString();
        }
        return EMPTY_STRING;
    }

    public Object getPropertySafely(String name, Object defaultThing) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            return this.getProperty(i);
        }
        return defaultThing;
    }

    public String getPropertySafelyAsString(String name, Object defaultThing) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            Object property = this.getProperty(i);
            if (property != null) {
                return property.toString();
            }
            return EMPTY_STRING;
        }
        if (defaultThing != null) {
            return defaultThing.toString();
        }
        return EMPTY_STRING;
    }

    public Object getPrimitiveProperty(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
            if (propertyInfo.getType() != (class$org$ksoap2$serialization$SoapObject == null ? (class$org$ksoap2$serialization$SoapObject = SoapObject.class$("org.ksoap2.serialization.SoapObject")) : class$org$ksoap2$serialization$SoapObject) && propertyInfo.getValue() != null) {
                return propertyInfo.getValue();
            }
            propertyInfo = new PropertyInfo();
            propertyInfo.setType(class$java$lang$String == null ? (class$java$lang$String = SoapObject.class$("java.lang.String")) : class$java$lang$String);
            propertyInfo.setValue(EMPTY_STRING);
            propertyInfo.setName(name);
            return propertyInfo.getValue();
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public String getPrimitivePropertyAsString(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
            if (propertyInfo.getType() != (class$org$ksoap2$serialization$SoapObject == null ? (class$org$ksoap2$serialization$SoapObject = SoapObject.class$("org.ksoap2.serialization.SoapObject")) : class$org$ksoap2$serialization$SoapObject) && propertyInfo.getValue() != null) {
                return propertyInfo.getValue().toString();
            }
            return EMPTY_STRING;
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public Object getPrimitivePropertySafely(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
            if (propertyInfo.getType() != (class$org$ksoap2$serialization$SoapObject == null ? (class$org$ksoap2$serialization$SoapObject = SoapObject.class$("org.ksoap2.serialization.SoapObject")) : class$org$ksoap2$serialization$SoapObject) && propertyInfo.getValue() != null) {
                return propertyInfo.getValue().toString();
            }
            propertyInfo = new PropertyInfo();
            propertyInfo.setType(class$java$lang$String == null ? (class$java$lang$String = SoapObject.class$("java.lang.String")) : class$java$lang$String);
            propertyInfo.setValue(EMPTY_STRING);
            propertyInfo.setName(name);
            return propertyInfo.getValue();
        }
        return new NullSoapObject();
    }

    public String getPrimitivePropertySafelyAsString(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
            if (propertyInfo.getType() != (class$org$ksoap2$serialization$SoapObject == null ? (class$org$ksoap2$serialization$SoapObject = SoapObject.class$("org.ksoap2.serialization.SoapObject")) : class$org$ksoap2$serialization$SoapObject) && propertyInfo.getValue() != null) {
                return propertyInfo.getValue().toString();
            }
            return EMPTY_STRING;
        }
        return EMPTY_STRING;
    }

    private Integer propertyIndex(String name) {
        if (name != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!name.equals(((PropertyInfo)this.properties.elementAt(i)).getName())) continue;
                return new Integer(i);
            }
        }
        return null;
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public void getPropertyInfo(int index, Hashtable properties, PropertyInfo propertyInfo) {
        this.getPropertyInfo(index, propertyInfo);
    }

    public void getPropertyInfo(int index, PropertyInfo propertyInfo) {
        Object element = this.properties.elementAt(index);
        if (element instanceof PropertyInfo) {
            PropertyInfo p = (PropertyInfo)element;
            propertyInfo.name = p.name;
            propertyInfo.namespace = p.namespace;
            propertyInfo.flags = p.flags;
            propertyInfo.type = p.type;
            propertyInfo.elementType = p.elementType;
            propertyInfo.value = p.value;
            propertyInfo.multiRef = p.multiRef;
        } else {
            propertyInfo.name = null;
            propertyInfo.namespace = null;
            propertyInfo.flags = 0;
            propertyInfo.type = null;
            propertyInfo.elementType = null;
            propertyInfo.value = element;
            propertyInfo.multiRef = false;
        }
    }

    public SoapObject newInstance() {
        SoapObject o = new SoapObject(this.namespace, this.name);
        for (int propIndex = 0; propIndex < this.properties.size(); ++propIndex) {
            Object prop = this.properties.elementAt(propIndex);
            if (prop instanceof PropertyInfo) {
                PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(propIndex);
                PropertyInfo propertyInfoClonned = (PropertyInfo)propertyInfo.clone();
                o.addProperty(propertyInfoClonned);
                continue;
            }
            if (!(prop instanceof SoapObject)) continue;
            o.addSoapObject(((SoapObject)prop).newInstance());
        }
        for (int attribIndex = 0; attribIndex < this.getAttributeCount(); ++attribIndex) {
            AttributeInfo newAI = new AttributeInfo();
            this.getAttributeInfo(attribIndex, newAI);
            AttributeInfo attributeInfo = newAI;
            o.addAttribute(attributeInfo);
        }
        return o;
    }

    public void setProperty(int index, Object value) {
        Object prop = this.properties.elementAt(index);
        if (prop instanceof PropertyInfo) {
            ((PropertyInfo)prop).setValue(value);
        }
    }

    public SoapObject addProperty(String name, Object value) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = name;
        propertyInfo.type = value == null ? PropertyInfo.OBJECT_CLASS : value.getClass();
        propertyInfo.value = value;
        return this.addProperty(propertyInfo);
    }

    public SoapObject addPropertyIfValue(String name, Object value) {
        if (value != null) {
            return this.addProperty(name, value);
        }
        return this;
    }

    public SoapObject addPropertyIfValue(PropertyInfo propertyInfo, Object value) {
        if (value != null) {
            propertyInfo.setValue(value);
            return this.addProperty(propertyInfo);
        }
        return this;
    }

    public SoapObject addProperty(PropertyInfo propertyInfo) {
        this.properties.addElement(propertyInfo);
        return this;
    }

    public SoapObject addPropertyIfValue(PropertyInfo propertyInfo) {
        if (propertyInfo.value != null) {
            this.properties.addElement(propertyInfo);
            return this;
        }
        return this;
    }

    public SoapObject addSoapObject(SoapObject soapObject) {
        this.properties.addElement(soapObject);
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(EMPTY_STRING + this.name + "{");
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            Object prop = this.properties.elementAt(i);
            if (prop instanceof PropertyInfo) {
                buf.append(EMPTY_STRING).append(((PropertyInfo)prop).getName()).append("=").append(this.getProperty(i)).append("; ");
                continue;
            }
            buf.append(((SoapObject)prop).toString());
        }
        buf.append("}");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

