package com.weatherdemo.SMS;

import com.weatherdemo.R;
import com.weatherdemo.DB.DBAdapter;

import android.R.string;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class SmsAdapter extends BaseAdapter{


	private LayoutInflater mInflater;
	private static DBAdapter dbAdapter;
	private static SimpleSms[] smsList;

	public SmsAdapter(Context context){
		mInflater = LayoutInflater.from(context);
		dbAdapter = new DBAdapter(context);
		dbAdapter.open();
		smsList = dbAdapter.GetAllSms();
	}

	public static void RefreshData(){
		smsList = dbAdapter.GetAllSms();
	}

	@Override
	public int getCount() {
		// TODO Auto-generated method stub
		if(smsList == null){
			return 0;
		}
		else {
			return smsList.length;
		}
	}

	@Override
	public Object getItem(int arg0) {
		// TODO Auto-generated method stub
		if(smsList == null){
			return 0;
		}
		else{
			return smsList[arg0];
		}
	}

	@Override
	public long getItemId(int arg0) {
		// TODO Auto-generated method stub
		return arg0;
	}

	@Override
	public View getView(int position, View converView, ViewGroup parent) {
		// TODO Auto-generated method stub
		ViewHolder holder;
		if(converView == null){
			converView = mInflater.inflate(R.layout.data_row, null);
			holder = new ViewHolder();
			holder.textRow01 = (TextView)converView.findViewById(R.id.data_row_01);
			holder.textRow02 = (TextView)converView.findViewById(R.id.data_row_02);
			converView.setTag(holder);
		}
		else{
			holder = (ViewHolder)converView.getTag();
		}
		
		if(smsList != null){
			String row01Msg ="（"+position+"）" +" 发送者："+ smsList[position].Sender+"，"+smsList[position].ReceiveTime;
			holder.textRow01.setText(row01Msg);
			holder.textRow02.setText(smsList[position].ReturnResult);
		}
		return converView;
	}
	
	private class ViewHolder{
		TextView textRow01;
		TextView textRow02;
	}

}
