/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestInterceptorList;
import org.apache.http.protocol.HttpResponseInterceptorList;

@ThreadSafe
public final class ImmutableHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    public ImmutableHttpProcessor(HttpRequestInterceptor[] requestInterceptors, HttpResponseInterceptor[] responseInterceptors) {
        int i;
        int count;
        if (requestInterceptors != null) {
            count = requestInterceptors.length;
            this.requestInterceptors = new HttpRequestInterceptor[count];
            i = 0;
            while (i < count) {
                this.requestInterceptors[i] = requestInterceptors[i];
                ++i;
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (responseInterceptors != null) {
            count = responseInterceptors.length;
            this.responseInterceptors = new HttpResponseInterceptor[count];
            i = 0;
            while (i < count) {
                this.responseInterceptors[i] = responseInterceptors[i];
                ++i;
            }
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptorList requestInterceptors, HttpResponseInterceptorList responseInterceptors) {
        int i;
        int count;
        if (requestInterceptors != null) {
            count = requestInterceptors.getRequestInterceptorCount();
            this.requestInterceptors = new HttpRequestInterceptor[count];
            i = 0;
            while (i < count) {
                this.requestInterceptors[i] = requestInterceptors.getRequestInterceptor(i);
                ++i;
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (responseInterceptors != null) {
            count = responseInterceptors.getResponseInterceptorCount();
            this.responseInterceptors = new HttpResponseInterceptor[count];
            i = 0;
            while (i < count) {
                this.responseInterceptors[i] = responseInterceptors.getResponseInterceptor(i);
                ++i;
            }
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptor[] requestInterceptors) {
        this(requestInterceptors, null);
    }

    public ImmutableHttpProcessor(HttpResponseInterceptor[] responseInterceptors) {
        this(null, responseInterceptors);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws IOException, HttpException {
        int i = 0;
        while (i < this.requestInterceptors.length) {
            this.requestInterceptors[i].process(request, context);
            ++i;
        }
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws IOException, HttpException {
        int i = 0;
        while (i < this.responseInterceptors.length) {
            this.responseInterceptors[i].process(response, context);
            ++i;
        }
    }
}

