/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVOnlineConfigureListener;
import com.avos.avoscloud.AVUncaughtExceptionHandler;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AnalyticsEvent;
import com.avos.avoscloud.AnalyticsOnlineConfig;
import com.avos.avoscloud.AnalyticsSession;
import com.avos.avoscloud.AnalyticsUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.JSONHelper;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ReportPolicy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsImpl {
    protected static boolean enableDebugLog = false;
    private String appChannel = "AVOS Cloud";
    private final long sendInterval = 15000L;
    private final long batchInterval = 120000L;
    private boolean autoLocation;
    private final Handler timerHandler = new Handler();
    Runnable timerRunnable = null;
    Runnable batchTimerRunnable = null;
    private final ConcurrentHashMap<String, AnalyticsSession> sessions;
    private long pauseTimeStamp;
    private String currentSessionId;
    private static long sessionThreshold = 30000L;
    private final AtomicInteger messageCount = new AtomicInteger(0);
    private static int messageCountThreshold = 30;
    private static final String TAG = AnalyticsImpl.class.getSimpleName();
    private AVUncaughtExceptionHandler handler = null;
    private AnalyticsOnlineConfig onlineConfig = null;
    private AVOnlineConfigureListener listener = null;
    private Map<String, String> customInfo;
    private volatile Timer updateOnlineConfigTimer = null;
    private static final String firstBootTag = "firstBoot";
    private static final List<String> whiteList = new LinkedList<String>();
    private static final String PREFERENCE_KEY = "avoscloud-analysis";
    private static final String SESSION_KEY = "currentSession";
    boolean analysisReportEnableFlag = true;

    public AnalyticsImpl() {
        this.sessions = new ConcurrentHashMap();
        this.onlineConfig = new AnalyticsOnlineConfig(this);
    }

    public void setAutoLocation(boolean b) {
        this.autoLocation = b;
    }

    public boolean isAutoLocation() {
        return this.autoLocation;
    }

    public boolean isEnableStats() {
        return this.onlineConfig.isEnableStats();
    }

    public long getSendInterval() {
        return 15000L;
    }

    public void setAppChannel(String channel) {
        this.appChannel = channel;
    }

    public String getAppChannel() {
        return this.appChannel;
    }

    public void setEnableDebugLog(boolean b) {
        enableDebugLog = b;
    }

    public boolean isEnableDebugLog() {
        return enableDebugLog;
    }

    public void enableCrashReport(Context context, boolean enable) {
        if (enable && this.handler == null) {
            this.handler = new AVUncaughtExceptionHandler(context);
        }
        if (this.handler != null) {
            this.handler.enableCrashHanlder(enable);
        }
    }

    public ReportPolicy getReportPolicy(Context context) {
        ReportPolicy value = this.onlineConfig.getReportPolicy();
        if (value == ReportPolicy.REALTIME && whiteList.contains(AVOSCloud.applicationId)) {
            return ReportPolicy.REALTIME;
        }
        if (value == ReportPolicy.REALTIME && !this.inDebug(context)) {
            return ReportPolicy.BATCH;
        }
        if (value == ReportPolicy.SENDWIFIONLY && !this.inDebug(context)) {
            return ReportPolicy.BATCH;
        }
        return value;
    }

    protected void setReportPolicy(Context context, ReportPolicy p) {
        this.onlineConfig.setReportPolicy(p);
        this.configChanged(context);
    }

    public void notifyOnlineConfigListener(JSONObject data) {
        if (this.listener != null) {
            try {
                this.listener.onDataReceived(data);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Notify online data received failed.", (Throwable)e);
            }
        }
    }

    public void configChanged(Context context) {
        try {
            if (this.onlineConfig.getReportPolicy() != ReportPolicy.SEND_INTERVAL && this.timerRunnable != null) {
                this.timerHandler.removeCallbacks(this.timerRunnable);
                this.timerRunnable = null;
            }
            if (this.onlineConfig.getReportPolicy() != ReportPolicy.BATCH && this.batchTimerRunnable != null) {
                this.timerHandler.removeCallbacks(this.batchTimerRunnable);
                this.batchTimerRunnable = null;
            }
            this.postRecording(context);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Notify config changed failed.", (Throwable)e);
        }
    }

    private AnalyticsSession currentSession(boolean create) {
        AnalyticsSession session = this.sessionByName(this.currentSessionId);
        if (session != null) {
            return session;
        }
        if (!create) {
            return null;
        }
        session = this.createSession();
        this.currentSessionId = session.getSessionId();
        return session;
    }

    public void setSessionContinueMillis(long ms) {
        sessionThreshold = ms;
    }

    public void setSessionDuration(long ms) {
        AnalyticsSession session = this.currentSession(true);
        session.setSessionDuration(ms);
    }

    public int getMessageCount() {
        return this.messageCount.get();
    }

    public int incMessageCount() {
        return this.messageCount.incrementAndGet();
    }

    public boolean exceedAndResetMessageCount() {
        while (this.getMessageCount() >= messageCountThreshold) {
            if (!this.messageCount.compareAndSet(this.getMessageCount(), 0)) continue;
            return true;
        }
        return false;
    }

    protected void resetMessageCount() {
        this.messageCount.set(0);
    }

    protected void resetMessageCount(int i) {
        this.messageCount.set(i);
    }

    private AnalyticsSession sessionByName(String sid) {
        if (sid == null) {
            return null;
        }
        return this.sessions.get(sid);
    }

    private AnalyticsSession createSession() {
        AnalyticsSession session = new AnalyticsSession();
        session.beginSession();
        if (session.getSessionId() != null) {
            this.sessions.put(session.getSessionId(), session);
        }
        return session;
    }

    protected void flushLastSession(Context context) {
        String lastSessionString = context.getSharedPreferences(PREFERENCE_KEY, 0).getString(SESSION_KEY, null);
        this.archiveCurrentSession(context);
        if (!AVUtils.isBlankString((String)lastSessionString) && JSON.parseObject((String)lastSessionString, AnalyticsSession.class) != null) {
            AnalyticsSession lastSession = (AnalyticsSession)JSON.parseObject((String)lastSessionString, AnalyticsSession.class);
            String lastSessionId = lastSession.getSessionId();
            lastSession = this.sessionByName(lastSessionId) == null ? lastSession : this.sessionByName(lastSessionId);
            lastSession.endSession();
            Map<String, Object> map = lastSession.jsonMap(context, this.customInfo, true);
            if (map != null) {
                String jsonString = JSON.toJSONString(map);
                if (enableDebugLog) {
                    LogUtil.log.i((String)"send last session stored");
                }
                this.sendAnalysisRequest(jsonString, false, true, new GenericObjectCallback(){

                    public void onSuccess(String content, AVException e) {
                        if (enableDebugLog) {
                            Log.i((String)TAG, (String)("Save success: " + content));
                        }
                        AnalyticsImpl.this.sendArchivedRequests(false);
                    }

                    public void onFailure(Throwable error, String content) {
                        if (enableDebugLog) {
                            Log.i((String)TAG, (String)("Save failed: " + content));
                        }
                        AnalyticsImpl.this.sendArchivedRequests(false);
                    }
                });
            }
        } else {
            this.sendArchivedRequests(false);
        }
    }

    public void beginSession() {
        AnalyticsSession session = this.sessionByName(this.currentSessionId);
        if (session == null) {
            session = this.createSession();
        }
        this.currentSessionId = session.getSessionId();
        this.incMessageCount();
    }

    public void endSession(Context context) {
        AnalyticsSession session = this.sessionByName(this.currentSessionId);
        if (session == null) {
            return;
        }
        session.endSession();
        if (this.isEnableDebugLog()) {
            this.dumpJsonMap(context);
        }
        this.currentSessionId = null;
        this.incMessageCount();
    }

    public void pauseSession() {
        AnalyticsSession session = this.sessionByName(this.currentSessionId);
        if (session == null) {
            return;
        }
        session.pauseSession();
        this.pauseTimeStamp = AnalyticsUtils.getCurrentTimestamp();
    }

    public void addActivity(String name, long ms) {
        this.currentSession(true).addActivity(name, ms);
    }

    public void beginActivity(String name) {
        this.currentSession(true).beginActivity(name);
        this.incMessageCount();
    }

    public void beginFragment(String name) {
        this.currentSession(true).beginFragment(name);
        this.incMessageCount();
    }

    public void beginEvent(Context context, String name) {
        this.beginEvent(context, name, "", "");
    }

    public AnalyticsEvent beginEvent(Context context, String name, String label, String key) {
        AnalyticsSession session = this.currentSession(true);
        AnalyticsEvent event = session.beginEvent(context, name, label, key);
        this.incMessageCount();
        return event;
    }

    public void endEvent(Context context, String name, String label, String key) {
        this.currentSession(true).endEvent(context, name, label, key);
        this.incMessageCount();
    }

    public void setCustomInfo(Map<String, String> extensionInfo) {
        this.customInfo = extensionInfo;
    }

    public Map<String, String> getCustomInfo() {
        return this.customInfo;
    }

    private long getSessionTimeoutThreshold() {
        return sessionThreshold;
    }

    public boolean shouldRegardAsNewSession() {
        long start;
        AnalyticsSession session = this.currentSession(false);
        if (session == null) {
            return true;
        }
        long current = AnalyticsUtils.getCurrentTimestamp();
        long delta = current - (start = this.pauseTimeStamp);
        return delta > this.getSessionTimeoutThreshold() && start > 0L;
    }

    public void endActivity(String name) {
        this.currentSession(true).endActivity(name);
        this.incMessageCount();
    }

    public void endFragment(String name) {
        this.currentSession(true).endFragment(name);
        this.incMessageCount();
    }

    private void dumpJsonMap(Context context) {
        for (AnalyticsSession session : this.sessions.values()) {
            Map<String, Object> map = session.jsonMap(context, this.customInfo, false);
            try {
                if (map == null) continue;
                String jsonString = JSONHelper.toJsonString(map);
                LogUtil.log.d((String)jsonString);
            }
            catch (Exception exception) {
                LogUtil.log.e((String)TAG, (String)"", (Exception)exception);
            }
        }
    }

    public synchronized void report(Context context, boolean clear) {
        try {
            this.saveSessionsToServer(context);
            Iterator<Map.Entry<String, AnalyticsSession>> iter = this.sessions.entrySet().iterator();
            while (iter.hasNext()) {
                if (!iter.next().getValue().isSessionFinished()) continue;
                iter.remove();
            }
            if (clear) {
                this.clearSessions();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Send statstics report failed", (Throwable)e);
        }
    }

    public void debugDump(Context context) {
        if (!enableDebugLog) {
            return;
        }
        for (AnalyticsSession session : this.sessions.values()) {
            Map<String, Object> map = session.jsonMap(context, this.customInfo, false);
            Log.i((String)TAG, (String)("json data: " + map));
        }
    }

    private boolean inDebug(Context context) {
        if (context != null) {
            boolean debug;
            boolean bl = debug = 0 != (context.getApplicationInfo().flags & 2);
            if (debug) {
                Log.i((String)TAG, (String)("in debug: " + debug));
            }
            return debug;
        }
        return false;
    }

    public void postRecording(Context context) {
        if (enableDebugLog) {
            Log.d((String)TAG, (String)("report policy:" + (Object)((Object)this.onlineConfig.getReportPolicy())));
        }
        this.archiveCurrentSession(context);
        try {
            if (!this.isEnableStats()) {
                return;
            }
            switch (this.getReportPolicy(context)) {
                case SEND_INTERVAL: {
                    this.intervalRecording(context);
                    break;
                }
                case REALTIME: 
                case SENDWIFIONLY: {
                    this.report(context, false);
                    break;
                }
                case SEND_ON_EXIT: {
                    break;
                }
                default: {
                    this.batchRecording(context);
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Post record failed.", (Throwable)e);
        }
    }

    protected synchronized void archiveCurrentSession(Context context) {
        AnalyticsSession currentSession = this.sessionByName(this.currentSessionId);
        SharedPreferences.Editor p = context.getSharedPreferences(PREFERENCE_KEY, 0).edit();
        if (currentSession != null) {
            String sessionString = JSON.toJSONString((Object)currentSession);
            p.putString(SESSION_KEY, sessionString);
            p.commit();
            if (enableDebugLog) {
                Log.d((String)TAG, (String)("try to archive current session:" + sessionString));
            }
        } else {
            p.clear();
        }
    }

    private void intervalRecording(final Context context) {
        if (this.timerRunnable == null) {
            this.timerRunnable = new Runnable(){

                public void run() {
                    try {
                        if (enableDebugLog) {
                            Log.d((String)TAG, (String)"send statistics data via interval timer");
                        }
                        AnalyticsImpl.this.report(context, false);
                        if (AnalyticsImpl.this.getReportPolicy(context) == ReportPolicy.SEND_INTERVAL) {
                            AnalyticsImpl.this.timerHandler.postDelayed((Runnable)this, AnalyticsImpl.this.getSendInterval());
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"intervalRecording failed.", (Throwable)e);
                    }
                }
            };
            this.timerHandler.postDelayed(this.timerRunnable, this.getSendInterval());
        }
    }

    private void batchTimerIntervalRecording(final Context context) {
        if (this.batchTimerRunnable == null) {
            this.batchTimerRunnable = new Runnable(){

                public void run() {
                    block4: {
                        try {
                            if (enableDebugLog) {
                                Log.d((String)TAG, (String)"send statistics data via batch timer");
                            }
                            AnalyticsImpl.this.report(context, false);
                            if (AnalyticsImpl.this.getReportPolicy(context) == ReportPolicy.BATCH) {
                                AnalyticsImpl.this.timerHandler.postDelayed((Runnable)this, 120000L);
                            }
                        }
                        catch (Exception e) {
                            if (!enableDebugLog) break block4;
                            Log.d((String)TAG, (String)"exception during batch interval recording");
                        }
                    }
                }
            };
            this.timerHandler.postDelayed(this.batchTimerRunnable, 120000L);
        }
    }

    private void batchRecording(Context context) {
        if (this.exceedAndResetMessageCount()) {
            this.report(context, false);
        } else {
            this.batchTimerIntervalRecording(context);
        }
    }

    public void saveSessionsToServer(final Context context) {
        new AsyncTask<Void, Integer, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    AnalyticsImpl.this.sendArchivedRequests(true);
                    for (AnalyticsSession session : AnalyticsImpl.this.sessions.values()) {
                        Map<String, Object> map = session.jsonMap(context, AnalyticsImpl.this.customInfo, true);
                        if (map == null) continue;
                        String jsonString = JSON.toJSONString(map);
                        if (enableDebugLog) {
                            LogUtil.log.i((String)jsonString);
                        }
                        AnalyticsImpl.this.archiveCurrentSession(context);
                        AnalyticsImpl.this.resetMessageCount(session.getActivities().size() + session.getEvents().size());
                        AnalyticsImpl.this.sendAnalysisRequest(jsonString, true, true, new GenericObjectCallback(){

                            public void onSuccess(String content, AVException e) {
                                if (enableDebugLog) {
                                    Log.i((String)TAG, (String)("Save success: " + content));
                                }
                            }

                            public void onFailure(Throwable error, String content) {
                                if (enableDebugLog) {
                                    Log.i((String)TAG, (String)("Save failed: " + content));
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"saveSessionsToServer failed.", (Throwable)e);
                }
                return null;
            }
        }.execute((Object[])new Void[]{null});
    }

    public void clearSessions() {
        this.sessions.clear();
        this.currentSessionId = null;
    }

    public void setAVOnlineConfigureListener(AVOnlineConfigureListener listener) {
        this.listener = listener;
        if (listener != null && this.updateOnlineConfigTimer == null) {
            this.updateOnlineConfigTimer = new Timer(true);
            this.updateOnlineConfigTimer.schedule(new TimerTask(){

                public void run() {
                    try {
                        AnalyticsImpl.this.onlineConfig.update(null, false);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"update online config failed", (Throwable)e);
                    }
                }
            }, 1000L, 1000L);
        }
    }

    public void updateOnlineConfig(Context context) {
        try {
            if (this.onlineConfig != null) {
                if (enableDebugLog) {
                    Log.d((String)TAG, (String)"try to update statistics config from online data");
                }
                this.onlineConfig.update(context);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Update online config failed.", (Throwable)e);
        }
    }

    public void reportFirstBoot(Context context) {
        SharedPreferences sharedPref = context.getSharedPreferences("AVOSCloud-SDK", 0);
        boolean firstBoot = sharedPref.getBoolean(firstBootTag, true);
        if (firstBoot) {
            this.saveSessionsToServer(context);
            Map<String, Object> firstBootMap = this.currentSession(false).firstBootMap(context, this.customInfo);
            if (firstBootMap != null) {
                if (enableDebugLog) {
                    LogUtil.avlog.d((String)"report data on first boot");
                }
                String jsonString = JSON.toJSONString(firstBootMap);
                this.sendAnalysisRequest(jsonString, false, true, null);
            }
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putBoolean(firstBootTag, false);
            editor.commit();
        }
    }

    public String getConfigParams(String key, String defaultValue) {
        String result = this.onlineConfig.getConfigParams(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public void sendAnalysisRequest(String jsonString, boolean sync, boolean eventually, GenericObjectCallback callback) {
        if (this.analysisReportEnableFlag) {
            if (enableDebugLog) {
                LogUtil.avlog.d((String)"send stats immediatately");
            }
            PaasClient.statistisInstance().postObject("stats/collect", jsonString, sync, eventually, callback, null, AVUtils.md5((String)jsonString));
        }
    }

    protected synchronized void setAnalyticsEnabled(boolean enable) {
        this.analysisReportEnableFlag = enable;
    }

    protected synchronized void sendArchivedRequests(boolean sync) {
        if (this.analysisReportEnableFlag) {
            PaasClient.statistisInstance().handleAllArchivedRequest(sync);
        }
    }
}

