/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AnalyticsImpl;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.JSONHelper;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ReportPolicy;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AnalyticsOnlineConfig {
    private ReportPolicy reportPolicy = ReportPolicy.SEND_INTERVAL;
    protected Map<String, String> config = new HashMap<String, String>();
    private final AnalyticsImpl parent;
    private boolean enableStats = true;

    public AnalyticsOnlineConfig(AnalyticsImpl ref) {
        this.parent = ref;
    }

    public void update(Context context) {
        this.update(context, true);
    }

    public void update(final Context context, final boolean updatePolicy) {
        String endPoint = String.format("statistics/apps/%s/sendPolicy", AVOSCloud.applicationId);
        PaasClient.statistisInstance().getObject(endPoint, null, false, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                try {
                    Map jsonMap = JSONHelper.mapFromString((String)content);
                    Object parameters = jsonMap.get("parameters");
                    boolean notifyListener = false;
                    if (parameters != null && parameters instanceof Map) {
                        Map newConfig = (Map)parameters;
                        notifyListener = !AnalyticsOnlineConfig.this.config.equals(newConfig);
                        AnalyticsOnlineConfig.this.config.clear();
                        AnalyticsOnlineConfig.this.config.putAll(newConfig);
                        AnalyticsOnlineConfig.this.parent.notifyOnlineConfigListener(new JSONObject(AnalyticsOnlineConfig.this.config));
                    }
                    if (updatePolicy) {
                        Number policy;
                        Boolean enable = (Boolean)jsonMap.get("enable");
                        if (enable != null) {
                            AnalyticsOnlineConfig.this.enableStats = enable;
                        }
                        if ((policy = (Number)jsonMap.get("policy")) != null) {
                            ReportPolicy oldPolicy = AnalyticsOnlineConfig.this.reportPolicy;
                            AnalyticsOnlineConfig.this.reportPolicy = ReportPolicy.valueOf(policy.intValue());
                            if (oldPolicy != AnalyticsOnlineConfig.this.reportPolicy || notifyListener) {
                                AnalyticsOnlineConfig.this.parent.configChanged(context);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void onFailure(Throwable error, String content) {
                LogUtil.log.e((String)("Failed " + content));
            }
        });
    }

    public boolean isEnableStats() {
        return this.enableStats;
    }

    public void setEnableStats(boolean enableStats) {
        this.enableStats = enableStats;
    }

    public void setReportPolicy(ReportPolicy p) {
        this.reportPolicy = p;
    }

    public ReportPolicy getReportPolicy() {
        return this.reportPolicy;
    }

    public String getConfigParams(String key) {
        String object = this.config.get(key);
        if (object instanceof String) {
            return object;
        }
        return null;
    }
}

