/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.util.Log;
import com.avos.avoscloud.AVDuration;
import com.avos.avoscloud.AnalyticsActivity;
import com.avos.avoscloud.AnalyticsEvent;
import com.avos.avoscloud.AnalyticsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsSession {
    private List<AnalyticsActivity> activities;
    private List<AnalyticsEvent> events;
    private String sessionId = "";
    private AVDuration duration = new AVDuration();
    private static final String sessionIdTag = "sessionId";
    private static final String TAG = AnalyticsSession.class.getSimpleName();

    public AnalyticsSession() {
        this.activities = new ArrayList<AnalyticsActivity>();
        this.events = new ArrayList<AnalyticsEvent>();
    }

    public void beginSession() {
        this.sessionId = AnalyticsUtils.uniqueId();
        this.duration.start();
    }

    public void endSession() {
        if (this.sessionId.isEmpty()) {
            return;
        }
        for (AnalyticsActivity a : this.getActivities()) {
            if (a.isStopped()) continue;
            a.stop();
        }
        for (AnalyticsEvent e : this.getEvents()) {
            if (e.getDuration().isStopped()) continue;
            e.stop();
        }
        this.duration.stop();
    }

    public boolean isSessionFinished() {
        return this.duration.isStopped();
    }

    public void pauseSession() {
        this.duration.pause();
    }

    public long getSessionStart() {
        return this.duration.getCreateTimeStamp();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionDuration(long ms) {
        this.duration.setDuration(ms);
    }

    public AnalyticsActivity activityByName(String name, boolean create) {
        for (AnalyticsActivity activity : this.activities) {
            if (!activity.getActivityName().equalsIgnoreCase(name) || activity.isStopped()) continue;
            return activity;
        }
        AnalyticsActivity activity = null;
        if (create) {
            activity = new AnalyticsActivity(name);
            this.activities.add(activity);
        }
        return activity;
    }

    public AnalyticsEvent eventByName(String name, String label, String key, boolean create) {
        for (AnalyticsEvent event : this.events) {
            if (!event.isMatch(name, label, key)) continue;
            return event;
        }
        AnalyticsEvent event = null;
        if (create) {
            event = new AnalyticsEvent(name);
            event.setLabel(label);
            event.setPrimaryKey(key);
            this.events.add(event);
        }
        return event;
    }

    public void addActivity(String name, long ms) {
        AnalyticsActivity activity = this.activityByName(name, true);
        activity.setDurationValue(ms);
    }

    public void beginActivity(String name) {
        AnalyticsActivity activity = this.activityByName(name, true);
        activity.start();
        this.duration.resume();
    }

    public void beginFragment(String name) {
        AnalyticsActivity fragment = this.activityByName(name, true);
        fragment.setFragment(true);
        fragment.start();
        this.duration.resume();
    }

    public AnalyticsEvent beginEvent(Context context, String name, String label, String key) {
        AnalyticsEvent event = this.eventByName(name, label, key, true);
        if (label != null && !label.isEmpty()) {
            event.setLabel(label);
        }
        event.start();
        return event;
    }

    public void endEvent(Context context, String name, String label, String key) {
        AnalyticsEvent event = this.eventByName(name, label, key, false);
        if (event == null) {
            return;
        }
        event.stop();
    }

    public void endActivity(String name) {
        AnalyticsActivity activity = this.activityByName(name, false);
        if (activity == null) {
            Log.i((String)"", (String)"Please call begin activity before using endActivity");
            return;
        }
        activity.stop();
    }

    public void endFragment(String name) {
        AnalyticsActivity fragment = this.activityByName(name, false);
        if (fragment == null) {
            Log.i((String)"", (String)"Please call begin Fragment before using endFragment");
            return;
        }
        fragment.stop();
    }

    public Map<String, Object> launchMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(sessionIdTag, this.sessionId);
        map.put("date", this.duration.getCreateTimeStamp());
        return map;
    }

    private long myDuration(long max, long sum) {
        long value = this.duration.getDuration();
        if (value > 2L * sum && sum != 0L) {
            value = sum;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private long maxSessionDuration() {
        return 3600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> activitiesMap(boolean cleanUpAnalysisData) {
        LinkedList<Map<String, Object>> array = new LinkedList<Map<String, Object>>();
        long activitiesDuration = 0L;
        Iterator<AnalyticsActivity> i$ = this.activities.iterator();
        while (i$.hasNext()) {
            AnalyticsActivity a;
            AnalyticsActivity analyticsActivity = a = i$.next();
            synchronized (analyticsActivity) {
                if (a.isStopped() && !a.isSavedToServer()) {
                    array.add(a.jsonMap());
                    if (cleanUpAnalysisData) {
                        a.setSavedToServer(true);
                    }
                }
            }
            if (a.isFragment) continue;
            activitiesDuration += a.myDuration();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activities", array);
        map.put(sessionIdTag, this.sessionId);
        map.put("duration", this.myDuration(this.maxSessionDuration(), activitiesDuration));
        return map;
    }

    public List<Object> eventArray(boolean cleanUpAnalysisData) {
        LinkedList<Object> array = new LinkedList<Object>();
        LinkedList<AnalyticsEvent> toDelete = new LinkedList<AnalyticsEvent>();
        for (AnalyticsEvent e : this.events) {
            if (!e.getDuration().isStopped()) continue;
            array.add(e.jsonMap());
            toDelete.add(e);
        }
        if (cleanUpAnalysisData) {
            this.events.removeAll(toDelete);
        }
        return array;
    }

    protected boolean hasNewData() {
        for (AnalyticsActivity a : this.activities) {
            if (!a.isStopped() || a.isSavedToServer()) continue;
            return true;
        }
        for (AnalyticsEvent e : this.events) {
            if (!e.getDuration().isStopped()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> jsonMap(Context context, Map<String, String> customInfo, boolean cleanUpAnalysisData) {
        if (this.hasNewData()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            HashMap<String, Object> events = new HashMap<String, Object>();
            events.put("launch", this.launchMap());
            events.put("terminate", this.activitiesMap(cleanUpAnalysisData));
            events.put("event", this.eventArray(cleanUpAnalysisData));
            result.put("events", events);
            Map<String, Object> devInfo = AnalyticsUtils.deviceInfo(context);
            result.put("device", devInfo);
            if (customInfo != null) {
                result.put("customInfo", customInfo);
            }
            return result;
        }
        return null;
    }

    protected Map<String, Object> firstBootMap(Context context, Map<String, String> customInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> events = new HashMap<String, Map<String, Object>>();
        events.put("launch", this.launchMap());
        Map<String, Object> devInfo = AnalyticsUtils.deviceInfo(context);
        result.put("device", devInfo);
        if (customInfo != null) {
            result.put("customInfo", customInfo);
        }
        return result;
    }

    protected List<AnalyticsActivity> getActivities() {
        return this.activities;
    }

    protected void setActivities(List<AnalyticsActivity> activities) {
        this.activities = activities;
    }

    protected List<AnalyticsEvent> getEvents() {
        return this.events;
    }

    protected void setEvents(List<AnalyticsEvent> events) {
        this.events = events;
    }

    protected AVDuration getDuration() {
        return this.duration;
    }

    protected void setDuration(AVDuration duration) {
        this.duration = duration;
    }

    protected void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

