/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVRole;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.PaasClient;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVACL {
    private final Map<String, Object> permissionsById = new HashMap<String, Object>();
    private static String readTag = "read";
    private static String writeTag = "write";
    private static String publicTag = "*";

    public AVACL() {
    }

    AVACL(AVACL right) {
        this.permissionsById.putAll(right.permissionsById);
    }

    public AVACL(AVUser owner) {
        this.setReadAccess(owner, true);
        this.setWriteAccess(owner, true);
    }

    private Map<String, Object> mapForKey(String key, boolean create) {
        HashMap map = (HashMap)this.permissionsById.get(key);
        if (map == null && create) {
            map = new HashMap();
            this.permissionsById.put(key, map);
        }
        return map;
    }

    private void allowRead(boolean allowed, String key) {
        Map<String, Object> map = this.mapForKey(key, allowed);
        if (allowed) {
            map.put(readTag, true);
        } else if (map != null) {
            map.remove(readTag);
        }
    }

    private boolean isReadAllowed(String key) {
        Map<String, Object> map = this.mapForKey(key, false);
        return map != null && (Boolean)map.get(readTag) != null && (Boolean)map.get(readTag) != false;
    }

    private void allowWrite(boolean allowed, String key) {
        Map<String, Object> map = this.mapForKey(key, allowed);
        if (allowed) {
            map.put(writeTag, allowed);
        } else if (map != null) {
            map.remove(writeTag);
        }
    }

    private boolean isWriteAllowed(String key) {
        Map<String, Object> map = this.mapForKey(key, false);
        return map != null && (Boolean)map.get(writeTag) != null && (Boolean)map.get(writeTag) != false;
    }

    public boolean getPublicReadAccess() {
        return this.isReadAllowed(publicTag);
    }

    public boolean getPublicWriteAccess() {
        return this.isWriteAllowed(publicTag);
    }

    public boolean getReadAccess(AVUser user) {
        return this.getReadAccess(user.getObjectId());
    }

    public boolean getReadAccess(String userId) {
        return this.isReadAllowed(userId);
    }

    private String roleName(String name) {
        return String.format("role:%s", name);
    }

    public boolean getRoleReadAccess(AVRole role) {
        String r = this.roleName(role.getName());
        return this.getRoleReadAccess(r);
    }

    public boolean getRoleReadAccess(String roleName) {
        return this.isReadAllowed(roleName);
    }

    public boolean getRoleWriteAccess(AVRole role) {
        String r = this.roleName(role.getName());
        return this.getRoleWriteAccess(r);
    }

    public boolean getRoleWriteAccess(String roleName) {
        return this.isWriteAllowed(roleName);
    }

    public boolean getWriteAccess(AVUser user) {
        return this.getWriteAccess(user.getObjectId());
    }

    public boolean getWriteAccess(String userId) {
        return this.isWriteAllowed(userId);
    }

    public static void setDefaultACL(AVACL acl, boolean withAccessForCurrentUser) {
        if (acl == null) {
            throw new IllegalArgumentException("Null ACL.");
        }
        PaasClient.storageInstance().setDefaultACL(acl);
        if (withAccessForCurrentUser) {
            AVUser user = AVUser.getCurrentUser();
            AVACL defaultACL = PaasClient.storageInstance().getDefaultACL();
            defaultACL.setReadAccess(user, true);
            defaultACL.setWriteAccess(user, true);
        }
    }

    public static AVACL parseACLWithPublicAccess(boolean read, boolean write) {
        AVACL acl = new AVACL();
        acl.setPublicReadAccess(read);
        acl.setPublicWriteAccess(write);
        return acl;
    }

    public void setPublicReadAccess(boolean allowed) {
        this.allowRead(allowed, publicTag);
    }

    public void setPublicWriteAccess(boolean allowed) {
        this.allowWrite(allowed, publicTag);
    }

    public void setReadAccess(AVUser user, boolean allowed) {
        this.setReadAccess(user.getObjectId(), allowed);
    }

    public void setReadAccess(String userId, boolean allowed) {
        this.allowRead(allowed, userId);
    }

    public void setRoleReadAccess(AVRole role, boolean allowed) {
        this.setRoleReadAccess(role.getName(), allowed);
    }

    public void setRoleReadAccess(String roleName, boolean allowed) {
        this.allowRead(allowed, roleName);
    }

    public void setRoleWriteAccess(AVRole role, boolean allowed) {
        this.setRoleWriteAccess(role.getName(), allowed);
    }

    public void setRoleWriteAccess(String roleName, boolean allowed) {
        this.allowWrite(allowed, roleName);
    }

    public void setWriteAccess(AVUser user, boolean allowed) {
        this.setWriteAccess(user.getObjectId(), allowed);
    }

    public void setWriteAccess(String userId, boolean allowed) {
        this.allowWrite(allowed, userId);
    }

    Map<String, Object> getPermissionsById() {
        return this.permissionsById;
    }

    Map<String, Object> getACLMap() {
        HashMap<String, Object> aclMap = new HashMap<String, Object>();
        aclMap.put("ACL", this.getPermissionsById());
        return aclMap;
    }
}

