/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVException;
import org.json.JSONObject;

public class AVErrorUtils {
    public static final int CIRCLE_REFERENCE = 100001;
    public static final int MISSING_OBJECTID = 104;

    public static AVException createException(String content) {
        try {
            JSONObject object = new JSONObject(content);
            String errorMessage = object.getString("error");
            int code = object.getInt("code");
            return new AVException(code, errorMessage);
        }
        catch (Exception exception) {
            return new AVException(999, content);
        }
    }

    public static AVException createException(Throwable t, String content) {
        if (t instanceof AVException) {
            return (AVException)t;
        }
        if (content != null) {
            return AVErrorUtils.createException(content);
        }
        if (t != null) {
            return new AVException(t);
        }
        return new AVException(999, "unknown reason");
    }

    static int errorCode(String content) {
        int code = 0;
        try {
            JSONObject object = new JSONObject(content);
            code = object.getInt("code");
            return code;
        }
        catch (Exception exception) {
            return code;
        }
    }

    public static AVException createException(int code, String content) {
        return new AVException(code, content);
    }

    public static AVException invalidObjectIdException() {
        return AVErrorUtils.createException(104, "Invalid object id.");
    }

    public static AVException invalidQueryException() {
        return AVErrorUtils.createException(102, "Invalid query.");
    }

    public static AVException sessionMissingException() {
        return AVErrorUtils.createException(206, "No valid session token, make sure signUp or login has been called.");
    }

    public static AVException fileDownloadInConsistentFailureException() {
        return AVErrorUtils.createException(253, "Downloaded file is inconsistent with original file");
    }

    static AVException circleException() {
        return new AVException(100001, "Found a circular dependency when saving.");
    }
}

