/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.location.Location;

public class AVGeoPoint {
    static double EARTH_MEAN_RADIUS_KM = 6378.14;
    static double ONE_KM_TO_MILES = 1.609344;
    private double latitude;
    private double longitude;

    public AVGeoPoint() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public double distanceInKilometersTo(AVGeoPoint point) {
        Location start = new Location("");
        start.setLatitude(this.latitude);
        start.setLongitude(this.longitude);
        Location end = new Location("");
        end.setLatitude(point.latitude);
        end.setLongitude(point.longitude);
        return start.distanceTo(end);
    }

    public double distanceInMilesTo(AVGeoPoint point) {
        return this.distanceInKilometersTo(point) / ONE_KM_TO_MILES;
    }

    public double distanceInRadiansTo(AVGeoPoint point) {
        return this.distanceInKilometersTo(point) / EARTH_MEAN_RADIUS_KM;
    }

    public AVGeoPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double l) {
        this.latitude = l;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double l) {
        this.longitude = l;
    }
}

