/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOperationType;
import com.avos.avoscloud.SaveCallback;
import java.util.ArrayList;
import java.util.List;

public class AVOperation {
    private AVOperationType type;
    private List batchRequest = new ArrayList();
    private SaveCallback callback = null;
    private int sequence;
    private boolean last = true;

    public void setLast(boolean l) {
        this.last = l;
    }

    public boolean getLast() {
        return this.last;
    }

    public List getBatchRequest() {
        return this.batchRequest;
    }

    public boolean isSnapshotRequest() {
        return this.type == AVOperationType.kAVOperationSnapshot;
    }

    public boolean isPendingRequest() {
        return this.type == AVOperationType.kAVOperationPendingOperation;
    }

    public void setCallback(SaveCallback cb) {
        this.callback = cb;
    }

    public SaveCallback getCallback() {
        return this.callback;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void invokeCallback(AVException exception) {
        if (this.getCallback() != null) {
            this.getCallback().internalDone(exception);
        }
    }

    static AVOperation snapshotOperation(List request, SaveCallback cb) {
        return AVOperation.cloneOperation(request, cb, AVOperationType.kAVOperationSnapshot);
    }

    private static AVOperation cloneOperation(List request, SaveCallback cb, AVOperationType type) {
        AVOperation operation = new AVOperation();
        operation.batchRequest.addAll(request);
        operation.callback = cb;
        operation.type = type;
        return operation;
    }

    static AVOperation pendingOperation(List request, SaveCallback cb) {
        return AVOperation.cloneOperation(request, cb, AVOperationType.kAVOperationPendingOperation);
    }
}

