/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVOperation;
import com.avos.avoscloud.SaveCallback;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AVOperationQueue {
    private ConcurrentLinkedQueue<AVOperation> queue = new ConcurrentLinkedQueue();
    private volatile int currentSequence;

    public synchronized void increaseSequence() {
        this.currentSequence += 2;
    }

    public AVOperation addSnapshotOperation(List request, SaveCallback cb) {
        AVOperation operation = AVOperation.snapshotOperation(request, cb);
        operation.setSequence(this.currentSequence);
        this.queue.offer(operation);
        return operation;
    }

    public AVOperation addPendingOperation(List request, SaveCallback cb) {
        AVOperation operation = AVOperation.pendingOperation(request, cb);
        operation.setSequence(this.currentSequence);
        this.queue.offer(operation);
        return operation;
    }

    public AVOperation popHead() {
        return this.queue.poll();
    }

    public boolean noPendingRequest() {
        return this.queue.isEmpty();
    }

    public void clearOperationWithSequence(int seq) {
        Iterator<AVOperation> iter = this.queue.iterator();
        while (iter.hasNext()) {
            AVOperation operation = iter.next();
            if (operation.getSequence() != seq) continue;
            iter.remove();
        }
    }
}

