/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.SharedPreferences;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AVPersistenceUtils {
    private static AVPersistenceUtils instance = null;
    private static ConcurrentHashMap<String, ReentrantReadWriteLock> fileLocks = new ConcurrentHashMap();

    private static ReentrantReadWriteLock getLock(String path) {
        ReentrantReadWriteLock oldLock;
        ReentrantReadWriteLock lock = fileLocks.get(path);
        if (lock == null && (oldLock = fileLocks.putIfAbsent(path, lock = new ReentrantReadWriteLock())) != null) {
            lock = oldLock;
        }
        return lock;
    }

    public static void removeLock(String path) {
        fileLocks.remove(path);
    }

    private AVPersistenceUtils() {
    }

    public static synchronized AVPersistenceUtils sharedInstance() {
        if (instance == null) {
            instance = new AVPersistenceUtils();
        }
        return instance;
    }

    public static File getPaasDocumentDir() {
        return AVOSCloud.applicationContext.getDir("Paas", 0);
    }

    public static File getCacheDir() {
        return AVOSCloud.applicationContext.getCacheDir();
    }

    public static File getCommandCacheDir() {
        File dir = new File(AVPersistenceUtils.getCacheDir(), "CommandCache");
        dir.mkdirs();
        return dir;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LogUtil.log.d(e.toString());
        }
    }

    private static File getFile(String folderName, String fileName) {
        File file;
        if (AVUtils.isBlankString(folderName)) {
            file = new File(AVPersistenceUtils.getPaasDocumentDir(), fileName);
        } else {
            File folder = new File(AVPersistenceUtils.getPaasDocumentDir(), folderName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            file = new File(folder, fileName);
        }
        return file;
    }

    public void saveToDocumentDir(String content, String fileName) {
        this.saveToDocumentDir(content, null, fileName);
    }

    public void saveToDocumentDir(String content, String folderName, String fileName) {
        File fileForSave = AVPersistenceUtils.getFile(folderName, fileName);
        AVPersistenceUtils.saveContentToFile(content, fileForSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContentToFile(String content, File fileForSave) {
        ReentrantReadWriteLock.WriteLock writeLock = AVPersistenceUtils.getLock(fileForSave.getAbsolutePath()).writeLock();
        boolean succeed = true;
        FileOutputStream out = null;
        if (writeLock.tryLock()) {
            try {
                out = new FileOutputStream(fileForSave, false);
                out.write(content.getBytes("utf-8"));
            }
            catch (Exception e) {
                LogUtil.log.d(e.toString());
                succeed = false;
            }
            finally {
                if (out != null) {
                    AVPersistenceUtils.closeQuietly(out);
                }
                writeLock.unlock();
            }
        }
        return succeed;
    }

    public String getFromDocumentDir(String folderName, String fileName) {
        File fileForRead = AVPersistenceUtils.getFile(folderName, fileName);
        return AVPersistenceUtils.readContentFromFile(fileForRead);
    }

    public String getFromDocumentDir(String fileName) {
        return this.getFromDocumentDir(null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContentFromFile(File fileForRead) {
        block6: {
            String string2;
            ReentrantReadWriteLock.ReadLock readLock = AVPersistenceUtils.getLock(fileForRead.getAbsolutePath()).readLock();
            readLock.lock();
            FileInputStream in = null;
            InputStreamReader reader = null;
            BufferedReader breader = null;
            try {
                in = new FileInputStream(fileForRead);
                reader = new InputStreamReader((InputStream)in, "utf-8");
                breader = new BufferedReader(reader);
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = breader.readLine()) != null) {
                    sb.append(line);
                }
                string2 = sb.toString();
                AVPersistenceUtils.closeQuietly(breader);
            }
            catch (IOException e) {
                LogUtil.log.d(e.toString());
                break block6;
            }
            finally {
                AVPersistenceUtils.closeQuietly(breader);
                AVPersistenceUtils.closeQuietly(reader);
                AVPersistenceUtils.closeQuietly(in);
                readLock.unlock();
            }
            AVPersistenceUtils.closeQuietly(reader);
            AVPersistenceUtils.closeQuietly(in);
            readLock.unlock();
            return string2;
        }
        return null;
    }

    public void savePersistentSettingBoolean(String keyzone, String key, Boolean value) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(key, value.booleanValue());
        editor.commit();
    }

    public boolean getPersistentSettingBoolean(String keyzone, String key) {
        return this.getPersistentSettingBoolean(keyzone, key, false);
    }

    public boolean getPersistentSettingBoolean(String keyzone, String key, Boolean defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getBoolean(key, defaultValue.booleanValue());
    }

    public void savePersistentSettingInteger(String keyzone, String key, Integer value) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value.intValue());
        editor.commit();
    }

    public Integer getPersistentSettingInteger(String keyzone, String key, Integer defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getInt(key, defaultValue.intValue());
    }

    public void savePersistentSettingString(String keyzone, String key, String value) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getPersistentSettingString(String keyzone, String key, String defaultValue) {
        if (AVOSCloud.applicationContext == null) {
            LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
            return defaultValue;
        }
        SharedPreferences settings = AVOSCloud.applicationContext.getSharedPreferences(keyzone, 0);
        return settings.getString(key, defaultValue);
    }
}

