/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVRole;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import java.util.HashMap;
import java.util.Map;

public class AVPowerfulUtils {
    private static Map<String, Map<String, String>> powerfulTable = new HashMap<String, Map<String, String>>();
    private static final String ENDPOINT = "endpoint";
    private static final String PARSE_CLASSNAME = "dbClassName";

    public static void createSettings(String javaClassName, String endpoint, String parseClassName) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(ENDPOINT, endpoint);
        settings.put(PARSE_CLASSNAME, parseClassName);
        powerfulTable.put(javaClassName, settings);
    }

    private static void createTable() {
        AVPowerfulUtils.createSettings(AVUser.class.getSimpleName(), "users", "_User");
        AVPowerfulUtils.createSettings("_User", "users", "_User");
        AVPowerfulUtils.createSettings(AVRole.class.getSimpleName(), "roles", "_Role");
        AVPowerfulUtils.createSettings("_Role", "roles", "_Role");
        AVPowerfulUtils.createSettings(AVFile.class.getSimpleName(), "files", "_File");
        AVPowerfulUtils.createSettings("_File", "files", "_File");
    }

    private static String get(String javaClassName, String key) {
        String res = "";
        if (powerfulTable.containsKey(javaClassName) && (res = powerfulTable.get(javaClassName).get(key)) == null) {
            res = "";
        }
        return res;
    }

    private static String getAVClassEndpoint(String javaClassName, String parseClassName, String objectId) {
        String endpoint = AVPowerfulUtils.get(javaClassName, ENDPOINT);
        if (AVUtils.isBlankString(endpoint)) {
            endpoint = AVUtils.isBlankString(objectId) ? String.format("classes/%s", parseClassName) : String.format("classes/%s/%s", parseClassName, objectId);
        }
        return endpoint;
    }

    private static String getAVUserEndpoint(AVUser object) {
        String endpoint = AVPowerfulUtils.get(AVUser.class.getSimpleName(), ENDPOINT);
        if (!AVUtils.isBlankString(object.getObjectId())) {
            endpoint = String.format("%s/%s", endpoint, object.getObjectId());
        }
        return endpoint;
    }

    private static String getAVRoleEndpoint(AVRole object) {
        String endpoint = AVPowerfulUtils.get(AVRole.class.getSimpleName(), ENDPOINT);
        if (!AVUtils.isBlankString(object.getObjectId())) {
            endpoint = String.format("%s/%s", endpoint, object.getObjectId());
        }
        return endpoint;
    }

    public static String getEndpoint(String className) {
        String endpoint = AVPowerfulUtils.get(className, ENDPOINT);
        if (AVUtils.isBlankString(endpoint)) {
            if (!AVUtils.isBlankString(className)) {
                endpoint = String.format("classes/%s", className);
            } else {
                throw new AVRuntimeException("Blank class name");
            }
        }
        return endpoint;
    }

    public static String getEndpoint(Object object) {
        return AVPowerfulUtils.getEndpoint(object, false);
    }

    public static String getEndpoint(Object object, boolean post) {
        if (object instanceof AVUser) {
            AVUser parseUser = (AVUser)object;
            return AVPowerfulUtils.getAVUserEndpoint(parseUser);
        }
        if (object instanceof AVRole) {
            AVRole role = (AVRole)object;
            return AVPowerfulUtils.getAVRoleEndpoint(role);
        }
        if (object instanceof AVObject) {
            AVObject parseObject = (AVObject)object;
            Class<?> clazz = parseObject.getClass();
            String javaClassName = clazz.getSimpleName();
            String subClassName = AVObject.getSubClassName(clazz);
            if (subClassName != null) {
                return AVPowerfulUtils.getAVClassEndpoint(javaClassName, subClassName, parseObject.getObjectId());
            }
            return AVPowerfulUtils.getAVClassEndpoint(javaClassName, parseObject.getClassName(), parseObject.getObjectId());
        }
        return AVPowerfulUtils.getEndpoint(object.getClass().getSimpleName());
    }

    public static String getBatchEndpoint(String version, AVObject object) {
        return AVPowerfulUtils.getBatchEndpoint(version, object, false);
    }

    public static String getBatchEndpoint(String version, AVObject object, boolean post) {
        return String.format("/%s/%s", version, AVPowerfulUtils.getEndpoint(object, post));
    }

    public static String getEndpointByAVClassName(String className, String objectId) {
        String rootUrl = AVPowerfulUtils.getEndpoint(className);
        if (AVUtils.isBlankString(rootUrl)) {
            return rootUrl;
        }
        return String.format("%s/%s", rootUrl, objectId);
    }

    public static String getAVClassName(String className) {
        return AVPowerfulUtils.get(className, PARSE_CLASSNAME);
    }

    public static String getFollowEndPoint(String followee, String follower) {
        return String.format("users/%s/friendship/%s", followee, follower);
    }

    public static String getFollowersEndPoint(String userId) {
        return String.format("users/%s/followers", userId);
    }

    public static String getFolloweesEndPoint(String userId) {
        return String.format("users/%s/followees", userId);
    }

    public static String getFollowersAndFollowees(String userId) {
        return String.format("users/%s/followersAndFollowees", userId);
    }

    static {
        AVPowerfulUtils.createTable();
    }
}

