/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVResponse;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.CountCallback;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.FindCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.PaasClient;
import com.loopj.android.http.RequestParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVQuery<T extends AVObject> {
    private static final String TAG = "com.parse.AVQuery";
    private Class<T> clazz;
    private String className;
    Map<String, List<QueryOperation>> where;
    private List<String> include;
    private Set<String> selectedKeys;
    private int limit;
    private boolean trace;
    private int skip;
    private String order;
    private Boolean isRunning;
    private CachePolicy cachePolicy = CachePolicy.IGNORE_CACHE;
    private long maxCacheAge = -1L;
    private Map<String, String> parameters;
    private String queryPath;
    private String externalQueryPath;

    public AVQuery() {
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    List<String> getInclude() {
        return this.include;
    }

    void setInclude(List<String> include) {
        this.include = include;
    }

    Set<String> getSelectedKeys() {
        return this.selectedKeys;
    }

    void setSelectedKeys(Set<String> selectedKeys) {
        this.selectedKeys = selectedKeys;
    }

    Boolean getIsRunning() {
        return this.isRunning;
    }

    void setIsRunning(Boolean isRunning) {
        this.isRunning = isRunning;
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    String getQueryPath() {
        return this.queryPath;
    }

    void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    String getExternalQueryPath() {
        return this.externalQueryPath;
    }

    void setExternalQueryPath(String path) {
        this.externalQueryPath = path;
    }

    static String getTag() {
        return TAG;
    }

    Map<String, List<QueryOperation>> getWhere() {
        return this.where;
    }

    public String getClassName() {
        return this.className;
    }

    public AVQuery<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public AVQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public AVQuery<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public AVQuery<T> skip(int skip) {
        this.setSkip(skip);
        return this;
    }

    private void generateQueryPath() {
        if (AVUtils.isBlankString(this.queryPath)) {
            this.assembleParameters();
            this.queryPath = PaasClient.storageInstance().generateQueryPath(this.queryPath(), new RequestParams(this.getParameters()));
        }
    }

    public int getSkip() {
        return this.skip;
    }

    public AVQuery<T> setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public String getOrder() {
        return this.order;
    }

    public AVQuery<T> setOrder(String order) {
        this.order = order;
        return this;
    }

    public AVQuery<T> order(String order) {
        this.setOrder(order);
        return this;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public AVQuery<T> setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
        return this;
    }

    public CachePolicy getPolicy() {
        return this.cachePolicy;
    }

    public AVQuery<T> setPolicy(CachePolicy policy) {
        this.cachePolicy = policy;
        return this;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public AVQuery<T> setMaxCacheAge(long maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
        return this;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public AVQuery<T> setTrace(boolean trace) {
        this.trace = trace;
        return this;
    }

    public AVQuery(String theClassName) {
        this(theClassName, null);
    }

    AVQuery(String theClassName, Class<T> clazz) {
        AVUtils.checkClassName(theClassName);
        this.className = theClassName;
        this.clazz = clazz;
        this.where = new HashMap<String, List<QueryOperation>>();
        this.include = new LinkedList<String>();
        this.parameters = new HashMap<String, String>();
    }

    public static <T extends AVObject> AVQuery<T> getQuery(String theClassName) {
        return new AVQuery<T>(theClassName);
    }

    public static <T extends AVObject> AVQuery<T> getQuery(Class<T> clazz) {
        return new AVQuery<T>(AVObject.getSubClassName(clazz), clazz);
    }

    public AVQuery<T> addAscendingOrder(String key) {
        if (AVUtils.isBlankString(this.order)) {
            return this.orderByAscending(key);
        }
        this.order = String.format("%s,%s", this.order, key);
        return this;
    }

    public AVQuery<T> addDescendingOrder(String key) {
        if (AVUtils.isBlankString(this.order)) {
            return this.orderByDescending(key);
        }
        this.order = String.format("%s,-%s", this.order, key);
        return this;
    }

    public void cancel() {
    }

    public static void clearAllCachedResults() {
        AVCacheManager.clearAllCache();
    }

    public void clearCachedResult() {
        this.generateQueryPath();
        if (!AVUtils.isBlankString(this.queryPath)) {
            AVCacheManager.sharedInstance().delete(this.queryPath);
        }
    }

    public int count() throws AVException {
        final int[] value = new int[]{0};
        this.countInBackground(true, new CountCallback(){

            public void done(int count, AVException e) {
                if (e == null) {
                    value[0] = count;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return value[0];
    }

    protected int count(boolean needsLock) {
        final int[] value = new int[]{0};
        this.countInBackground(true, new CountCallback(){

            public void done(int count, AVException e) {
                value[0] = count;
            }
        });
        return value[0];
    }

    public void countInBackground(CountCallback callback) {
        this.countInBackground(false, callback);
    }

    private void countInBackground(boolean sync, CountCallback callback) {
        this.assembleParameters();
        this.parameters.put("count", Integer.toString(1));
        this.parameters.put("limit", Integer.toString(0));
        final CountCallback internalCallback = callback;
        String path = this.queryPath();
        this.queryPath = PaasClient.storageInstance().getObject(path, new RequestParams(this.getParameters()), sync, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                AVResponse resp = (AVResponse)JSON.parseObject((String)content, AVResponse.class);
                if (internalCallback != null) {
                    internalCallback.internalDone(resp.count, null);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(0, AVErrorUtils.createException(error, content));
                }
            }
        }, this.cachePolicy, this.maxCacheAge);
    }

    public List<T> find() throws AVException {
        String path = this.queryPath();
        this.assembleParameters();
        final ArrayList result = new ArrayList();
        this.queryPath = PaasClient.storageInstance().getObject(path, new RequestParams(this.getParameters()), true, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                try {
                    result.addAll(AVQuery.this.processResults(content));
                }
                catch (Exception ex) {
                    AVExceptionHolder.add(AVErrorUtils.createException(ex, null));
                }
            }

            public void onFailure(Throwable error, String content) {
                AVExceptionHolder.add(AVErrorUtils.createException(error, content));
            }
        }, this.cachePolicy, this.maxCacheAge);
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return result;
    }

    private String queryPath() {
        if (!AVUtils.isBlankString(this.externalQueryPath)) {
            return this.externalQueryPath;
        }
        return AVPowerfulUtils.getEndpoint(this.getClassName());
    }

    private Map<String, Object> whereMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        block4: for (Map.Entry<String, List<QueryOperation>> entry : this.where.entrySet()) {
            List<QueryOperation> ops = entry.getValue();
            String key = entry.getKey();
            if (key.equals("$or")) {
                ArrayList<Object> opList = new ArrayList<Object>();
                for (QueryOperation op : ops) {
                    opList.add(op.toResult());
                }
                List existsOr = (List)result.get("$or");
                if (existsOr != null) {
                    existsOr.addAll(opList);
                    continue;
                }
                result.put("$or", opList);
                continue;
            }
            switch (ops.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    for (QueryOperation op : ops) {
                        result.put(key, op.toResult());
                    }
                    continue block4;
                }
            }
            ArrayList<Object> opList = new ArrayList<Object>();
            HashMap opMap = new HashMap();
            boolean hasEqual = false;
            for (QueryOperation op : ops) {
                opList.add(op.toResult(key));
                if ("__eq".equals(op.op)) {
                    hasEqual = true;
                }
                if (hasEqual) continue;
                opMap.putAll((Map)op.toResult());
            }
            if (hasEqual) {
                List existsAnd = (List)result.get("$and");
                if (existsAnd != null) {
                    existsAnd.addAll(opList);
                    continue;
                }
                result.put("$and", opList);
                continue;
            }
            result.put(key, opMap);
        }
        return result;
    }

    public Map<String, String> assembleParameters() {
        if (this.where.keySet().size() > 0) {
            this.parameters.put("where", AVUtils.restfulServerData(this.whereMap()));
        }
        if (this.limit > 0) {
            this.parameters.put("limit", Integer.toString(this.limit));
        }
        if (this.skip > 0) {
            this.parameters.put("skip", Integer.toString(this.skip));
        }
        if (this.order != null && this.order.length() > 0) {
            this.parameters.put("order", this.order);
        }
        if (this.include != null && this.include.size() > 0) {
            String value = AVUtils.joinCollection(this.include, ",");
            this.parameters.put("include", value);
        }
        if (this.selectedKeys != null && this.selectedKeys.size() > 0) {
            String keys = AVUtils.joinCollection(this.selectedKeys, ",");
            this.parameters.put("keys", keys);
        }
        return this.parameters;
    }

    protected List<T> processResults(String content) throws Exception {
        if (AVUtils.isBlankContent(content)) {
            return Collections.emptyList();
        }
        AVResponse resp = new AVResponse();
        resp = (AVResponse)JSON.parseObject((String)content, resp.getClass());
        LinkedList<AVObject> result = new LinkedList<AVObject>();
        for (Map item : resp.results) {
            if (item == null || item.isEmpty()) continue;
            AVObject object = this.clazz != null ? (AVObject)this.clazz.newInstance() : AVUtils.objectFromClassName(this.className);
            AVUtils.copyPropertiesFromMapToAVObject(item, object);
            result.add(object);
        }
        return result;
    }

    public void findInBackground(FindCallback<T> callback) {
        this.assembleParameters();
        final FindCallback<T> internalCallback = callback;
        String path = this.queryPath();
        this.queryPath = PaasClient.storageInstance().getObject(path, new RequestParams(this.getParameters()), false, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        List result = AVQuery.this.processResults(content);
                        if (internalCallback != null) {
                            internalCallback.internalDone(result, null);
                        }
                    }
                    catch (Exception ex) {
                        if (internalCallback == null) break block3;
                        internalCallback.internalDone(null, AVErrorUtils.createException(ex, null));
                    }
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, this.cachePolicy, this.maxCacheAge);
    }

    public T get(String theObjectId) throws AVException {
        final Object[] result = new Object[]{null};
        this.getInBackground(theObjectId, true, new GetCallback<T>(){

            @Override
            public void done(T object, AVException e) {
                if (e == null) {
                    result[0] = object;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)((AVObject)result[0]);
    }

    public T getFirst() throws AVException {
        final Object[] result = new Object[]{null};
        this.getFirstInBackground(true, new GetCallback<T>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e == null) {
                    result[0] = object;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)((AVObject)result[0]);
    }

    public void getFirstInBackground(GetCallback<T> callback) {
        this.getFirstInBackground(false, callback);
    }

    private void getFirstInBackground(boolean sync, GetCallback<T> callback) {
        this.assembleParameters();
        this.parameters.put("limit", Integer.toString(1));
        this.parameters.put("order", "-updatedAt");
        final GetCallback<T> internalCallback = callback;
        PaasClient.storageInstance().getObject(this.queryPath(), new RequestParams(this.getParameters()), sync, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        List result = AVQuery.this.processResults(content);
                        if (internalCallback != null) {
                            AVObject first = null;
                            AVException error = null;
                            first = result.size() > 0 ? (AVObject)result.get(0) : null;
                            internalCallback.internalDone(first, error);
                        }
                    }
                    catch (Exception ex) {
                        if (internalCallback == null) break block3;
                        internalCallback.internalDone(null, AVErrorUtils.createException(ex, null));
                    }
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public void getInBackground(String objectId, GetCallback<T> callback) {
        final GetCallback<T> internalCallback = callback;
        this.getInBackground(objectId, false, new GetCallback<T>(){

            @Override
            public void done(T object, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(object, e);
                }
            }
        });
    }

    private void getInBackground(String objectId, boolean sync, GetCallback<T> callback) {
        String path = AVPowerfulUtils.getEndpointByAVClassName(this.getClassName(), objectId);
        final GetCallback<T> internalCallback = callback;
        this.assembleParameters();
        PaasClient.storageInstance().getObject(path, new RequestParams(this.getParameters()), sync, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                AVObject object;
                AVException error = e;
                if (AVUtils.isBlankContent(content)) {
                    object = null;
                    error = new AVException(101, "Object is not found.");
                } else {
                    object = AVUtils.newAVObjectByClassName(AVQuery.this.getClassName());
                    AVUtils.copyPropertiesFromJsonStringToAVObject(content, object);
                }
                if (internalCallback != null) {
                    internalCallback.internalDone(object, error);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    @Deprecated
    public static AVQuery<AVUser> getUserQuery() {
        return AVUser.getQuery();
    }

    public boolean hasCachedResult() {
        this.generateQueryPath();
        return !AVUtils.isBlankString(this.queryPath) && AVCacheManager.sharedInstance().hasCache(this.queryPath);
    }

    public AVQuery<T> include(String key) {
        this.include.add(key);
        return this;
    }

    public AVQuery<T> selectKeys(Collection<String> keys) {
        if (this.selectedKeys == null) {
            this.selectedKeys = new HashSet<String>();
        }
        this.selectedKeys.addAll(keys);
        return this;
    }

    public void deleteAll() throws AVException {
        AVObject.deleteAll(this.find());
    }

    public void deleteAllInBackground(final DeleteCallback cb) {
        this.findInBackground(new FindCallback<T>(){

            @Override
            public void done(List<T> parseObjects, AVException parseException) {
                if (parseException != null) {
                    cb.internalDone(null, parseException);
                } else {
                    AVObject.deleteAllInBackground(parseObjects, cb);
                }
            }
        });
    }

    public static <T extends AVObject> AVQuery<T> or(List<AVQuery<T>> queries) {
        String className = null;
        if (queries.size() > 0) {
            className = queries.get(0).getClassName();
        }
        AVQuery<T> result = new AVQuery<T>(className);
        if (queries.size() > 1) {
            for (AVQuery<T> query : queries) {
                super.addOrItems(new QueryOperation("$or", "$or", super.whereMap()));
            }
        } else {
            result.setWhere(queries.get((int)0).where);
        }
        return result;
    }

    public AVQuery<T> orderByAscending(String key) {
        this.order = AVUtils.isBlankString(this.order) ? String.format("%s", key) : String.format("%s,%s", this.order, key);
        return this;
    }

    public AVQuery<T> orderByDescending(String key) {
        this.order = AVUtils.isBlankString(this.order) ? String.format("-%s", key) : String.format("%s,-%s", this.order, key);
        return this;
    }

    public AVQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        return this.addWhereItem(key, "$in", values);
    }

    public AVQuery<T> whereContains(String key, String substring) {
        String regex = String.format(".*%s.*", substring);
        return this.whereMatches(key, regex);
    }

    public AVQuery<T> whereSizeEqual(String key, int size) {
        return this.addWhereItem(key, "$size", size);
    }

    public AVQuery<T> whereContainsAll(String key, Collection<?> values) {
        return this.addWhereItem(key, "$all", values);
    }

    public AVQuery<T> whereDoesNotExist(String key) {
        return this.addWhereItem(key, "$exists", false);
    }

    public AVQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, AVQuery<?> query) {
        Map<String, Object> map = this.createMap("className", query.className);
        map.put("where", super.whereMap());
        Map<String, Object> queryMap = this.createMap("query", map);
        queryMap.put("key", keyInQuery);
        this.addWhereItem(key, "$dontSelect", queryMap);
        return this;
    }

    public AVQuery<T> whereDoesNotMatchQuery(String key, AVQuery<?> query) {
        Map<String, Object> map = this.createMap("className", query.className);
        map.put("where", super.whereMap());
        this.addWhereItem(key, "$notInQuery", map);
        return this;
    }

    public AVQuery<T> whereEndsWith(String key, String suffix) {
        return this.whereMatches(key, String.format(".*%s$", suffix));
    }

    public AVQuery<T> whereEqualTo(String key, Object value) {
        if (value instanceof AVObject) {
            this.addWhereItem(key, "__eq", AVUtils.mapFromPointerObject((AVObject)value));
        } else {
            this.addWhereItem(key, "__eq", value);
        }
        return this;
    }

    private Map<String, Object> createMap(String cmp, Object value) {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put(cmp, value);
        return dict;
    }

    private AVQuery<T> addWhereItem(QueryOperation op) {
        List<QueryOperation> ops = this.where.get(op.key);
        if (ops == null) {
            ops = new LinkedList<QueryOperation>();
            this.where.put(op.key, ops);
        }
        this.removeDuplications(op, ops);
        ops.add(op);
        return this;
    }

    private AVQuery<T> addOrItems(QueryOperation op) {
        List<QueryOperation> ops = this.where.get("$or");
        if (ops == null) {
            ops = new LinkedList<QueryOperation>();
            this.where.put("$or", ops);
        }
        Iterator<QueryOperation> it = ops.iterator();
        while (it.hasNext()) {
            QueryOperation o = it.next();
            if (!o.equals(op)) continue;
            it.remove();
        }
        ops.add(op);
        return this;
    }

    private void removeDuplications(QueryOperation op, List<QueryOperation> ops) {
        Iterator<QueryOperation> it = ops.iterator();
        while (it.hasNext()) {
            QueryOperation o = it.next();
            if (!o.sameOp(op)) continue;
            it.remove();
        }
    }

    protected AVQuery<T> addWhereItem(String key, String op, Object value) {
        return this.addWhereItem(new QueryOperation(key, op, value));
    }

    public AVQuery<T> whereExists(String key) {
        return this.addWhereItem(key, "$exists", true);
    }

    public AVQuery<T> whereGreaterThan(String key, Object value) {
        return this.addWhereItem(key, "$gt", value);
    }

    public AVQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        return this.addWhereItem(key, "$gte", value);
    }

    public AVQuery<T> whereLessThan(String key, Object value) {
        return this.addWhereItem(key, "$lt", value);
    }

    public AVQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        return this.addWhereItem(key, "$lte", value);
    }

    public AVQuery<T> whereMatches(String key, String regex) {
        return this.addWhereItem(key, "$regex", regex);
    }

    public AVQuery<T> whereMatches(String key, String regex, String modifiers) {
        Map map = (Map)((Object)this.where.get(key));
        if (map == null) {
            this.createMap("$regex", regex);
        }
        this.addWhereItem(key, "$options", modifiers);
        return this;
    }

    public AVQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, AVQuery<?> query) {
        HashMap<String, Object> inner = new HashMap<String, Object>();
        inner.put("className", query.getClassName());
        inner.put("where", super.whereMap());
        if (query.skip > 0) {
            inner.put("skip", query.skip);
        }
        if (query.limit > 0) {
            inner.put("limit", query.limit);
        }
        if (!AVUtils.isBlankContent(query.getOrder())) {
            inner.put("order", query.getOrder());
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("query", inner);
        queryMap.put("key", keyInQuery);
        return this.addWhereItem(key, "$select", queryMap);
    }

    public AVQuery<T> whereMatchesQuery(String key, AVQuery<?> query) {
        Map<String, Object> map = this.createMap("where", super.whereMap());
        map.put("className", query.className);
        if (query.skip > 0) {
            map.put("skip", query.skip);
        }
        if (query.limit > 0) {
            map.put("limit", query.limit);
        }
        if (!AVUtils.isBlankContent(query.getOrder())) {
            map.put("order", query.getOrder());
        }
        this.addWhereItem(key, "$inQuery", map);
        return this;
    }

    public AVQuery<T> whereNear(String key, AVGeoPoint point) {
        return this.addWhereItem(key, "$nearSphere", AVUtils.mapFromGeoPoint(point));
    }

    public AVQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        return this.addWhereItem(key, "$nin", values);
    }

    public AVQuery<T> whereNotEqualTo(String key, Object value) {
        return this.addWhereItem(key, "$ne", value);
    }

    public AVQuery<T> whereStartsWith(String key, String prefix) {
        return this.whereMatches(key, String.format("^%s.*", prefix));
    }

    public AVQuery<T> whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        LinkedList<Map<String, Object>> box = new LinkedList<Map<String, Object>>();
        box.add(AVUtils.mapFromGeoPoint(southwest));
        box.add(AVUtils.mapFromGeoPoint(northeast));
        Map<String, Object> map = this.createMap("$box", box);
        return this.addWhereItem(key, "$within", map);
    }

    public AVQuery<T> whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        Map<String, Object> map = this.createMap("$nearSphere", AVUtils.mapFromGeoPoint(point));
        map.put("$maxDistanceInKilometers", maxDistance);
        this.addWhereItem(key, null, map);
        return this;
    }

    public AVQuery<T> whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        Map<String, Object> map = this.createMap("$nearSphere", AVUtils.mapFromGeoPoint(point));
        map.put("$maxDistanceInMiles", maxDistance);
        this.addWhereItem(key, null, map);
        return this;
    }

    public AVQuery<T> whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        Map<String, Object> map = this.createMap("$nearSphere", AVUtils.mapFromGeoPoint(point));
        map.put("maxDistanceInRadians", maxDistance);
        this.addWhereItem(key, null, map);
        return this;
    }

    AVQuery<T> setWhere(Map<String, List<QueryOperation>> value) {
        this.where = value;
        return this;
    }

    public static class QueryOperation {
        static final String EQUAL_OP = "__eq";
        static final String OR_OP = "$or";
        String key;
        Object value;
        String op;

        public QueryOperation(String key, String op, Object value) {
            this.key = key;
            this.op = op;
            this.value = value;
        }

        public Object toResult() {
            if (this.op == null || this.op.equals(EQUAL_OP) || this.op.equals(OR_OP)) {
                return this.value;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.op, this.value);
            return map;
        }

        public Object toResult(String key) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(key, this.toResult());
            return map;
        }

        public boolean sameOp(QueryOperation other) {
            return TextUtils.equals((CharSequence)this.key, (CharSequence)other.key) && TextUtils.equals((CharSequence)this.op, (CharSequence)other.op);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryOperation other = (QueryOperation)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.op == null ? other.op != null : !this.op.equals(other.op)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachePolicy {
        CACHE_ELSE_NETWORK,
        CACHE_ONLY,
        CACHE_THEN_NETWORK,
        IGNORE_CACHE,
        NETWORK_ELSE_CACHE,
        NETWORK_ONLY;

    }
}

