/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;

abstract class AVUploader {
    protected final AVFile parseFile;
    protected SaveCallback saveCallback;
    protected ProgressCallback progressCallback;
    protected long totalSize;
    private volatile boolean cancelled = false;
    private volatile boolean complete = false;
    private volatile Thread workerThread;
    protected final int defaultFileKeyLength = 40;

    protected AVUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        this.parseFile = parseFile;
        this.saveCallback = saveCallback;
        this.progressCallback = progressCallback;
        this.cancelled = false;
        this.complete = false;
    }

    abstract AVException doWork();

    public void execute() {
        this.workerThread = new Thread(new Runnable(){

            public void run() {
                AVException exception = AVUploader.this.doWork();
                if (!AVUploader.this.cancelled) {
                    AVUploader.this.complete = true;
                    AVUploader.this.onPostExecute(exception);
                } else {
                    AVUploader.this.onPostExecute(AVErrorUtils.createException(999, "Uploading file task is canceled."));
                }
            }
        });
        this.workerThread.start();
    }

    protected AVException doInBackground(Void ... arg0) {
        return this.doWork();
    }

    protected void onProgressUpdate(Integer progress) {
        if (this.progressCallback != null) {
            this.progressCallback.internalDone(progress, null);
        }
    }

    protected void onPostExecute(AVException result) {
        if (this.saveCallback != null) {
            this.saveCallback.internalDone(result);
        }
    }

    protected void onCancelled() {
        LogUtil.log.d("upload cancel");
    }

    public boolean cancel(boolean interrupt) {
        if (this.cancelled || this.complete) {
            return false;
        }
        this.cancelled = true;
        if (interrupt) {
            this.interruptImmediately();
        }
        this.onCancelled();
        return true;
    }

    public void interruptImmediately() {
        if (this.workerThread != null) {
            this.workerThread.interrupt();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void publishProgress(int percentage) {
        this.onProgressUpdate(percentage);
    }
}

