/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.PaasClient;
import com.loopj.android.http.RequestParams;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFetchCallbackWithFailureRetry<T extends AVObject>
extends GenericObjectCallback {
    GenericObjectCallback callback;
    boolean retry = true;
    String relativePath;
    RequestParams parameters;
    boolean sync;
    Map<String, String> inputHeader;
    AVQuery.CachePolicy policy;

    public DataFetchCallbackWithFailureRetry(String relativePath, RequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy) {
        this.relativePath = relativePath;
        this.parameters = parameters;
        this.sync = sync;
        this.inputHeader = inputHeader;
        this.callback = callback;
        this.policy = policy;
    }

    @Override
    public void onSuccess(String content, AVException e) {
        if (this.callback != null) {
            this.callback.onSuccess(content, e);
        }
    }

    @Override
    public void onFailure(Throwable error, String content) {
        if (this.retry && error != null && this.isLastModifyCacheMissingError(error.getMessage())) {
            this.retry = false;
            PaasClient.storageInstance().getObject(this.relativePath, this.parameters, this.sync, this.inputHeader, this.callback, this.policy, false);
        } else if (this.callback != null) {
            this.callback.onFailure(error, content);
        }
    }

    private boolean isLastModifyCacheMissingError(String errorString) {
        return "Cache Missing".equalsIgnoreCase(errorString);
    }
}

