/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.loopj.android.http.AsyncHttpResponseHandler;
import org.apache.http.Header;

public class PostHttpResponseHandler
extends AsyncHttpResponseHandler {
    private GenericObjectCallback callback;

    PostHttpResponseHandler(GenericObjectCallback cb) {
        this.callback = cb;
    }

    void setCallback(GenericObjectCallback cb) {
        this.callback = cb;
    }

    GenericObjectCallback getCallback() {
        return this.callback;
    }

    public void onSuccess(int statusCode, Header[] headers, byte[] body) {
        int code;
        String content = AVUtils.stringFromBytes(body);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.i(content);
        }
        if ((code = AVErrorUtils.errorCode(content)) > 0) {
            if (this.getCallback() != null) {
                this.getCallback().onFailure(AVErrorUtils.createException(code, content), content);
            }
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onSuccess(content, null);
        }
    }

    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        String content = AVUtils.stringFromBytes(responseBody);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.e(content + "\nerror:" + error);
        }
        if (this.getCallback() != null) {
            this.getCallback().onFailure(error, content);
        }
    }
}

