/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.BaseOp;
import com.avos.avoscloud.ops.CompoundOp;
import com.avos.avoscloud.ops.IncrementOp;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetOp
extends BaseOp {
    private Object value;

    public SetOp() {
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    public SetOp(String key, Object value) {
        super(key, AVOp.OpType.Set);
        this.value = value;
    }

    @Override
    public AVObject apply(AVObject obj) {
        obj.put(this.key, obj);
        return obj;
    }

    @Override
    public Map<String, Object> encodeOp() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(this.key, AVUtils.getParsedObject(this.value));
        return hashMap;
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        switch (other.type()) {
            case Null: {
                return this;
            }
            case Set: {
                this.value = other.cast(SetOp.class).value;
                return this;
            }
            case Add: 
            case AddUnique: 
            case Remove: 
            case AddRelation: 
            case RemoveRelation: {
                return new CompoundOp(this.key, this, other);
            }
            case Increment: {
                if (!(this.value instanceof Number)) {
                    throw new IllegalArgumentException("Could not increment non-numberic value.");
                }
                long v = ((Number)this.value).longValue();
                this.value = v += (long)other.cast(IncrementOp.class).amount.intValue();
                return this;
            }
            case Delete: {
                return other;
            }
            case Compound: {
                other.cast(CompoundOp.class).addFirst(this);
                return other;
            }
        }
        throw new IllegalStateException("Unknow op type " + (Object)((Object)other.type()));
    }
}

