/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

class AsyncHttpRequest
implements Runnable {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private final HttpUriRequest request;
    private final ResponseHandlerInterface responseHandler;
    private int executionCount;

    public AsyncHttpRequest(AbstractHttpClient client, HttpContext context, HttpUriRequest request, ResponseHandlerInterface responseHandler) {
        this.client = client;
        this.context = context;
        this.request = request;
        this.responseHandler = responseHandler;
    }

    @Override
    public void run() {
        block4: {
            if (this.responseHandler != null) {
                this.responseHandler.sendStartMessage();
            }
            try {
                this.makeRequestWithRetries();
            }
            catch (IOException e) {
                if (this.responseHandler == null) break block4;
                this.responseHandler.sendFailureMessage(0, null, null, e);
            }
        }
        if (this.responseHandler != null) {
            this.responseHandler.sendFinishMessage();
        }
    }

    private void makeRequest() throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            if (this.request.getURI().getScheme() == null) {
                throw new MalformedURLException("No valid URI scheme was provided");
            }
            HttpResponse response = this.client.execute(this.request, this.context);
            if (!Thread.currentThread().isInterrupted() && this.responseHandler != null) {
                this.responseHandler.sendResponseMessage(response);
            }
        }
    }

    private void makeRequestWithRetries() throws IOException {
        boolean retry = true;
        IOException cause = null;
        HttpRequestRetryHandler retryHandler = this.client.getHttpRequestRetryHandler();
        try {
            while (retry) {
                try {
                    this.makeRequest();
                    return;
                }
                catch (UnknownHostException e) {
                    cause = new IOException("UnknownHostException exception: " + e.getMessage());
                    retry = this.executionCount > 0 && retryHandler.retryRequest(cause, ++this.executionCount, this.context);
                }
                catch (NullPointerException e) {
                    cause = new IOException("NPE in HttpClient: " + e.getMessage());
                    retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
                }
                catch (IOException e) {
                    cause = e;
                    retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
                }
                if (!retry || this.responseHandler == null) continue;
                this.responseHandler.sendRetryMessage();
            }
        }
        catch (Exception e) {
            Log.e((String)"AsyncHttpRequest", (String)"Unhandled exception origin cause", (Throwable)e);
            cause = new IOException("Unhandled exception: " + e.getMessage());
        }
        throw cause;
    }
}

