/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.Base64OutputStream;
import com.loopj.android.http.RequestParams;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

class JsonStreamerEntity
implements HttpEntity {
    private static final String LOG_TAG = "JsonStreamerEntity";
    private static final UnsupportedOperationException ERR_UNSUPPORTED = new UnsupportedOperationException("Unsupported operation in this implementation.");
    private static final int BUFFER_SIZE = 2048;
    private static final StringBuilder BUILDER = new StringBuilder(2764);
    private static final byte[] JSON_TRUE = "true".getBytes();
    private static final byte[] JSON_FALSE = "false".getBytes();
    private static final byte[] JSON_NULL = "null".getBytes();
    private static final byte[] STREAM_NAME = JsonStreamerEntity.escape("name");
    private static final byte[] STREAM_TYPE = JsonStreamerEntity.escape("type");
    private static final byte[] STREAM_CONTENTS = JsonStreamerEntity.escape("contents");
    private static final byte[] STREAM_ELAPSED = JsonStreamerEntity.escape("_elapsed");
    private static final Header HEADER_JSON_CONTENT = new BasicHeader("Content-Type", "application/json");
    private static final Header HEADER_GZIP_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final Map<String, Object> kvParams = new HashMap<String, Object>();
    private final Map<String, RequestParams.StreamWrapper> streamParams = new HashMap<String, RequestParams.StreamWrapper>();
    private final Header contentEncoding;

    public JsonStreamerEntity(boolean contentEncoding) {
        this.contentEncoding = contentEncoding ? HEADER_GZIP_ENCODING : null;
    }

    public void addPart(String key, Object value) {
        this.kvParams.put(key, value);
    }

    public void addPart(String key, InputStream inputStream, String name, String type) {
        if (type == null) {
            type = APPLICATION_OCTET_STREAM;
        }
        this.streamParams.put(key, new RequestParams.StreamWrapper(inputStream, name, type));
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public Header getContentType() {
        return HEADER_JSON_CONTENT;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw ERR_UNSUPPORTED;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalStateException("Output stream cannot be null.");
        }
        long now = System.currentTimeMillis();
        FilterOutputStream upload = null != this.contentEncoding ? new GZIPOutputStream((OutputStream)new BufferedOutputStream(outstream), 2048) : new BufferedOutputStream(outstream);
        ((OutputStream)upload).write(123);
        Set<String> keys = this.kvParams.keySet();
        for (String key : keys) {
            ((OutputStream)upload).write(JsonStreamerEntity.escape(key));
            ((OutputStream)upload).write(58);
            Object value = this.kvParams.get(key);
            if (value instanceof Boolean) {
                ((OutputStream)upload).write((Boolean)value != false ? JSON_TRUE : JSON_FALSE);
            } else if (value instanceof Long) {
                ((OutputStream)upload).write((((Number)value).longValue() + "").getBytes());
            } else if (value instanceof Double) {
                ((OutputStream)upload).write((((Number)value).doubleValue() + "").getBytes());
            } else if (value instanceof Float) {
                ((OutputStream)upload).write((((Number)value).floatValue() + "").getBytes());
            } else if (value instanceof Integer) {
                ((OutputStream)upload).write((((Number)value).intValue() + "").getBytes());
            } else {
                ((OutputStream)upload).write(value.toString().getBytes());
            }
            ((OutputStream)upload).write(44);
        }
        byte[] buffer = new byte[2048];
        keys = this.streamParams.keySet();
        for (String key : keys) {
            int bytesRead;
            RequestParams.StreamWrapper entry = this.streamParams.get(key);
            ((OutputStream)upload).write(JsonStreamerEntity.escape(key));
            ((OutputStream)upload).write(58);
            ((OutputStream)upload).write(123);
            ((OutputStream)upload).write(STREAM_NAME);
            ((OutputStream)upload).write(58);
            ((OutputStream)upload).write(JsonStreamerEntity.escape(entry.name));
            ((OutputStream)upload).write(44);
            ((OutputStream)upload).write(STREAM_TYPE);
            ((OutputStream)upload).write(58);
            ((OutputStream)upload).write(JsonStreamerEntity.escape(entry.contentType));
            ((OutputStream)upload).write(44);
            ((OutputStream)upload).write(STREAM_CONTENTS);
            ((OutputStream)upload).write(58);
            ((OutputStream)upload).write(34);
            Base64OutputStream outputStream = new Base64OutputStream(upload, 18);
            while ((bytesRead = entry.inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            ((OutputStream)upload).write(34);
            ((OutputStream)upload).write(125);
            ((OutputStream)upload).write(44);
        }
        ((OutputStream)upload).write(STREAM_ELAPSED);
        ((OutputStream)upload).write(58);
        long elapsedTime = System.currentTimeMillis() - now;
        ((OutputStream)upload).write((elapsedTime + "}").getBytes());
        Log.i((String)LOG_TAG, (String)("Uploaded JSON in " + Math.floor(elapsedTime / 1000L) + " seconds"));
        ((OutputStream)upload).flush();
        ((OutputStream)upload).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] escape(String string) {
        if (string == null) {
            return JSON_NULL;
        }
        BUILDER.append('\"');
        int length = string.length();
        int pos = -1;
        block12: while (++pos < length) {
            char ch = string.charAt(pos);
            switch (ch) {
                case '\"': {
                    BUILDER.append("\\\"");
                    continue block12;
                }
                case '\\': {
                    BUILDER.append("\\\\");
                    continue block12;
                }
                case '\b': {
                    BUILDER.append("\\b");
                    continue block12;
                }
                case '\f': {
                    BUILDER.append("\\f");
                    continue block12;
                }
                case '\n': {
                    BUILDER.append("\\n");
                    continue block12;
                }
                case '\r': {
                    BUILDER.append("\\r");
                    continue block12;
                }
                case '\t': {
                    BUILDER.append("\\t");
                    continue block12;
                }
            }
            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                String intString = Integer.toHexString(ch);
                BUILDER.append("\\u");
                int intLength = 4 - intString.length();
                for (int zero = 0; zero < intLength; ++zero) {
                    BUILDER.append('0');
                }
                BUILDER.append(intString.toUpperCase(Locale.US));
                continue;
            }
            BUILDER.append(ch);
        }
        BUILDER.append('\"');
        try {
            byte[] byArray = BUILDER.toString().getBytes();
            return byArray;
        }
        finally {
            BUILDER.setLength(0);
        }
    }
}

