/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.overlayutil;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.Toast;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.PolylineOptions;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.overlayutil.OverlayManager;
import com.baidu.mapapi.search.route.DrivingRouteLine;
import java.util.ArrayList;
import java.util.List;

public class DrivingRouteOverlay
extends OverlayManager {
    private DrivingRouteLine c = null;

    public DrivingRouteOverlay(BaiduMap baiduMap) {
        super(baiduMap);
    }

    @Override
    public final List<OverlayOptions> getOverlayOptions() {
        Object object;
        if (this.c == null) {
            return null;
        }
        ArrayList<OverlayOptions> arrayList = new ArrayList<OverlayOptions>();
        if (this.c.getAllStep() != null && this.c.getAllStep().size() > 0) {
            object = new ArrayList();
            for (DrivingRouteLine.DrivingStep drivingStep : this.c.getAllStep()) {
                Bundle bundle = new Bundle();
                bundle.putInt("index", this.c.getAllStep().indexOf(drivingStep));
                if (drivingStep.getEntrace() != null) {
                    arrayList.add(new MarkerOptions().position(drivingStep.getEntrace().getLocation()).anchor(0.5f, 0.5f).zIndex(10).rotate(360 - drivingStep.getDirection()).extraInfo(bundle).icon(BitmapDescriptorFactory.fromAsset("Icon_line_node.png")));
                }
                if (this.c.getAllStep().indexOf(drivingStep) != this.c.getAllStep().size() - 1 || drivingStep.getExit() == null) continue;
                arrayList.add(new MarkerOptions().position(drivingStep.getExit().getLocation()).anchor(0.5f, 0.5f).zIndex(10).icon(BitmapDescriptorFactory.fromAsset("Icon_line_node.png")));
            }
        }
        if (this.c.getStarting() != null) {
            arrayList.add(new MarkerOptions().position(this.c.getStarting().getLocation()).icon(this.getStartMarker() != null ? this.getStartMarker() : BitmapDescriptorFactory.fromAsset("Icon_start.png")).zIndex(10));
        }
        if (this.c.getTerminal() != null) {
            arrayList.add(new MarkerOptions().position(this.c.getTerminal().getLocation()).icon(this.getTerminalMarker() != null ? this.getTerminalMarker() : BitmapDescriptorFactory.fromAsset("Icon_end.png")).zIndex(10));
        }
        if (this.c.getAllStep() != null && this.c.getAllStep().size() > 0) {
            object = null;
            List list = this.c.getAllStep();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DrivingRouteLine.DrivingStep drivingStep = (DrivingRouteLine.DrivingStep)list.get(i2);
                if (drivingStep.getWayPoints() == null || drivingStep.getWayPoints().size() <= 0) continue;
                ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
                if (object != null) {
                    arrayList2.add((LatLng)object);
                }
                List<LatLng> list2 = drivingStep.getWayPoints();
                arrayList2.addAll(list2);
                arrayList.add(new PolylineOptions().points(arrayList2).width(10).color(Color.argb((int)178, (int)0, (int)78, (int)255)).zIndex(0));
                object = list2.get(list2.size() - 1);
            }
        }
        return arrayList;
    }

    public void setData(DrivingRouteLine drivingRouteLine) {
        this.c = drivingRouteLine;
    }

    public BitmapDescriptor getStartMarker() {
        return null;
    }

    public BitmapDescriptor getTerminalMarker() {
        return null;
    }

    public boolean onRouteNodeClick(int n2) {
        if (this.c.getAllStep() != null && this.c.getAllStep().get(n2) != null) {
            Toast.makeText((Context)com.baidu.mapapi.a.a().d(), (CharSequence)((DrivingRouteLine.DrivingStep)this.c.getAllStep().get(n2)).getInstructions(), (int)1).show();
        }
        return false;
    }

    @Override
    public final boolean onMarkerClick(Marker marker) {
        if (marker.getExtraInfo() != null) {
            this.onRouteNodeClick(marker.getExtraInfo().getInt("index"));
        }
        return true;
    }
}

