/*
 * Decompiled with CFR 0.152.
 */
package com.qq.e.v2.util;

import com.qq.e.v2.util.GDTLogger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    public static JSONArray bytesToJsonArray(byte[] byArray) {
        JSONArray jSONArray = new JSONArray();
        if (byArray != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                jSONArray.put((int)byArray[i2]);
            }
        }
        return jSONArray;
    }

    public static byte[] jsonArrayToBytes(JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        int n2 = jSONArray.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                byArray[i2] = (byte)jSONArray.getInt(i2);
                continue;
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
        return byArray;
    }

    public static void jsonToMap(JSONObject jSONObject, Map<String, Object> map) throws JSONException {
        if (jSONObject == null || map == null) {
            return;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            map.put(string, jSONObject.get(string));
        }
    }

    public static JSONObject mapToJson(Map<?, ?> object) {
        JSONObject jSONObject = new JSONObject();
        try {
            for (Map.Entry entry : object.entrySet()) {
                Object object2 = entry.getKey();
                if (!(object2 instanceof String)) continue;
                object2 = (String)object2;
                Object v = entry.getValue();
                if (v instanceof Map) {
                    jSONObject.put(object2, (Object)JsonUtil.mapToJson((Map)v));
                    continue;
                }
                if (v instanceof Collection) {
                    jSONObject.put(object2, (Object)new JSONArray((Collection)v));
                    continue;
                }
                jSONObject.putOpt(object2, v);
            }
        }
        catch (JSONException jSONException) {
            GDTLogger.e("build Json error", jSONException);
        }
        return jSONObject;
    }
}

